// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm_test

import (
	"context"
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/aws/awserr"
	"github.com/aws/aws-sdk-go-v2/aws/external"
	"github.com/aws/aws-sdk-go-v2/service/devicefarm"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To create a new device pool
//
// The following example creates a new device pool named MyDevicePool inside an existing
// project.
func ExampleClient_CreateDevicePoolRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.CreateDevicePoolInput{
		Description: aws.String("My Android devices"),
		Name:        aws.String("MyDevicePool"),
		ProjectArn:  aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
	}

	req := svc.CreateDevicePoolRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a new project
//
// The following example creates a new project named MyProject.
func ExampleClient_CreateProjectRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.CreateProjectInput{
		Name: aws.String("MyProject"),
	}

	req := svc.CreateProjectRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			case devicefarm.ErrCodeTagOperationException:
				fmt.Println(devicefarm.ErrCodeTagOperationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a remote access session
//
// The following example creates a remote access session named MySession.
func ExampleClient_CreateRemoteAccessSessionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.CreateRemoteAccessSessionInput{
		Configuration: &devicefarm.CreateRemoteAccessSessionConfiguration{
			BillingMethod: devicefarm.BillingMethodMetered,
		},
		DeviceArn:  aws.String("arn:aws:devicefarm:us-west-2::device:123EXAMPLE"),
		Name:       aws.String("MySession"),
		ProjectArn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
	}

	req := svc.CreateRemoteAccessSessionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a new test package upload
//
// The following example creates a new Appium Python test package upload inside an existing
// project.
func ExampleClient_CreateUploadRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.CreateUploadInput{
		Name:       aws.String("MyAppiumPythonUpload"),
		ProjectArn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
		Type:       devicefarm.UploadTypeAppiumPythonTestPackage,
	}

	req := svc.CreateUploadRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a device pool
//
// The following example deletes a specific device pool.
func ExampleClient_DeleteDevicePoolRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.DeleteDevicePoolInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2::devicepool:123-456-EXAMPLE-GUID"),
	}

	req := svc.DeleteDevicePoolRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a project
//
// The following example deletes a specific project.
func ExampleClient_DeleteProjectRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.DeleteProjectInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
	}

	req := svc.DeleteProjectRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a specific remote access session
//
// The following example deletes a specific remote access session.
func ExampleClient_DeleteRemoteAccessSessionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.DeleteRemoteAccessSessionInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:session:EXAMPLE-GUID-123-456"),
	}

	req := svc.DeleteRemoteAccessSessionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a run
//
// The following example deletes a specific test run.
func ExampleClient_DeleteRunRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.DeleteRunInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:run:EXAMPLE-GUID-123-456"),
	}

	req := svc.DeleteRunRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a specific upload
//
// The following example deletes a specific upload.
func ExampleClient_DeleteUploadRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.DeleteUploadInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:upload:EXAMPLE-GUID-123-456"),
	}

	req := svc.DeleteUploadRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about account settings
//
// The following example returns information about your Device Farm account settings.
func ExampleClient_GetAccountSettingsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.GetAccountSettingsInput{}

	req := svc.GetAccountSettingsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a device
//
// The following example returns information about a specific device.
func ExampleClient_GetDeviceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.GetDeviceInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2::device:123EXAMPLE"),
	}

	req := svc.GetDeviceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a device pool
//
// The following example returns information about a specific device pool, given a project
// ARN.
func ExampleClient_GetDevicePoolRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.GetDevicePoolInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
	}

	req := svc.GetDevicePoolRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about the compatibility of a device pool
//
// The following example returns information about the compatibility of a specific device
// pool, given its ARN.
func ExampleClient_GetDevicePoolCompatibilityRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.GetDevicePoolCompatibilityInput{
		AppArn:        aws.String("arn:aws:devicefarm:us-west-2::app:123-456-EXAMPLE-GUID"),
		DevicePoolArn: aws.String("arn:aws:devicefarm:us-west-2::devicepool:123-456-EXAMPLE-GUID"),
		TestType:      devicefarm.TestTypeAppiumPython,
	}

	req := svc.GetDevicePoolCompatibilityRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a job
//
// The following example returns information about a specific job.
func ExampleClient_GetJobRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.GetJobInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2::job:123-456-EXAMPLE-GUID"),
	}

	req := svc.GetJobRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get status information about device offerings
//
// The following example returns information about Device Farm offerings available to
// your account.
func ExampleClient_GetOfferingStatusRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.GetOfferingStatusInput{
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE="),
	}

	req := svc.GetOfferingStatusRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeNotEligibleException:
				fmt.Println(devicefarm.ErrCodeNotEligibleException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a project
//
// The following example gets information about a specific project.
func ExampleClient_GetProjectRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.GetProjectInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:5e01a8c7-c861-4c0a-b1d5-12345EXAMPLE"),
	}

	req := svc.GetProjectRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a remote access session
//
// The following example gets a specific remote access session.
func ExampleClient_GetRemoteAccessSessionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.GetRemoteAccessSessionInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:session:EXAMPLE-GUID-123-456"),
	}

	req := svc.GetRemoteAccessSessionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a test run
//
// The following example gets information about a specific test run.
func ExampleClient_GetRunRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.GetRunInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:run:5e01a8c7-c861-4c0a-b1d5-5ec6e6c6dd23/0fcac17b-6122-44d7-ae5a-12345EXAMPLE"),
	}

	req := svc.GetRunRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a test suite
//
// The following example gets information about a specific test suite.
func ExampleClient_GetSuiteRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.GetSuiteInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:suite:EXAMPLE-GUID-123-456"),
	}

	req := svc.GetSuiteRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a specific test
//
// The following example gets information about a specific test.
func ExampleClient_GetTestRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.GetTestInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:test:EXAMPLE-GUID-123-456"),
	}

	req := svc.GetTestRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a specific upload
//
// The following example gets information about a specific upload.
func ExampleClient_GetUploadRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.GetUploadInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:upload:EXAMPLE-GUID-123-456"),
	}

	req := svc.GetUploadRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To install to a remote access session
//
// The following example installs a specific app to a device in a specific remote access
// session.
func ExampleClient_InstallToRemoteAccessSessionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.InstallToRemoteAccessSessionInput{
		AppArn:                 aws.String("arn:aws:devicefarm:us-west-2:123456789101:app:EXAMPLE-GUID-123-456"),
		RemoteAccessSessionArn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:session:EXAMPLE-GUID-123-456"),
	}

	req := svc.InstallToRemoteAccessSessionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list artifacts for a resource
//
// The following example lists screenshot artifacts for a specific run.
func ExampleClient_ListArtifactsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.ListArtifactsInput{
		Arn:  aws.String("arn:aws:devicefarm:us-west-2:123456789101:run:EXAMPLE-GUID-123-456"),
		Type: devicefarm.ArtifactCategoryScreenshot,
	}

	req := svc.ListArtifactsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about device pools
//
// The following example returns information about the private device pools in a specific
// project.
func ExampleClient_ListDevicePoolsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.ListDevicePoolsInput{
		Arn:  aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
		Type: devicefarm.DevicePoolTypePrivate,
	}

	req := svc.ListDevicePoolsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about devices
//
// The following example returns information about the available devices in a specific
// project.
func ExampleClient_ListDevicesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.ListDevicesInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
	}

	req := svc.ListDevicesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about jobs
//
// The following example returns information about jobs in a specific project.
func ExampleClient_ListJobsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.ListJobsInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
	}

	req := svc.ListJobsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about device offering transactions
//
// The following example returns information about Device Farm offering transactions.
func ExampleClient_ListOfferingTransactionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.ListOfferingTransactionsInput{
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE="),
	}

	req := svc.ListOfferingTransactionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeNotEligibleException:
				fmt.Println(devicefarm.ErrCodeNotEligibleException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about device offerings
//
// The following example returns information about available device offerings.
func ExampleClient_ListOfferingsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.ListOfferingsInput{
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE="),
	}

	req := svc.ListOfferingsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeNotEligibleException:
				fmt.Println(devicefarm.ErrCodeNotEligibleException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a Device Farm project
//
// The following example returns information about the specified project in Device Farm.
func ExampleClient_ListProjectsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.ListProjectsInput{
		Arn:       aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:7ad300ed-8183-41a7-bf94-12345EXAMPLE"),
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE"),
	}

	req := svc.ListProjectsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a remote access session
//
// The following example returns information about a specific Device Farm remote access
// session.
func ExampleClient_ListRemoteAccessSessionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.ListRemoteAccessSessionsInput{
		Arn:       aws.String("arn:aws:devicefarm:us-west-2:123456789101:session:EXAMPLE-GUID-123-456"),
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE="),
	}

	req := svc.ListRemoteAccessSessionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a test run
//
// The following example returns information about a specific test run.
func ExampleClient_ListRunsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.ListRunsInput{
		Arn:       aws.String("arn:aws:devicefarm:us-west-2:123456789101:run:5e01a8c7-c861-4c0a-b1d5-5ec6e6c6dd23/0fcac17b-6122-44d7-ae5a-12345EXAMPLE"),
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE"),
	}

	req := svc.ListRunsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about samples
//
// The following example returns information about samples, given a specific Device
// Farm project.
func ExampleClient_ListSamplesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.ListSamplesInput{
		Arn:       aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE"),
	}

	req := svc.ListSamplesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about suites
//
// The following example returns information about suites, given a specific Device Farm
// job.
func ExampleClient_ListSuitesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.ListSuitesInput{
		Arn:       aws.String("arn:aws:devicefarm:us-west-2:123456789101:job:EXAMPLE-GUID-123-456"),
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE"),
	}

	req := svc.ListSuitesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about tests
//
// The following example returns information about tests, given a specific Device Farm
// project.
func ExampleClient_ListTestsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.ListTestsInput{
		Arn:       aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE"),
	}

	req := svc.ListTestsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about unique problems
//
// The following example returns information about unique problems, given a specific
// Device Farm project.
func ExampleClient_ListUniqueProblemsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.ListUniqueProblemsInput{
		Arn:       aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE"),
	}

	req := svc.ListUniqueProblemsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about uploads
//
// The following example returns information about uploads, given a specific Device
// Farm project.
func ExampleClient_ListUploadsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.ListUploadsInput{
		Arn:       aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
		NextToken: aws.String("RW5DdDJkMWYwZjM2MzM2VHVpOHJIUXlDUXlhc2QzRGViYnc9SEXAMPLE"),
	}

	req := svc.ListUploadsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To purchase a device slot offering
//
// The following example purchases a specific device slot offering.
func ExampleClient_PurchaseOfferingRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.PurchaseOfferingInput{
		OfferingId: aws.String("D68B3C05-1BA6-4360-BC69-12345EXAMPLE"),
		Quantity:   aws.Int64(1),
	}

	req := svc.PurchaseOfferingRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeNotEligibleException:
				fmt.Println(devicefarm.ErrCodeNotEligibleException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To renew a device slot offering
//
// The following example renews a specific device slot offering.
func ExampleClient_RenewOfferingRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.RenewOfferingInput{
		OfferingId: aws.String("D68B3C05-1BA6-4360-BC69-12345EXAMPLE"),
		Quantity:   aws.Int64(1),
	}

	req := svc.RenewOfferingRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeNotEligibleException:
				fmt.Println(devicefarm.ErrCodeNotEligibleException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To schedule a test run
//
// The following example schedules a test run named MyRun.
func ExampleClient_ScheduleRunRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.ScheduleRunInput{
		DevicePoolArn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:pool:EXAMPLE-GUID-123-456"),
		Name:          aws.String("MyRun"),
		ProjectArn:    aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:EXAMPLE-GUID-123-456"),
		Test: &devicefarm.ScheduleRunTest{
			TestPackageArn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:test:EXAMPLE-GUID-123-456"),
			Type:           devicefarm.TestTypeAppiumJavaJunit,
		},
	}

	req := svc.ScheduleRunRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeIdempotencyException:
				fmt.Println(devicefarm.ErrCodeIdempotencyException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To stop a test run
//
// The following example stops a specific test run.
func ExampleClient_StopRunRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.StopRunInput{
		Arn: aws.String("arn:aws:devicefarm:us-west-2:123456789101:run:EXAMPLE-GUID-123-456"),
	}

	req := svc.StopRunRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a device pool
//
// The following example updates the specified device pool with a new name and description.
// It also enables remote access of devices in the device pool.
func ExampleClient_UpdateDevicePoolRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.UpdateDevicePoolInput{
		Arn:         aws.String("arn:aws:devicefarm:us-west-2::devicepool:082d10e5-d7d7-48a5-ba5c-12345EXAMPLE"),
		Description: aws.String("NewDescription"),
		Name:        aws.String("NewName"),
		Rules: []devicefarm.Rule{
			{
				Attribute: devicefarm.DeviceAttributeRemoteAccessEnabled,
				Operator:  devicefarm.RuleOperatorEquals,
				Value:     aws.String("True"),
			},
		},
	}

	req := svc.UpdateDevicePoolRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a device pool
//
// The following example updates the specified project with a new name.
func ExampleClient_UpdateProjectRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := devicefarm.New(cfg)
	input := &devicefarm.UpdateProjectInput{
		Arn:  aws.String("arn:aws:devicefarm:us-west-2:123456789101:project:8f75187d-101e-4625-accc-12345EXAMPLE"),
		Name: aws.String("NewName"),
	}

	req := svc.UpdateProjectRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case devicefarm.ErrCodeArgumentException:
				fmt.Println(devicefarm.ErrCodeArgumentException, aerr.Error())
			case devicefarm.ErrCodeNotFoundException:
				fmt.Println(devicefarm.ErrCodeNotFoundException, aerr.Error())
			case devicefarm.ErrCodeLimitExceededException:
				fmt.Println(devicefarm.ErrCodeLimitExceededException, aerr.Error())
			case devicefarm.ErrCodeServiceAccountException:
				fmt.Println(devicefarm.ErrCodeServiceAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
