// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RejectVpcEndpointConnectionsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the service.
	//
	// ServiceId is a required field
	ServiceId *string `type:"string" required:"true"`

	// The IDs of one or more VPC endpoints.
	//
	// VpcEndpointIds is a required field
	VpcEndpointIds []string `locationName:"VpcEndpointId" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s RejectVpcEndpointConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectVpcEndpointConnectionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RejectVpcEndpointConnectionsInput"}

	if s.ServiceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceId"))
	}

	if s.VpcEndpointIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpcEndpointIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RejectVpcEndpointConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the endpoints that were not rejected, if applicable.
	Unsuccessful []UnsuccessfulItem `locationName:"unsuccessful" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s RejectVpcEndpointConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opRejectVpcEndpointConnections = "RejectVpcEndpointConnections"

// RejectVpcEndpointConnectionsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Rejects one or more VPC endpoint connection requests to your VPC endpoint
// service.
//
//    // Example sending a request using RejectVpcEndpointConnectionsRequest.
//    req := client.RejectVpcEndpointConnectionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RejectVpcEndpointConnections
func (c *Client) RejectVpcEndpointConnectionsRequest(input *RejectVpcEndpointConnectionsInput) RejectVpcEndpointConnectionsRequest {
	op := &aws.Operation{
		Name:       opRejectVpcEndpointConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RejectVpcEndpointConnectionsInput{}
	}

	req := c.newRequest(op, input, &RejectVpcEndpointConnectionsOutput{})
	return RejectVpcEndpointConnectionsRequest{Request: req, Input: input, Copy: c.RejectVpcEndpointConnectionsRequest}
}

// RejectVpcEndpointConnectionsRequest is the request type for the
// RejectVpcEndpointConnections API operation.
type RejectVpcEndpointConnectionsRequest struct {
	*aws.Request
	Input *RejectVpcEndpointConnectionsInput
	Copy  func(*RejectVpcEndpointConnectionsInput) RejectVpcEndpointConnectionsRequest
}

// Send marshals and sends the RejectVpcEndpointConnections API request.
func (r RejectVpcEndpointConnectionsRequest) Send(ctx context.Context) (*RejectVpcEndpointConnectionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RejectVpcEndpointConnectionsResponse{
		RejectVpcEndpointConnectionsOutput: r.Request.Data.(*RejectVpcEndpointConnectionsOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RejectVpcEndpointConnectionsResponse is the response type for the
// RejectVpcEndpointConnections API operation.
type RejectVpcEndpointConnectionsResponse struct {
	*RejectVpcEndpointConnectionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RejectVpcEndpointConnections request.
func (r *RejectVpcEndpointConnectionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
