// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kendra

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type UpdateIndexInput struct {
	_ struct{} `type:"structure"`

	// A new description for the index.
	Description *string `min:"1" type:"string"`

	// The document metadata to update.
	DocumentMetadataConfigurationUpdates []DocumentMetadataConfiguration `type:"list"`

	// The identifier of the index to update.
	//
	// Id is a required field
	Id *string `min:"36" type:"string" required:"true"`

	// The name of the index to update.
	Name *string `min:"1" type:"string"`

	// A new IAM role that gives Amazon Kendra permission to access your Amazon
	// CloudWatch logs.
	RoleArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateIndexInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIndexInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateIndexInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 36))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 1))
	}
	if s.DocumentMetadataConfigurationUpdates != nil {
		for i, v := range s.DocumentMetadataConfigurationUpdates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DocumentMetadataConfigurationUpdates", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateIndexOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateIndexOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateIndex = "UpdateIndex"

// UpdateIndexRequest returns a request value for making API operation for
// AWSKendraFrontendService.
//
// Updates an existing Amazon Kendra index.
//
//    // Example sending a request using UpdateIndexRequest.
//    req := client.UpdateIndexRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateIndex
func (c *Client) UpdateIndexRequest(input *UpdateIndexInput) UpdateIndexRequest {
	op := &aws.Operation{
		Name:       opUpdateIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateIndexInput{}
	}

	req := c.newRequest(op, input, &UpdateIndexOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UpdateIndexRequest{Request: req, Input: input, Copy: c.UpdateIndexRequest}
}

// UpdateIndexRequest is the request type for the
// UpdateIndex API operation.
type UpdateIndexRequest struct {
	*aws.Request
	Input *UpdateIndexInput
	Copy  func(*UpdateIndexInput) UpdateIndexRequest
}

// Send marshals and sends the UpdateIndex API request.
func (r UpdateIndexRequest) Send(ctx context.Context) (*UpdateIndexResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateIndexResponse{
		UpdateIndexOutput: r.Request.Data.(*UpdateIndexOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateIndexResponse is the response type for the
// UpdateIndex API operation.
type UpdateIndexResponse struct {
	*UpdateIndexOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateIndex request.
func (r *UpdateIndexResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
