// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicequotas

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisassociateServiceQuotaTemplateInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateServiceQuotaTemplateInput) String() string {
	return awsutil.Prettify(s)
}

type DisassociateServiceQuotaTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateServiceQuotaTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateServiceQuotaTemplate = "DisassociateServiceQuotaTemplate"

// DisassociateServiceQuotaTemplateRequest returns a request value for making API operation for
// Service Quotas.
//
// Disables the Service Quotas template. Once the template is disabled, it does
// not request quota increases for new accounts in your organization. Disabling
// the quota template does not apply the quota increase requests from the template.
//
// Related operations
//
//    * To enable the quota template, call AssociateServiceQuotaTemplate.
//
//    * To delete a specific service quota from the template, use DeleteServiceQuotaIncreaseRequestFromTemplate.
//
//    // Example sending a request using DisassociateServiceQuotaTemplateRequest.
//    req := client.DisassociateServiceQuotaTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DisassociateServiceQuotaTemplate
func (c *Client) DisassociateServiceQuotaTemplateRequest(input *DisassociateServiceQuotaTemplateInput) DisassociateServiceQuotaTemplateRequest {
	op := &aws.Operation{
		Name:       opDisassociateServiceQuotaTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateServiceQuotaTemplateInput{}
	}

	req := c.newRequest(op, input, &DisassociateServiceQuotaTemplateOutput{})
	return DisassociateServiceQuotaTemplateRequest{Request: req, Input: input, Copy: c.DisassociateServiceQuotaTemplateRequest}
}

// DisassociateServiceQuotaTemplateRequest is the request type for the
// DisassociateServiceQuotaTemplate API operation.
type DisassociateServiceQuotaTemplateRequest struct {
	*aws.Request
	Input *DisassociateServiceQuotaTemplateInput
	Copy  func(*DisassociateServiceQuotaTemplateInput) DisassociateServiceQuotaTemplateRequest
}

// Send marshals and sends the DisassociateServiceQuotaTemplate API request.
func (r DisassociateServiceQuotaTemplateRequest) Send(ctx context.Context) (*DisassociateServiceQuotaTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateServiceQuotaTemplateResponse{
		DisassociateServiceQuotaTemplateOutput: r.Request.Data.(*DisassociateServiceQuotaTemplateOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateServiceQuotaTemplateResponse is the response type for the
// DisassociateServiceQuotaTemplate API operation.
type DisassociateServiceQuotaTemplateResponse struct {
	*DisassociateServiceQuotaTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateServiceQuotaTemplate request.
func (r *DisassociateServiceQuotaTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
