// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package schemas

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UnlockServiceLinkedRoleInput struct {
	_ struct{} `type:"structure"`

	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UnlockServiceLinkedRoleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnlockServiceLinkedRoleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UnlockServiceLinkedRoleInput"}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UnlockServiceLinkedRoleInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UnlockServiceLinkedRoleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnlockServiceLinkedRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UnlockServiceLinkedRoleOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUnlockServiceLinkedRole = "UnlockServiceLinkedRole"

// UnlockServiceLinkedRoleRequest returns a request value for making API operation for
// Schemas.
//
//    // Example sending a request using UnlockServiceLinkedRoleRequest.
//    req := client.UnlockServiceLinkedRoleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UnlockServiceLinkedRole
func (c *Client) UnlockServiceLinkedRoleRequest(input *UnlockServiceLinkedRoleInput) UnlockServiceLinkedRoleRequest {
	op := &aws.Operation{
		Name:       opUnlockServiceLinkedRole,
		HTTPMethod: "POST",
		HTTPPath:   "/slr-deletion/unlock",
	}

	if input == nil {
		input = &UnlockServiceLinkedRoleInput{}
	}

	req := c.newRequest(op, input, &UnlockServiceLinkedRoleOutput{})
	return UnlockServiceLinkedRoleRequest{Request: req, Input: input, Copy: c.UnlockServiceLinkedRoleRequest}
}

// UnlockServiceLinkedRoleRequest is the request type for the
// UnlockServiceLinkedRole API operation.
type UnlockServiceLinkedRoleRequest struct {
	*aws.Request
	Input *UnlockServiceLinkedRoleInput
	Copy  func(*UnlockServiceLinkedRoleInput) UnlockServiceLinkedRoleRequest
}

// Send marshals and sends the UnlockServiceLinkedRole API request.
func (r UnlockServiceLinkedRoleRequest) Send(ctx context.Context) (*UnlockServiceLinkedRoleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UnlockServiceLinkedRoleResponse{
		UnlockServiceLinkedRoleOutput: r.Request.Data.(*UnlockServiceLinkedRoleOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UnlockServiceLinkedRoleResponse is the response type for the
// UnlockServiceLinkedRole API operation.
type UnlockServiceLinkedRoleResponse struct {
	*UnlockServiceLinkedRoleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UnlockServiceLinkedRole request.
func (r *UnlockServiceLinkedRoleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
