// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationdiscoveryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetDiscoverySummaryInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetDiscoverySummaryInput) String() string {
	return awsutil.Prettify(s)
}

type GetDiscoverySummaryOutput struct {
	_ struct{} `type:"structure"`

	// Details about discovered agents, including agent status and health.
	AgentSummary *CustomerAgentInfo `locationName:"agentSummary" type:"structure"`

	// The number of applications discovered.
	Applications *int64 `locationName:"applications" type:"long"`

	// Details about discovered connectors, including connector status and health.
	ConnectorSummary *CustomerConnectorInfo `locationName:"connectorSummary" type:"structure"`

	// The number of servers discovered.
	Servers *int64 `locationName:"servers" type:"long"`

	// The number of servers mapped to applications.
	ServersMappedToApplications *int64 `locationName:"serversMappedToApplications" type:"long"`

	// The number of servers mapped to tags.
	ServersMappedtoTags *int64 `locationName:"serversMappedtoTags" type:"long"`
}

// String returns the string representation
func (s GetDiscoverySummaryOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetDiscoverySummary = "GetDiscoverySummary"

// GetDiscoverySummaryRequest returns a request value for making API operation for
// AWS Application Discovery Service.
//
// Retrieves a short summary of discovered assets.
//
// This API operation takes no request parameters and is called as is at the
// command prompt as shown in the example.
//
//    // Example sending a request using GetDiscoverySummaryRequest.
//    req := client.GetDiscoverySummaryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/GetDiscoverySummary
func (c *Client) GetDiscoverySummaryRequest(input *GetDiscoverySummaryInput) GetDiscoverySummaryRequest {
	op := &aws.Operation{
		Name:       opGetDiscoverySummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDiscoverySummaryInput{}
	}

	req := c.newRequest(op, input, &GetDiscoverySummaryOutput{})
	return GetDiscoverySummaryRequest{Request: req, Input: input, Copy: c.GetDiscoverySummaryRequest}
}

// GetDiscoverySummaryRequest is the request type for the
// GetDiscoverySummary API operation.
type GetDiscoverySummaryRequest struct {
	*aws.Request
	Input *GetDiscoverySummaryInput
	Copy  func(*GetDiscoverySummaryInput) GetDiscoverySummaryRequest
}

// Send marshals and sends the GetDiscoverySummary API request.
func (r GetDiscoverySummaryRequest) Send(ctx context.Context) (*GetDiscoverySummaryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDiscoverySummaryResponse{
		GetDiscoverySummaryOutput: r.Request.Data.(*GetDiscoverySummaryOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDiscoverySummaryResponse is the response type for the
// GetDiscoverySummary API operation.
type GetDiscoverySummaryResponse struct {
	*GetDiscoverySummaryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDiscoverySummary request.
func (r *GetDiscoverySummaryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
