// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeReplicationInstancesInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the describe action.
	//
	// Valid filter names: replication-instance-arn | replication-instance-id |
	// replication-instance-class | engine-version
	Filters []Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeReplicationInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeReplicationInstancesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeReplicationInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The replication instances described.
	ReplicationInstances []ReplicationInstance `type:"list"`
}

// String returns the string representation
func (s DescribeReplicationInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeReplicationInstances = "DescribeReplicationInstances"

// DescribeReplicationInstancesRequest returns a request value for making API operation for
// AWS Database Migration Service.
//
// Returns information about replication instances for your account in the current
// region.
//
//    // Example sending a request using DescribeReplicationInstancesRequest.
//    req := client.DescribeReplicationInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances
func (c *Client) DescribeReplicationInstancesRequest(input *DescribeReplicationInstancesInput) DescribeReplicationInstancesRequest {
	op := &aws.Operation{
		Name:       opDescribeReplicationInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationInstancesInput{}
	}

	req := c.newRequest(op, input, &DescribeReplicationInstancesOutput{})
	return DescribeReplicationInstancesRequest{Request: req, Input: input, Copy: c.DescribeReplicationInstancesRequest}
}

// DescribeReplicationInstancesRequest is the request type for the
// DescribeReplicationInstances API operation.
type DescribeReplicationInstancesRequest struct {
	*aws.Request
	Input *DescribeReplicationInstancesInput
	Copy  func(*DescribeReplicationInstancesInput) DescribeReplicationInstancesRequest
}

// Send marshals and sends the DescribeReplicationInstances API request.
func (r DescribeReplicationInstancesRequest) Send(ctx context.Context) (*DescribeReplicationInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeReplicationInstancesResponse{
		DescribeReplicationInstancesOutput: r.Request.Data.(*DescribeReplicationInstancesOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeReplicationInstancesRequestPaginator returns a paginator for DescribeReplicationInstances.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeReplicationInstancesRequest(input)
//   p := databasemigrationservice.NewDescribeReplicationInstancesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeReplicationInstancesPaginator(req DescribeReplicationInstancesRequest) DescribeReplicationInstancesPaginator {
	return DescribeReplicationInstancesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeReplicationInstancesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeReplicationInstancesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeReplicationInstancesPaginator struct {
	aws.Pager
}

func (p *DescribeReplicationInstancesPaginator) CurrentPage() *DescribeReplicationInstancesOutput {
	return p.Pager.CurrentPage().(*DescribeReplicationInstancesOutput)
}

// DescribeReplicationInstancesResponse is the response type for the
// DescribeReplicationInstances API operation.
type DescribeReplicationInstancesResponse struct {
	*DescribeReplicationInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeReplicationInstances request.
func (r *DescribeReplicationInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
