// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glacier

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Provides options for initiating a multipart upload to an Amazon S3 Glacier
// vault.
type InitiateMultipartUploadInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The archive description that you are uploading in parts.
	//
	// The part size must be a megabyte (1024 KB) multiplied by a power of 2, for
	// example 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB), 8388608 (8 MB), and
	// so on. The minimum allowable part size is 1 MB, and the maximum is 4 GB (4096
	// MB).
	ArchiveDescription *string `location:"header" locationName:"x-amz-archive-description" type:"string"`

	// The size of each part except the last, in bytes. The last part can be smaller
	// than this part size.
	PartSize *string `location:"header" locationName:"x-amz-part-size" type:"string"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s InitiateMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InitiateMultipartUploadInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InitiateMultipartUploadInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.VaultName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VaultName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InitiateMultipartUploadInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ArchiveDescription != nil {
		v := *s.ArchiveDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-archive-description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PartSize != nil {
		v := *s.PartSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-part-size", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VaultName != nil {
		v := *s.VaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "vaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The Amazon S3 Glacier response to your request.
type InitiateMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	// The relative URI path of the multipart upload ID Amazon S3 Glacier created.
	Location *string `location:"header" locationName:"Location" type:"string"`

	// The ID of the multipart upload. This value is also included as part of the
	// location.
	UploadId *string `location:"header" locationName:"x-amz-multipart-upload-id" type:"string"`
}

// String returns the string representation
func (s InitiateMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InitiateMultipartUploadOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Location != nil {
		v := *s.Location

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Location", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UploadId != nil {
		v := *s.UploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-multipart-upload-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opInitiateMultipartUpload = "InitiateMultipartUpload"

// InitiateMultipartUploadRequest returns a request value for making API operation for
// Amazon Glacier.
//
// This operation initiates a multipart upload. Amazon S3 Glacier creates a
// multipart upload resource and returns its ID in the response. The multipart
// upload ID is used in subsequent requests to upload parts of an archive (see
// UploadMultipartPart).
//
// When you initiate a multipart upload, you specify the part size in number
// of bytes. The part size must be a megabyte (1024 KB) multiplied by a power
// of 2-for example, 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB), 8388608
// (8 MB), and so on. The minimum allowable part size is 1 MB, and the maximum
// is 4 GB.
//
// Every part you upload to this resource (see UploadMultipartPart), except
// the last one, must have the same size. The last one can be the same size
// or smaller. For example, suppose you want to upload a 16.2 MB file. If you
// initiate the multipart upload with a part size of 4 MB, you will upload four
// parts of 4 MB each and one part of 0.2 MB.
//
// You don't need to know the size of the archive when you start a multipart
// upload because Amazon S3 Glacier does not require you to specify the overall
// archive size.
//
// After you complete the multipart upload, Amazon S3 Glacier (Glacier) removes
// the multipart upload resource referenced by the ID. Glacier also removes
// the multipart upload resource if you cancel the multipart upload or it may
// be removed if there is no activity for a period of 24 hours.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Uploading Large Archives
// in Parts (Multipart Upload) (https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html)
// and Initiate Multipart Upload (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-initiate-upload.html)
// in the Amazon Glacier Developer Guide.
//
//    // Example sending a request using InitiateMultipartUploadRequest.
//    req := client.InitiateMultipartUploadRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) InitiateMultipartUploadRequest(input *InitiateMultipartUploadInput) InitiateMultipartUploadRequest {
	op := &aws.Operation{
		Name:       opInitiateMultipartUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/multipart-uploads",
	}

	if input == nil {
		input = &InitiateMultipartUploadInput{}
	}

	req := c.newRequest(op, input, &InitiateMultipartUploadOutput{})
	return InitiateMultipartUploadRequest{Request: req, Input: input, Copy: c.InitiateMultipartUploadRequest}
}

// InitiateMultipartUploadRequest is the request type for the
// InitiateMultipartUpload API operation.
type InitiateMultipartUploadRequest struct {
	*aws.Request
	Input *InitiateMultipartUploadInput
	Copy  func(*InitiateMultipartUploadInput) InitiateMultipartUploadRequest
}

// Send marshals and sends the InitiateMultipartUpload API request.
func (r InitiateMultipartUploadRequest) Send(ctx context.Context) (*InitiateMultipartUploadResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &InitiateMultipartUploadResponse{
		InitiateMultipartUploadOutput: r.Request.Data.(*InitiateMultipartUploadOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// InitiateMultipartUploadResponse is the response type for the
// InitiateMultipartUpload API operation.
type InitiateMultipartUploadResponse struct {
	*InitiateMultipartUploadOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// InitiateMultipartUpload request.
func (r *InitiateMultipartUploadResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
