// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package managedblockchain

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// A policy type that defines the voting rules for the network. The rules decide
// if a proposal is approved. Approval may be based on criteria such as the
// percentage of YES votes and the duration of the proposal. The policy applies
// to all proposals and is specified when the network is created.
type ApprovalThresholdPolicy struct {
	_ struct{} `type:"structure"`

	// The duration from the time that a proposal is created until it expires. If
	// members cast neither the required number of YES votes to approve the proposal
	// nor the number of NO votes required to reject it before the duration expires,
	// the proposal is EXPIRED and ProposalActions are not carried out.
	ProposalDurationInHours *int64 `min:"1" type:"integer"`

	// Determines whether the vote percentage must be greater than the ThresholdPercentage
	// or must be greater than or equal to the ThreholdPercentage to be approved.
	ThresholdComparator ThresholdComparator `type:"string" enum:"true"`

	// The percentage of votes among all members that must be YES for a proposal
	// to be approved. For example, a ThresholdPercentage value of 50 indicates
	// 50%. The ThresholdComparator determines the precise comparison. If a ThresholdPercentage
	// value of 50 is specified on a network with 10 members, along with a ThresholdComparator
	// value of GREATER_THAN, this indicates that 6 YES votes are required for the
	// proposal to be approved.
	ThresholdPercentage *int64 `type:"integer"`
}

// String returns the string representation
func (s ApprovalThresholdPolicy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApprovalThresholdPolicy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ApprovalThresholdPolicy"}
	if s.ProposalDurationInHours != nil && *s.ProposalDurationInHours < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ProposalDurationInHours", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ApprovalThresholdPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.ProposalDurationInHours != nil {
		v := *s.ProposalDurationInHours

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProposalDurationInHours", protocol.Int64Value(v), metadata)
	}
	if len(s.ThresholdComparator) > 0 {
		v := s.ThresholdComparator

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThresholdComparator", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ThresholdPercentage != nil {
		v := *s.ThresholdPercentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThresholdPercentage", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An invitation to an AWS account to create a member and join the network.
type Invitation struct {
	_ struct{} `type:"structure"`

	// The date and time that the invitation was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The date and time that the invitation expires. This is the CreationDate plus
	// the ProposalDurationInHours that is specified in the ProposalThresholdPolicy.
	// After this date and time, the invitee can no longer create a member and join
	// the network using this InvitationId.
	ExpirationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unique identifier for the invitation.
	InvitationId *string `min:"1" type:"string"`

	// A summary of network configuration properties.
	NetworkSummary *NetworkSummary `type:"structure"`

	// The status of the invitation:
	//
	//    * PENDING - The invitee has not created a member to join the network,
	//    and the invitation has not yet expired.
	//
	//    * ACCEPTING - The invitee has begun creating a member, and creation has
	//    not yet completed.
	//
	//    * ACCEPTED - The invitee created a member and joined the network using
	//    the InvitationID.
	//
	//    * REJECTED - The invitee rejected the invitation.
	//
	//    * EXPIRED - The invitee neither created a member nor rejected the invitation
	//    before the ExpirationDate.
	Status InvitationStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s Invitation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Invitation) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.ExpirationDate != nil {
		v := *s.ExpirationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExpirationDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.InvitationId != nil {
		v := *s.InvitationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InvitationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NetworkSummary != nil {
		v := s.NetworkSummary

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "NetworkSummary", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An action to invite a specific AWS account to create a member and join the
// network. The InviteAction is carried out when a Proposal is APPROVED.
type InviteAction struct {
	_ struct{} `type:"structure"`

	// The AWS account ID to invite.
	//
	// Principal is a required field
	Principal *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InviteAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InviteAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InviteAction"}

	if s.Principal == nil {
		invalidParams.Add(aws.NewErrParamRequired("Principal"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InviteAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.Principal != nil {
		v := *s.Principal

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Principal", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Member configuration properties.
type Member struct {
	_ struct{} `type:"structure"`

	// The date and time that the member was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// An optional description for the member.
	Description *string `type:"string"`

	// Attributes relevant to a member for the blockchain framework that the Managed
	// Blockchain network uses.
	FrameworkAttributes *MemberFrameworkAttributes `type:"structure"`

	// The unique identifier of the member.
	Id *string `min:"1" type:"string"`

	// The name of the member.
	Name *string `min:"1" type:"string"`

	// The unique identifier of the network to which the member belongs.
	NetworkId *string `min:"1" type:"string"`

	// The status of a member.
	//
	//    * CREATING - The AWS account is in the process of creating a member.
	//
	//    * AVAILABLE - The member has been created and can participate in the network.
	//
	//    * CREATE_FAILED - The AWS account attempted to create a member and creation
	//    failed.
	//
	//    * DELETING - The member and all associated resources are in the process
	//    of being deleted. Either the AWS account that owns the member deleted
	//    it, or the member is being deleted as the result of an APPROVED PROPOSAL
	//    to remove the member.
	//
	//    * DELETED - The member can no longer participate on the network and all
	//    associated resources are deleted. Either the AWS account that owns the
	//    member deleted it, or the member is being deleted as the result of an
	//    APPROVED PROPOSAL to remove the member.
	Status MemberStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s Member) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Member) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FrameworkAttributes != nil {
		v := s.FrameworkAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "FrameworkAttributes", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NetworkId != nil {
		v := *s.NetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Configuration properties of the member.
type MemberConfiguration struct {
	_ struct{} `type:"structure"`

	// An optional description of the member.
	Description *string `type:"string"`

	// Configuration properties of the blockchain framework relevant to the member.
	//
	// FrameworkConfiguration is a required field
	FrameworkConfiguration *MemberFrameworkConfiguration `type:"structure" required:"true"`

	// The name of the member.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MemberConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MemberConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MemberConfiguration"}

	if s.FrameworkConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("FrameworkConfiguration"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.FrameworkConfiguration != nil {
		if err := s.FrameworkConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FrameworkConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MemberConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FrameworkConfiguration != nil {
		v := s.FrameworkConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "FrameworkConfiguration", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Attributes of Hyperledger Fabric for a member in a Managed Blockchain network
// using the Hyperledger Fabric framework.
type MemberFabricAttributes struct {
	_ struct{} `type:"structure"`

	// The user name for the initial administrator user for the member.
	AdminUsername *string `min:"1" type:"string"`

	// The endpoint used to access the member's certificate authority.
	CaEndpoint *string `type:"string"`
}

// String returns the string representation
func (s MemberFabricAttributes) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MemberFabricAttributes) MarshalFields(e protocol.FieldEncoder) error {
	if s.AdminUsername != nil {
		v := *s.AdminUsername

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AdminUsername", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CaEndpoint != nil {
		v := *s.CaEndpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CaEndpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Configuration properties for Hyperledger Fabric for a member in a Managed
// Blockchain network using the Hyperledger Fabric framework.
type MemberFabricConfiguration struct {
	_ struct{} `type:"structure"`

	// The password for the member's initial administrative user. The AdminPassword
	// must be at least eight characters long and no more than 32 characters. It
	// must contain at least one uppercase letter, one lowercase letter, and one
	// digit. It cannot have a single quote(‘), double quote(“), forward slash(/),
	// backward slash(\), @, or a space.
	//
	// AdminPassword is a required field
	AdminPassword *string `min:"8" type:"string" required:"true" sensitive:"true"`

	// The user name for the member's initial administrative user.
	//
	// AdminUsername is a required field
	AdminUsername *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MemberFabricConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MemberFabricConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MemberFabricConfiguration"}

	if s.AdminPassword == nil {
		invalidParams.Add(aws.NewErrParamRequired("AdminPassword"))
	}
	if s.AdminPassword != nil && len(*s.AdminPassword) < 8 {
		invalidParams.Add(aws.NewErrParamMinLen("AdminPassword", 8))
	}

	if s.AdminUsername == nil {
		invalidParams.Add(aws.NewErrParamRequired("AdminUsername"))
	}
	if s.AdminUsername != nil && len(*s.AdminUsername) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AdminUsername", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MemberFabricConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.AdminPassword != nil {
		v := *s.AdminPassword

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AdminPassword", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AdminUsername != nil {
		v := *s.AdminUsername

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AdminUsername", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Attributes relevant to a member for the blockchain framework that the Managed
// Blockchain network uses.
type MemberFrameworkAttributes struct {
	_ struct{} `type:"structure"`

	// Attributes of Hyperledger Fabric relevant to a member on a Managed Blockchain
	// network that uses Hyperledger Fabric.
	Fabric *MemberFabricAttributes `type:"structure"`
}

// String returns the string representation
func (s MemberFrameworkAttributes) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MemberFrameworkAttributes) MarshalFields(e protocol.FieldEncoder) error {
	if s.Fabric != nil {
		v := s.Fabric

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Fabric", v, metadata)
	}
	return nil
}

// Configuration properties relevant to a member for the blockchain framework
// that the Managed Blockchain network uses.
type MemberFrameworkConfiguration struct {
	_ struct{} `type:"structure"`

	// Attributes of Hyperledger Fabric for a member on a Managed Blockchain network
	// that uses Hyperledger Fabric.
	Fabric *MemberFabricConfiguration `type:"structure"`
}

// String returns the string representation
func (s MemberFrameworkConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MemberFrameworkConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MemberFrameworkConfiguration"}
	if s.Fabric != nil {
		if err := s.Fabric.Validate(); err != nil {
			invalidParams.AddNested("Fabric", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MemberFrameworkConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Fabric != nil {
		v := s.Fabric

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Fabric", v, metadata)
	}
	return nil
}

// A summary of configuration properties for a member.
type MemberSummary struct {
	_ struct{} `type:"structure"`

	// The date and time that the member was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// An optional description of the member.
	Description *string `type:"string"`

	// The unique identifier of the member.
	Id *string `min:"1" type:"string"`

	// An indicator of whether the member is owned by your AWS account or a different
	// AWS account.
	IsOwned *bool `type:"boolean"`

	// The name of the member.
	Name *string `min:"1" type:"string"`

	// The status of the member.
	//
	//    * CREATING - The AWS account is in the process of creating a member.
	//
	//    * AVAILABLE - The member has been created and can participate in the network.
	//
	//    * CREATE_FAILED - The AWS account attempted to create a member and creation
	//    failed.
	//
	//    * DELETING - The member and all associated resources are in the process
	//    of being deleted. Either the AWS account that owns the member deleted
	//    it, or the member is being deleted as the result of an APPROVED PROPOSAL
	//    to remove the member.
	//
	//    * DELETED - The member can no longer participate on the network and all
	//    associated resources are deleted. Either the AWS account that owns the
	//    member deleted it, or the member is being deleted as the result of an
	//    APPROVED PROPOSAL to remove the member.
	Status MemberStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s MemberSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MemberSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsOwned != nil {
		v := *s.IsOwned

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsOwned", protocol.BoolValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Network configuration properties.
type Network struct {
	_ struct{} `type:"structure"`

	// The date and time that the network was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Attributes of the blockchain framework for the network.
	Description *string `type:"string"`

	// The blockchain framework that the network uses.
	Framework Framework `type:"string" enum:"true"`

	// Attributes of the blockchain framework that the network uses.
	FrameworkAttributes *NetworkFrameworkAttributes `type:"structure"`

	// The version of the blockchain framework that the network uses.
	FrameworkVersion *string `min:"1" type:"string"`

	// The unique identifier of the network.
	Id *string `min:"1" type:"string"`

	// The name of the network.
	Name *string `min:"1" type:"string"`

	// The current status of the network.
	Status NetworkStatus `type:"string" enum:"true"`

	// The voting rules for the network to decide if a proposal is accepted.
	VotingPolicy *VotingPolicy `type:"structure"`

	// The VPC endpoint service name of the VPC endpoint service of the network.
	// Members use the VPC endpoint service name to create a VPC endpoint to access
	// network resources.
	VpcEndpointServiceName *string `type:"string"`
}

// String returns the string representation
func (s Network) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Network) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Framework) > 0 {
		v := s.Framework

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Framework", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FrameworkAttributes != nil {
		v := s.FrameworkAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "FrameworkAttributes", v, metadata)
	}
	if s.FrameworkVersion != nil {
		v := *s.FrameworkVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FrameworkVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.VotingPolicy != nil {
		v := s.VotingPolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VotingPolicy", v, metadata)
	}
	if s.VpcEndpointServiceName != nil {
		v := *s.VpcEndpointServiceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VpcEndpointServiceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Attributes of Hyperledger Fabric for a network.
type NetworkFabricAttributes struct {
	_ struct{} `type:"structure"`

	// The edition of Amazon Managed Blockchain that Hyperledger Fabric uses. For
	// more information, see Amazon Managed Blockchain Pricing (https://aws.amazon.com/managed-blockchain/pricing/).
	Edition Edition `type:"string" enum:"true"`

	// The endpoint of the ordering service for the network.
	OrderingServiceEndpoint *string `type:"string"`
}

// String returns the string representation
func (s NetworkFabricAttributes) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NetworkFabricAttributes) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Edition) > 0 {
		v := s.Edition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Edition", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.OrderingServiceEndpoint != nil {
		v := *s.OrderingServiceEndpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OrderingServiceEndpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Hyperledger Fabric configuration properties for the network.
type NetworkFabricConfiguration struct {
	_ struct{} `type:"structure"`

	// The edition of Amazon Managed Blockchain that the network uses. For more
	// information, see Amazon Managed Blockchain Pricing (https://aws.amazon.com/managed-blockchain/pricing/).
	//
	// Edition is a required field
	Edition Edition `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s NetworkFabricConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkFabricConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NetworkFabricConfiguration"}
	if len(s.Edition) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Edition"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NetworkFabricConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Edition) > 0 {
		v := s.Edition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Edition", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Attributes relevant to the network for the blockchain framework that the
// network uses.
type NetworkFrameworkAttributes struct {
	_ struct{} `type:"structure"`

	// Attributes of Hyperledger Fabric for a Managed Blockchain network that uses
	// Hyperledger Fabric.
	Fabric *NetworkFabricAttributes `type:"structure"`
}

// String returns the string representation
func (s NetworkFrameworkAttributes) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NetworkFrameworkAttributes) MarshalFields(e protocol.FieldEncoder) error {
	if s.Fabric != nil {
		v := s.Fabric

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Fabric", v, metadata)
	}
	return nil
}

// Configuration properties relevant to the network for the blockchain framework
// that the network uses.
type NetworkFrameworkConfiguration struct {
	_ struct{} `type:"structure"`

	// Hyperledger Fabric configuration properties for a Managed Blockchain network
	// that uses Hyperledger Fabric.
	Fabric *NetworkFabricConfiguration `type:"structure"`
}

// String returns the string representation
func (s NetworkFrameworkConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkFrameworkConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NetworkFrameworkConfiguration"}
	if s.Fabric != nil {
		if err := s.Fabric.Validate(); err != nil {
			invalidParams.AddNested("Fabric", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NetworkFrameworkConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Fabric != nil {
		v := s.Fabric

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Fabric", v, metadata)
	}
	return nil
}

// A summary of network configuration properties.
type NetworkSummary struct {
	_ struct{} `type:"structure"`

	// The date and time that the network was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// An optional description of the network.
	Description *string `type:"string"`

	// The blockchain framework that the network uses.
	Framework Framework `type:"string" enum:"true"`

	// The version of the blockchain framework that the network uses.
	FrameworkVersion *string `min:"1" type:"string"`

	// The unique identifier of the network.
	Id *string `min:"1" type:"string"`

	// The name of the network.
	Name *string `min:"1" type:"string"`

	// The current status of the network.
	Status NetworkStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s NetworkSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NetworkSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Framework) > 0 {
		v := s.Framework

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Framework", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FrameworkVersion != nil {
		v := *s.FrameworkVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FrameworkVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Configuration properties of a peer node.
type Node struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which the node exists.
	AvailabilityZone *string `type:"string"`

	// The date and time that the node was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Attributes of the blockchain framework being used.
	FrameworkAttributes *NodeFrameworkAttributes `type:"structure"`

	// The unique identifier of the node.
	Id *string `min:"1" type:"string"`

	// The instance type of the node.
	InstanceType *string `type:"string"`

	// The unique identifier of the member to which the node belongs.
	MemberId *string `min:"1" type:"string"`

	// The unique identifier of the network that the node is in.
	NetworkId *string `min:"1" type:"string"`

	// The status of the node.
	Status NodeStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s Node) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Node) MarshalFields(e protocol.FieldEncoder) error {
	if s.AvailabilityZone != nil {
		v := *s.AvailabilityZone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AvailabilityZone", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.FrameworkAttributes != nil {
		v := s.FrameworkAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "FrameworkAttributes", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceType != nil {
		v := *s.InstanceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InstanceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MemberId != nil {
		v := *s.MemberId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemberId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NetworkId != nil {
		v := *s.NetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Configuration properties of a peer node.
type NodeConfiguration struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which the node exists.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `type:"string" required:"true"`

	// The Amazon Managed Blockchain instance type for the node.
	//
	// InstanceType is a required field
	InstanceType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s NodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodeConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NodeConfiguration"}

	if s.AvailabilityZone == nil {
		invalidParams.Add(aws.NewErrParamRequired("AvailabilityZone"))
	}

	if s.InstanceType == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NodeConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.AvailabilityZone != nil {
		v := *s.AvailabilityZone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AvailabilityZone", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceType != nil {
		v := *s.InstanceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InstanceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Attributes of Hyperledger Fabric for a peer node on a Managed Blockchain
// network that uses Hyperledger Fabric.
type NodeFabricAttributes struct {
	_ struct{} `type:"structure"`

	// The endpoint that identifies the peer node for all services except peer channel-based
	// event services.
	PeerEndpoint *string `type:"string"`

	// The endpoint that identifies the peer node for peer channel-based event services.
	PeerEventEndpoint *string `type:"string"`
}

// String returns the string representation
func (s NodeFabricAttributes) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NodeFabricAttributes) MarshalFields(e protocol.FieldEncoder) error {
	if s.PeerEndpoint != nil {
		v := *s.PeerEndpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PeerEndpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PeerEventEndpoint != nil {
		v := *s.PeerEventEndpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PeerEventEndpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Attributes relevant to a peer node on a Managed Blockchain network for the
// blockchain framework that the network uses.
type NodeFrameworkAttributes struct {
	_ struct{} `type:"structure"`

	// Attributes of Hyperledger Fabric for a peer node on a Managed Blockchain
	// network that uses Hyperledger Fabric.
	Fabric *NodeFabricAttributes `type:"structure"`
}

// String returns the string representation
func (s NodeFrameworkAttributes) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NodeFrameworkAttributes) MarshalFields(e protocol.FieldEncoder) error {
	if s.Fabric != nil {
		v := s.Fabric

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Fabric", v, metadata)
	}
	return nil
}

// A summary of configuration properties for a peer node.
type NodeSummary struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which the node exists.
	AvailabilityZone *string `type:"string"`

	// The date and time that the node was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unique identifier of the node.
	Id *string `min:"1" type:"string"`

	// The EC2 instance type for the node.
	InstanceType *string `type:"string"`

	// The status of the node.
	Status NodeStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s NodeSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NodeSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.AvailabilityZone != nil {
		v := *s.AvailabilityZone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AvailabilityZone", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceType != nil {
		v := *s.InstanceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InstanceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Properties of a proposal on a Managed Blockchain network.
type Proposal struct {
	_ struct{} `type:"structure"`

	// The actions to perform on the network if the proposal is APPROVED.
	Actions *ProposalActions `type:"structure"`

	// The date and time that the proposal was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The description of the proposal.
	Description *string `type:"string"`

	// The date and time that the proposal expires. This is the CreationDate plus
	// the ProposalDurationInHours that is specified in the ProposalThresholdPolicy.
	// After this date and time, if members have not cast enough votes to determine
	// the outcome according to the voting policy, the proposal is EXPIRED and Actions
	// are not carried out.
	ExpirationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unique identifier of the network for which the proposal is made.
	NetworkId *string `min:"1" type:"string"`

	// The current total of NO votes cast on the proposal by members.
	NoVoteCount *int64 `type:"integer"`

	// The number of votes remaining to be cast on the proposal by members. In other
	// words, the number of members minus the sum of YES votes and NO votes.
	OutstandingVoteCount *int64 `type:"integer"`

	// The unique identifier of the proposal.
	ProposalId *string `min:"1" type:"string"`

	// The unique identifier of the member that created the proposal.
	ProposedByMemberId *string `min:"1" type:"string"`

	// The name of the member that created the proposal.
	ProposedByMemberName *string `min:"1" type:"string"`

	// The status of the proposal. Values are as follows:
	//
	//    * IN_PROGRESS - The proposal is active and open for member voting.
	//
	//    * APPROVED - The proposal was approved with sufficient YES votes among
	//    members according to the VotingPolicy specified for the Network. The specified
	//    proposal actions are carried out.
	//
	//    * REJECTED - The proposal was rejected with insufficient YES votes among
	//    members according to the VotingPolicy specified for the Network. The specified
	//    ProposalActions are not carried out.
	//
	//    * EXPIRED - Members did not cast the number of votes required to determine
	//    the proposal outcome before the proposal expired. The specified ProposalActions
	//    are not carried out.
	//
	//    * ACTION_FAILED - One or more of the specified ProposalActions in a proposal
	//    that was approved could not be completed because of an error.
	Status ProposalStatus `type:"string" enum:"true"`

	// The current total of YES votes cast on the proposal by members.
	YesVoteCount *int64 `type:"integer"`
}

// String returns the string representation
func (s Proposal) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Proposal) MarshalFields(e protocol.FieldEncoder) error {
	if s.Actions != nil {
		v := s.Actions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Actions", v, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExpirationDate != nil {
		v := *s.ExpirationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExpirationDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.NetworkId != nil {
		v := *s.NetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NoVoteCount != nil {
		v := *s.NoVoteCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NoVoteCount", protocol.Int64Value(v), metadata)
	}
	if s.OutstandingVoteCount != nil {
		v := *s.OutstandingVoteCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OutstandingVoteCount", protocol.Int64Value(v), metadata)
	}
	if s.ProposalId != nil {
		v := *s.ProposalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProposalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProposedByMemberId != nil {
		v := *s.ProposedByMemberId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProposedByMemberId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProposedByMemberName != nil {
		v := *s.ProposedByMemberName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProposedByMemberName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.YesVoteCount != nil {
		v := *s.YesVoteCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "YesVoteCount", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The actions to carry out if a proposal is APPROVED.
type ProposalActions struct {
	_ struct{} `type:"structure"`

	// The actions to perform for an APPROVED proposal to invite an AWS account
	// to create a member and join the network.
	Invitations []InviteAction `type:"list"`

	// The actions to perform for an APPROVED proposal to remove a member from the
	// network, which deletes the member and all associated member resources from
	// the network.
	Removals []RemoveAction `type:"list"`
}

// String returns the string representation
func (s ProposalActions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProposalActions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProposalActions"}
	if s.Invitations != nil {
		for i, v := range s.Invitations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Invitations", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Removals != nil {
		for i, v := range s.Removals {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Removals", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProposalActions) MarshalFields(e protocol.FieldEncoder) error {
	if s.Invitations != nil {
		v := s.Invitations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Invitations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Removals != nil {
		v := s.Removals

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Removals", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Properties of a proposal.
type ProposalSummary struct {
	_ struct{} `type:"structure"`

	// The date and time that the proposal was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The description of the proposal.
	Description *string `type:"string"`

	// The date and time that the proposal expires. This is the CreationDate plus
	// the ProposalDurationInHours that is specified in the ProposalThresholdPolicy.
	// After this date and time, if members have not cast enough votes to determine
	// the outcome according to the voting policy, the proposal is EXPIRED and Actions
	// are not carried out.
	ExpirationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unique identifier of the proposal.
	ProposalId *string `min:"1" type:"string"`

	// The unique identifier of the member that created the proposal.
	ProposedByMemberId *string `min:"1" type:"string"`

	// The name of the member that created the proposal.
	ProposedByMemberName *string `min:"1" type:"string"`

	// The status of the proposal. Values are as follows:
	//
	//    * IN_PROGRESS - The proposal is active and open for member voting.
	//
	//    * APPROVED - The proposal was approved with sufficient YES votes among
	//    members according to the VotingPolicy specified for the Network. The specified
	//    proposal actions are carried out.
	//
	//    * REJECTED - The proposal was rejected with insufficient YES votes among
	//    members according to the VotingPolicy specified for the Network. The specified
	//    ProposalActions are not carried out.
	//
	//    * EXPIRED - Members did not cast the number of votes required to determine
	//    the proposal outcome before the proposal expired. The specified ProposalActions
	//    are not carried out.
	//
	//    * ACTION_FAILED - One or more of the specified ProposalActions in a proposal
	//    that was approved could not be completed because of an error.
	Status ProposalStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s ProposalSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProposalSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExpirationDate != nil {
		v := *s.ExpirationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExpirationDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.ProposalId != nil {
		v := *s.ProposalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProposalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProposedByMemberId != nil {
		v := *s.ProposedByMemberId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProposedByMemberId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProposedByMemberName != nil {
		v := *s.ProposedByMemberName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProposedByMemberName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An action to remove a member from a Managed Blockchain network as the result
// of a removal proposal that is APPROVED. The member and all associated resources
// are deleted from the network.
type RemoveAction struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the member to remove.
	//
	// MemberId is a required field
	MemberId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RemoveAction"}

	if s.MemberId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil && len(*s.MemberId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MemberId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemoveAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.MemberId != nil {
		v := *s.MemberId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemberId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Properties of an individual vote that a member cast for a proposal.
type VoteSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the member that cast the vote.
	MemberId *string `min:"1" type:"string"`

	// The name of the member that cast the vote.
	MemberName *string `min:"1" type:"string"`

	// The vote value, either YES or NO.
	Vote VoteValue `type:"string" enum:"true"`
}

// String returns the string representation
func (s VoteSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VoteSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.MemberId != nil {
		v := *s.MemberId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemberId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MemberName != nil {
		v := *s.MemberName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemberName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Vote) > 0 {
		v := s.Vote

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Vote", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The voting rules for the network to decide if a proposal is accepted
type VotingPolicy struct {
	_ struct{} `type:"structure"`

	// Defines the rules for the network for voting on proposals, such as the percentage
	// of YES votes required for the proposal to be approved and the duration of
	// the proposal. The policy applies to all proposals and is specified when the
	// network is created.
	ApprovalThresholdPolicy *ApprovalThresholdPolicy `type:"structure"`
}

// String returns the string representation
func (s VotingPolicy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VotingPolicy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VotingPolicy"}
	if s.ApprovalThresholdPolicy != nil {
		if err := s.ApprovalThresholdPolicy.Validate(); err != nil {
			invalidParams.AddNested("ApprovalThresholdPolicy", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VotingPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApprovalThresholdPolicy != nil {
		v := s.ApprovalThresholdPolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ApprovalThresholdPolicy", v, metadata)
	}
	return nil
}
