// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUserStackAssociationsRequest
type DescribeUserStackAssociationsInput struct {
	_ struct{} `type:"structure"`

	// The authentication type for the user who is associated with the stack. You
	// must specify USERPOOL.
	AuthenticationType AuthenticationType `type:"string" enum:"true"`

	// The maximum size of each page of results.
	MaxResults *int64 `type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`

	// The name of the stack that is associated with the user.
	StackName *string `min:"1" type:"string"`

	// The email address of the user who is associated with the stack.
	//
	// Users' email addresses are case-sensitive.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeUserStackAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserStackAssociationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeUserStackAssociationsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackName", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUserStackAssociationsResult
type DescribeUserStackAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`

	// The UserStackAssociation objects.
	UserStackAssociations []UserStackAssociation `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeUserStackAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeUserStackAssociations = "DescribeUserStackAssociations"

// DescribeUserStackAssociationsRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Retrieves a list that describes the UserStackAssociation objects. You must
// specify either or both of the following:
//
//    * The stack name
//
//    * The user name (email address of the user associated with the stack)
//    and the authentication type for the user
//
//    // Example sending a request using DescribeUserStackAssociationsRequest.
//    req := client.DescribeUserStackAssociationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUserStackAssociations
func (c *Client) DescribeUserStackAssociationsRequest(input *DescribeUserStackAssociationsInput) DescribeUserStackAssociationsRequest {
	op := &aws.Operation{
		Name:       opDescribeUserStackAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserStackAssociationsInput{}
	}

	req := c.newRequest(op, input, &DescribeUserStackAssociationsOutput{})
	return DescribeUserStackAssociationsRequest{Request: req, Input: input, Copy: c.DescribeUserStackAssociationsRequest}
}

// DescribeUserStackAssociationsRequest is the request type for the
// DescribeUserStackAssociations API operation.
type DescribeUserStackAssociationsRequest struct {
	*aws.Request
	Input *DescribeUserStackAssociationsInput
	Copy  func(*DescribeUserStackAssociationsInput) DescribeUserStackAssociationsRequest
}

// Send marshals and sends the DescribeUserStackAssociations API request.
func (r DescribeUserStackAssociationsRequest) Send(ctx context.Context) (*DescribeUserStackAssociationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeUserStackAssociationsResponse{
		DescribeUserStackAssociationsOutput: r.Request.Data.(*DescribeUserStackAssociationsOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeUserStackAssociationsResponse is the response type for the
// DescribeUserStackAssociations API operation.
type DescribeUserStackAssociationsResponse struct {
	*DescribeUserStackAssociationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeUserStackAssociations request.
func (r *DescribeUserStackAssociationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
