// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchlogs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogGroupFieldsRequest
type GetLogGroupFieldsInput struct {
	_ struct{} `type:"structure"`

	// The name of the log group to search.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`

	// The time to set as the center of the query. If you specify time, the 8 minutes
	// before and 8 minutes after this time are searched. If you omit time, the
	// past 15 minutes are queried.
	//
	// The time value is specified as epoch time, the number of seconds since January
	// 1, 1970, 00:00:00 UTC.
	Time *int64 `locationName:"time" type:"long"`
}

// String returns the string representation
func (s GetLogGroupFieldsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLogGroupFieldsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetLogGroupFieldsInput"}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogGroupFieldsResponse
type GetLogGroupFieldsOutput struct {
	_ struct{} `type:"structure"`

	// The array of fields found in the query. Each object in the array contains
	// the name of the field, along with the percentage of time it appeared in the
	// log events that were queried.
	LogGroupFields []LogGroupField `locationName:"logGroupFields" type:"list"`
}

// String returns the string representation
func (s GetLogGroupFieldsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetLogGroupFields = "GetLogGroupFields"

// GetLogGroupFieldsRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Returns a list of the fields that are included in log events in the specified
// log group, along with the percentage of log events that contain each field.
// The search is limited to a time period that you specify.
//
// In the results, fields that start with @ are fields generated by CloudWatch
// Logs. For example, @timestamp is the timestamp of each log event.
//
// The response results are sorted by the frequency percentage, starting with
// the highest percentage.
//
//    // Example sending a request using GetLogGroupFieldsRequest.
//    req := client.GetLogGroupFieldsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogGroupFields
func (c *Client) GetLogGroupFieldsRequest(input *GetLogGroupFieldsInput) GetLogGroupFieldsRequest {
	op := &aws.Operation{
		Name:       opGetLogGroupFields,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLogGroupFieldsInput{}
	}

	req := c.newRequest(op, input, &GetLogGroupFieldsOutput{})
	return GetLogGroupFieldsRequest{Request: req, Input: input, Copy: c.GetLogGroupFieldsRequest}
}

// GetLogGroupFieldsRequest is the request type for the
// GetLogGroupFields API operation.
type GetLogGroupFieldsRequest struct {
	*aws.Request
	Input *GetLogGroupFieldsInput
	Copy  func(*GetLogGroupFieldsInput) GetLogGroupFieldsRequest
}

// Send marshals and sends the GetLogGroupFields API request.
func (r GetLogGroupFieldsRequest) Send(ctx context.Context) (*GetLogGroupFieldsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetLogGroupFieldsResponse{
		GetLogGroupFieldsOutput: r.Request.Data.(*GetLogGroupFieldsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetLogGroupFieldsResponse is the response type for the
// GetLogGroupFields API operation.
type GetLogGroupFieldsResponse struct {
	*GetLogGroupFieldsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetLogGroupFields request.
func (r *GetLogGroupFieldsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
