// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Represents the input of an update repository description operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryNameInput
type UpdateRepositoryNameInput struct {
	_ struct{} `type:"structure"`

	// The new name for the repository.
	//
	// NewName is a required field
	NewName *string `locationName:"newName" min:"1" type:"string" required:"true"`

	// The existing name of the repository.
	//
	// OldName is a required field
	OldName *string `locationName:"oldName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRepositoryNameInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRepositoryNameInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateRepositoryNameInput"}

	if s.NewName == nil {
		invalidParams.Add(aws.NewErrParamRequired("NewName"))
	}
	if s.NewName != nil && len(*s.NewName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NewName", 1))
	}

	if s.OldName == nil {
		invalidParams.Add(aws.NewErrParamRequired("OldName"))
	}
	if s.OldName != nil && len(*s.OldName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OldName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryNameOutput
type UpdateRepositoryNameOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRepositoryNameOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateRepositoryName = "UpdateRepositoryName"

// UpdateRepositoryNameRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Renames a repository. The repository name must be unique across the calling
// AWS account. In addition, repository names are limited to 100 alphanumeric,
// dash, and underscore characters, and cannot include certain characters. The
// suffix ".git" is prohibited. For a full description of the limits on repository
// names, see Limits (http://docs.aws.amazon.com/codecommit/latest/userguide/limits.html)
// in the AWS CodeCommit User Guide.
//
//    // Example sending a request using UpdateRepositoryNameRequest.
//    req := client.UpdateRepositoryNameRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryName
func (c *Client) UpdateRepositoryNameRequest(input *UpdateRepositoryNameInput) UpdateRepositoryNameRequest {
	op := &aws.Operation{
		Name:       opUpdateRepositoryName,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRepositoryNameInput{}
	}

	req := c.newRequest(op, input, &UpdateRepositoryNameOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UpdateRepositoryNameRequest{Request: req, Input: input, Copy: c.UpdateRepositoryNameRequest}
}

// UpdateRepositoryNameRequest is the request type for the
// UpdateRepositoryName API operation.
type UpdateRepositoryNameRequest struct {
	*aws.Request
	Input *UpdateRepositoryNameInput
	Copy  func(*UpdateRepositoryNameInput) UpdateRepositoryNameRequest
}

// Send marshals and sends the UpdateRepositoryName API request.
func (r UpdateRepositoryNameRequest) Send(ctx context.Context) (*UpdateRepositoryNameResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateRepositoryNameResponse{
		UpdateRepositoryNameOutput: r.Request.Data.(*UpdateRepositoryNameOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateRepositoryNameResponse is the response type for the
// UpdateRepositoryName API operation.
type UpdateRepositoryNameResponse struct {
	*UpdateRepositoryNameOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateRepositoryName request.
func (r *UpdateRepositoryNameResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
