// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codedeploy

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a BatchGetApplicationRevisions operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplicationRevisionsInput
type BatchGetApplicationRevisionsInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application about which to get revision information.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// An array of RevisionLocation objects that specify information to get about
	// the application revisions, including type and location. The maximum number
	// of RevisionLocation objects you can specify is 25.
	//
	// Revisions is a required field
	Revisions []RevisionLocation `locationName:"revisions" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetApplicationRevisionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetApplicationRevisionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchGetApplicationRevisionsInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if s.Revisions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Revisions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a BatchGetApplicationRevisions operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplicationRevisionsOutput
type BatchGetApplicationRevisionsOutput struct {
	_ struct{} `type:"structure"`

	// The name of the application that corresponds to the revisions.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// Information about errors that might have occurred during the API call.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// Additional information about the revisions, including the type and location.
	Revisions []RevisionInfo `locationName:"revisions" type:"list"`
}

// String returns the string representation
func (s BatchGetApplicationRevisionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchGetApplicationRevisions = "BatchGetApplicationRevisions"

// BatchGetApplicationRevisionsRequest returns a request value for making API operation for
// AWS CodeDeploy.
//
// Gets information about one or more application revisions. The maximum number
// of application revisions that can be returned is 25.
//
//    // Example sending a request using BatchGetApplicationRevisionsRequest.
//    req := client.BatchGetApplicationRevisionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplicationRevisions
func (c *Client) BatchGetApplicationRevisionsRequest(input *BatchGetApplicationRevisionsInput) BatchGetApplicationRevisionsRequest {
	op := &aws.Operation{
		Name:       opBatchGetApplicationRevisions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetApplicationRevisionsInput{}
	}

	req := c.newRequest(op, input, &BatchGetApplicationRevisionsOutput{})
	return BatchGetApplicationRevisionsRequest{Request: req, Input: input, Copy: c.BatchGetApplicationRevisionsRequest}
}

// BatchGetApplicationRevisionsRequest is the request type for the
// BatchGetApplicationRevisions API operation.
type BatchGetApplicationRevisionsRequest struct {
	*aws.Request
	Input *BatchGetApplicationRevisionsInput
	Copy  func(*BatchGetApplicationRevisionsInput) BatchGetApplicationRevisionsRequest
}

// Send marshals and sends the BatchGetApplicationRevisions API request.
func (r BatchGetApplicationRevisionsRequest) Send(ctx context.Context) (*BatchGetApplicationRevisionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchGetApplicationRevisionsResponse{
		BatchGetApplicationRevisionsOutput: r.Request.Data.(*BatchGetApplicationRevisionsOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchGetApplicationRevisionsResponse is the response type for the
// BatchGetApplicationRevisions API operation.
type BatchGetApplicationRevisionsResponse struct {
	*BatchGetApplicationRevisionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchGetApplicationRevisions request.
func (r *BatchGetApplicationRevisionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
