// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolDomainRequest
type DescribeUserPoolDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain string.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserPoolDomainInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserPoolDomainInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeUserPoolDomainInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolDomainResponse
type DescribeUserPoolDomainOutput struct {
	_ struct{} `type:"structure"`

	// A domain description object containing information about the domain.
	DomainDescription *DomainDescriptionType `type:"structure"`
}

// String returns the string representation
func (s DescribeUserPoolDomainOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeUserPoolDomain = "DescribeUserPoolDomain"

// DescribeUserPoolDomainRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Gets information about a domain.
//
//    // Example sending a request using DescribeUserPoolDomainRequest.
//    req := client.DescribeUserPoolDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeUserPoolDomain
func (c *Client) DescribeUserPoolDomainRequest(input *DescribeUserPoolDomainInput) DescribeUserPoolDomainRequest {
	op := &aws.Operation{
		Name:       opDescribeUserPoolDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserPoolDomainInput{}
	}

	req := c.newRequest(op, input, &DescribeUserPoolDomainOutput{})
	return DescribeUserPoolDomainRequest{Request: req, Input: input, Copy: c.DescribeUserPoolDomainRequest}
}

// DescribeUserPoolDomainRequest is the request type for the
// DescribeUserPoolDomain API operation.
type DescribeUserPoolDomainRequest struct {
	*aws.Request
	Input *DescribeUserPoolDomainInput
	Copy  func(*DescribeUserPoolDomainInput) DescribeUserPoolDomainRequest
}

// Send marshals and sends the DescribeUserPoolDomain API request.
func (r DescribeUserPoolDomainRequest) Send(ctx context.Context) (*DescribeUserPoolDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeUserPoolDomainResponse{
		DescribeUserPoolDomainOutput: r.Request.Data.(*DescribeUserPoolDomainOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeUserPoolDomainResponse is the response type for the
// DescribeUserPoolDomain API operation.
type DescribeUserPoolDomainResponse struct {
	*DescribeUserPoolDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeUserPoolDomain request.
func (r *DescribeUserPoolDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
