// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to list the offering transaction history.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactionsRequest
type ListOfferingTransactionsInput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListOfferingTransactionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOfferingTransactionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListOfferingTransactionsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Returns the transaction log of the specified offerings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactionsResult
type ListOfferingTransactionsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The audit log of subscriptions you have purchased and modified through AWS
	// Device Farm.
	OfferingTransactions []OfferingTransaction `locationName:"offeringTransactions" type:"list"`
}

// String returns the string representation
func (s ListOfferingTransactionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListOfferingTransactions = "ListOfferingTransactions"

// ListOfferingTransactionsRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Returns a list of all historical purchases, renewals, and system renewal
// transactions for an AWS account. The list is paginated and ordered by a descending
// timestamp (most recent transactions are first). The API returns a NotEligible
// error if the user is not permitted to invoke the operation. Please contact
// aws-devicefarm-support@amazon.com (mailto:aws-devicefarm-support@amazon.com)
// if you believe that you should be able to invoke this operation.
//
//    // Example sending a request using ListOfferingTransactionsRequest.
//    req := client.ListOfferingTransactionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions
func (c *Client) ListOfferingTransactionsRequest(input *ListOfferingTransactionsInput) ListOfferingTransactionsRequest {
	op := &aws.Operation{
		Name:       opListOfferingTransactions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOfferingTransactionsInput{}
	}

	req := c.newRequest(op, input, &ListOfferingTransactionsOutput{})
	return ListOfferingTransactionsRequest{Request: req, Input: input, Copy: c.ListOfferingTransactionsRequest}
}

// ListOfferingTransactionsRequest is the request type for the
// ListOfferingTransactions API operation.
type ListOfferingTransactionsRequest struct {
	*aws.Request
	Input *ListOfferingTransactionsInput
	Copy  func(*ListOfferingTransactionsInput) ListOfferingTransactionsRequest
}

// Send marshals and sends the ListOfferingTransactions API request.
func (r ListOfferingTransactionsRequest) Send(ctx context.Context) (*ListOfferingTransactionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListOfferingTransactionsResponse{
		ListOfferingTransactionsOutput: r.Request.Data.(*ListOfferingTransactionsOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListOfferingTransactionsRequestPaginator returns a paginator for ListOfferingTransactions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListOfferingTransactionsRequest(input)
//   p := devicefarm.NewListOfferingTransactionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListOfferingTransactionsPaginator(req ListOfferingTransactionsRequest) ListOfferingTransactionsPaginator {
	return ListOfferingTransactionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListOfferingTransactionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListOfferingTransactionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListOfferingTransactionsPaginator struct {
	aws.Pager
}

func (p *ListOfferingTransactionsPaginator) CurrentPage() *ListOfferingTransactionsOutput {
	return p.Pager.CurrentPage().(*ListOfferingTransactionsOutput)
}

// ListOfferingTransactionsResponse is the response type for the
// ListOfferingTransactions API operation.
type ListOfferingTransactionsResponse struct {
	*ListOfferingTransactionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListOfferingTransactions request.
func (r *ListOfferingTransactionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
