// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to the list samples operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamplesRequest
type ListSamplesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the job used to list samples.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListSamplesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSamplesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListSamplesInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the result of a list samples request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamplesResult
type ListSamplesOutput struct {
	_ struct{} `type:"structure"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the samples.
	Samples []Sample `locationName:"samples" type:"list"`
}

// String returns the string representation
func (s ListSamplesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListSamples = "ListSamples"

// ListSamplesRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Gets information about samples, given an AWS Device Farm job ARN.
//
//    // Example sending a request using ListSamplesRequest.
//    req := client.ListSamplesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamples
func (c *Client) ListSamplesRequest(input *ListSamplesInput) ListSamplesRequest {
	op := &aws.Operation{
		Name:       opListSamples,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSamplesInput{}
	}

	req := c.newRequest(op, input, &ListSamplesOutput{})
	return ListSamplesRequest{Request: req, Input: input, Copy: c.ListSamplesRequest}
}

// ListSamplesRequest is the request type for the
// ListSamples API operation.
type ListSamplesRequest struct {
	*aws.Request
	Input *ListSamplesInput
	Copy  func(*ListSamplesInput) ListSamplesRequest
}

// Send marshals and sends the ListSamples API request.
func (r ListSamplesRequest) Send(ctx context.Context) (*ListSamplesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSamplesResponse{
		ListSamplesOutput: r.Request.Data.(*ListSamplesOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListSamplesRequestPaginator returns a paginator for ListSamples.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListSamplesRequest(input)
//   p := devicefarm.NewListSamplesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListSamplesPaginator(req ListSamplesRequest) ListSamplesPaginator {
	return ListSamplesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListSamplesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListSamplesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListSamplesPaginator struct {
	aws.Pager
}

func (p *ListSamplesPaginator) CurrentPage() *ListSamplesOutput {
	return p.Pager.CurrentPage().(*ListSamplesOutput)
}

// ListSamplesResponse is the response type for the
// ListSamples API operation.
type ListSamplesResponse struct {
	*ListSamplesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSamples request.
func (r *ListSamplesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
