// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteInterconnectRequest
type DeleteInterconnectInput struct {
	_ struct{} `type:"structure"`

	// The ID of the interconnect.
	//
	// InterconnectId is a required field
	InterconnectId *string `locationName:"interconnectId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInterconnectInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInterconnectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteInterconnectInput"}

	if s.InterconnectId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InterconnectId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteInterconnectResponse
type DeleteInterconnectOutput struct {
	_ struct{} `type:"structure"`

	// The state of the interconnect. The following are the possible values:
	//
	//    * requested: The initial state of an interconnect. The interconnect stays
	//    in the requested state until the Letter of Authorization (LOA) is sent
	//    to the customer.
	//
	//    * pending: The interconnect is approved, and is being initialized.
	//
	//    * available: The network link is up, and the interconnect is ready for
	//    use.
	//
	//    * down: The network link is down.
	//
	//    * deleting: The interconnect is being deleted.
	//
	//    * deleted: The interconnect is deleted.
	//
	//    * unknown: The state of the interconnect is not available.
	InterconnectState InterconnectState `locationName:"interconnectState" type:"string" enum:"true"`
}

// String returns the string representation
func (s DeleteInterconnectOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteInterconnect = "DeleteInterconnect"

// DeleteInterconnectRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Deletes the specified interconnect.
//
// Intended for use by AWS Direct Connect Partners only.
//
//    // Example sending a request using DeleteInterconnectRequest.
//    req := client.DeleteInterconnectRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteInterconnect
func (c *Client) DeleteInterconnectRequest(input *DeleteInterconnectInput) DeleteInterconnectRequest {
	op := &aws.Operation{
		Name:       opDeleteInterconnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInterconnectInput{}
	}

	req := c.newRequest(op, input, &DeleteInterconnectOutput{})
	return DeleteInterconnectRequest{Request: req, Input: input, Copy: c.DeleteInterconnectRequest}
}

// DeleteInterconnectRequest is the request type for the
// DeleteInterconnect API operation.
type DeleteInterconnectRequest struct {
	*aws.Request
	Input *DeleteInterconnectInput
	Copy  func(*DeleteInterconnectInput) DeleteInterconnectRequest
}

// Send marshals and sends the DeleteInterconnect API request.
func (r DeleteInterconnectRequest) Send(ctx context.Context) (*DeleteInterconnectResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteInterconnectResponse{
		DeleteInterconnectOutput: r.Request.Data.(*DeleteInterconnectOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteInterconnectResponse is the response type for the
// DeleteInterconnect API operation.
type DeleteInterconnectResponse struct {
	*DeleteInterconnectOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteInterconnect request.
func (r *DeleteInterconnectResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
