// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UnshareDirectoryRequest
type UnshareDirectoryInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the AWS Managed Microsoft AD directory that you want to
	// stop sharing.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// Identifier for the directory consumer account with whom the directory has
	// to be unshared.
	//
	// UnshareTarget is a required field
	UnshareTarget *UnshareTarget `type:"structure" required:"true"`
}

// String returns the string representation
func (s UnshareDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnshareDirectoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UnshareDirectoryInput"}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}

	if s.UnshareTarget == nil {
		invalidParams.Add(aws.NewErrParamRequired("UnshareTarget"))
	}
	if s.UnshareTarget != nil {
		if err := s.UnshareTarget.Validate(); err != nil {
			invalidParams.AddNested("UnshareTarget", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UnshareDirectoryResult
type UnshareDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// Identifier of the directory stored in the directory consumer account that
	// is to be unshared from the specified directory (DirectoryId).
	SharedDirectoryId *string `type:"string"`
}

// String returns the string representation
func (s UnshareDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opUnshareDirectory = "UnshareDirectory"

// UnshareDirectoryRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Stops the directory sharing between the directory owner and consumer accounts.
//
//    // Example sending a request using UnshareDirectoryRequest.
//    req := client.UnshareDirectoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UnshareDirectory
func (c *Client) UnshareDirectoryRequest(input *UnshareDirectoryInput) UnshareDirectoryRequest {
	op := &aws.Operation{
		Name:       opUnshareDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnshareDirectoryInput{}
	}

	req := c.newRequest(op, input, &UnshareDirectoryOutput{})
	return UnshareDirectoryRequest{Request: req, Input: input, Copy: c.UnshareDirectoryRequest}
}

// UnshareDirectoryRequest is the request type for the
// UnshareDirectory API operation.
type UnshareDirectoryRequest struct {
	*aws.Request
	Input *UnshareDirectoryInput
	Copy  func(*UnshareDirectoryInput) UnshareDirectoryRequest
}

// Send marshals and sends the UnshareDirectory API request.
func (r UnshareDirectoryRequest) Send(ctx context.Context) (*UnshareDirectoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UnshareDirectoryResponse{
		UnshareDirectoryOutput: r.Request.Data.(*UnshareDirectoryOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UnshareDirectoryResponse is the response type for the
// UnshareDirectory API operation.
type UnshareDirectoryResponse struct {
	*UnshareDirectoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UnshareDirectory request.
func (r *UnshareDirectoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
