// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticache

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a DeleteReplicationGroup operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteReplicationGroupMessage
type DeleteReplicationGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of a final node group (shard) snapshot. ElastiCache creates the
	// snapshot from the primary node in the cluster, rather than one of the replicas;
	// this is to ensure that it captures the freshest data. After the final snapshot
	// is taken, the replication group is immediately deleted.
	FinalSnapshotIdentifier *string `type:"string"`

	// The identifier for the cluster to be deleted. This parameter is not case
	// sensitive.
	//
	// ReplicationGroupId is a required field
	ReplicationGroupId *string `type:"string" required:"true"`

	// If set to true, all of the read replicas are deleted, but the primary node
	// is retained.
	RetainPrimaryCluster *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteReplicationGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteReplicationGroupInput"}

	if s.ReplicationGroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReplicationGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteReplicationGroupResult
type DeleteReplicationGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains all of the attributes of a specific Redis replication group.
	ReplicationGroup *ReplicationGroup `type:"structure"`
}

// String returns the string representation
func (s DeleteReplicationGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteReplicationGroup = "DeleteReplicationGroup"

// DeleteReplicationGroupRequest returns a request value for making API operation for
// Amazon ElastiCache.
//
// Deletes an existing replication group. By default, this operation deletes
// the entire replication group, including the primary/primaries and all of
// the read replicas. If the replication group has only one primary, you can
// optionally delete only the read replicas, while retaining the primary by
// setting RetainPrimaryCluster=true.
//
// When you receive a successful response from this operation, Amazon ElastiCache
// immediately begins deleting the selected resources; you cannot cancel or
// revert this operation.
//
// This operation is valid for Redis only.
//
//    // Example sending a request using DeleteReplicationGroupRequest.
//    req := client.DeleteReplicationGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteReplicationGroup
func (c *Client) DeleteReplicationGroupRequest(input *DeleteReplicationGroupInput) DeleteReplicationGroupRequest {
	op := &aws.Operation{
		Name:       opDeleteReplicationGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationGroupInput{}
	}

	req := c.newRequest(op, input, &DeleteReplicationGroupOutput{})
	return DeleteReplicationGroupRequest{Request: req, Input: input, Copy: c.DeleteReplicationGroupRequest}
}

// DeleteReplicationGroupRequest is the request type for the
// DeleteReplicationGroup API operation.
type DeleteReplicationGroupRequest struct {
	*aws.Request
	Input *DeleteReplicationGroupInput
	Copy  func(*DeleteReplicationGroupInput) DeleteReplicationGroupRequest
}

// Send marshals and sends the DeleteReplicationGroup API request.
func (r DeleteReplicationGroupRequest) Send(ctx context.Context) (*DeleteReplicationGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteReplicationGroupResponse{
		DeleteReplicationGroupOutput: r.Request.Data.(*DeleteReplicationGroupOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteReplicationGroupResponse is the response type for the
// DeleteReplicationGroup API operation.
type DeleteReplicationGroupResponse struct {
	*DeleteReplicationGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteReplicationGroup request.
func (r *DeleteReplicationGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
