// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticache

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a DescribeReservedCacheNodes operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodesMessage
type DescribeReservedCacheNodesInput struct {
	_ struct{} `type:"structure"`

	// The cache node type filter value. Use this parameter to show only those reservations
	// matching the specified cache node type.
	//
	// The following node types are supported by ElastiCache. Generally speaking,
	// the current generation types provide more memory and computational power
	// at lower cost when compared to their equivalent previous generation counterparts.
	//
	//    * General purpose: Current generation: T2 node types: cache.t2.micro,
	//    cache.t2.small, cache.t2.medium M3 node types: cache.m3.medium, cache.m3.large,
	//    cache.m3.xlarge, cache.m3.2xlarge M4 node types: cache.m4.large, cache.m4.xlarge,
	//    cache.m4.2xlarge, cache.m4.4xlarge, cache.m4.10xlarge Previous generation:
	//    (not recommended) T1 node types: cache.t1.micro M1 node types: cache.m1.small,
	//    cache.m1.medium, cache.m1.large, cache.m1.xlarge
	//
	//    * Compute optimized: Previous generation: (not recommended) C1 node types:
	//    cache.c1.xlarge
	//
	//    * Memory optimized: Current generation: R3 node types: cache.r3.large,
	//    cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge, cache.r3.8xlarge
	//    R4 node types; cache.r4.large, cache.r4.xlarge, cache.r4.2xlarge, cache.r4.4xlarge,
	//    cache.r4.8xlarge, cache.r4.16xlarge Previous generation: (not recommended)
	//    M2 node types: cache.m2.xlarge, cache.m2.2xlarge, cache.m2.4xlarge
	//
	// Notes:
	//
	//    * All T2 instances are created in an Amazon Virtual Private Cloud (Amazon
	//    VPC).
	//
	//    * Redis (cluster mode disabled): Redis backup/restore is not supported
	//    on T1 and T2 instances.
	//
	//    * Redis (cluster mode enabled): Backup/restore is not supported on T1
	//    instances.
	//
	//    * Redis Append-only files (AOF) functionality is not supported for T1
	//    or T2 instances.
	//
	// For a complete listing of node types and specifications, see:
	//
	//    * Amazon ElastiCache Product Features and Details (http://aws.amazon.com/elasticache/details)
	//
	//    * Cache Node Type-Specific Parameters for Memcached (http://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/ParameterGroups.Memcached.html#ParameterGroups.Memcached.NodeSpecific)
	//
	//    * Cache Node Type-Specific Parameters for Redis (http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ParameterGroups.Redis.html#ParameterGroups.Redis.NodeSpecific)
	CacheNodeType *string `type:"string"`

	// The duration filter value, specified in years or seconds. Use this parameter
	// to show only reservations for this duration.
	//
	// Valid Values: 1 | 3 | 31536000 | 94608000
	Duration *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this operation. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The offering type filter value. Use this parameter to show only the available
	// offerings matching the specified offering type.
	//
	// Valid values: "Light Utilization"|"Medium Utilization"|"Heavy Utilization"
	OfferingType *string `type:"string"`

	// The product description filter value. Use this parameter to show only those
	// reservations matching the specified product description.
	ProductDescription *string `type:"string"`

	// The reserved cache node identifier filter value. Use this parameter to show
	// only the reservation that matches the specified reservation ID.
	ReservedCacheNodeId *string `type:"string"`

	// The offering identifier filter value. Use this parameter to show only purchased
	// reservations matching the specified offering identifier.
	ReservedCacheNodesOfferingId *string `type:"string"`
}

// String returns the string representation
func (s DescribeReservedCacheNodesInput) String() string {
	return awsutil.Prettify(s)
}

// Represents the output of a DescribeReservedCacheNodes operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/ReservedCacheNodeMessage
type DescribeReservedCacheNodesOutput struct {
	_ struct{} `type:"structure"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`

	// A list of reserved cache nodes. Each element in the list contains detailed
	// information about one node.
	ReservedCacheNodes []ReservedCacheNode `locationNameList:"ReservedCacheNode" type:"list"`
}

// String returns the string representation
func (s DescribeReservedCacheNodesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeReservedCacheNodes = "DescribeReservedCacheNodes"

// DescribeReservedCacheNodesRequest returns a request value for making API operation for
// Amazon ElastiCache.
//
// Returns information about reserved cache nodes for this account, or about
// a specified reserved cache node.
//
//    // Example sending a request using DescribeReservedCacheNodesRequest.
//    req := client.DescribeReservedCacheNodesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DescribeReservedCacheNodes
func (c *Client) DescribeReservedCacheNodesRequest(input *DescribeReservedCacheNodesInput) DescribeReservedCacheNodesRequest {
	op := &aws.Operation{
		Name:       opDescribeReservedCacheNodes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedCacheNodesInput{}
	}

	req := c.newRequest(op, input, &DescribeReservedCacheNodesOutput{})
	return DescribeReservedCacheNodesRequest{Request: req, Input: input, Copy: c.DescribeReservedCacheNodesRequest}
}

// DescribeReservedCacheNodesRequest is the request type for the
// DescribeReservedCacheNodes API operation.
type DescribeReservedCacheNodesRequest struct {
	*aws.Request
	Input *DescribeReservedCacheNodesInput
	Copy  func(*DescribeReservedCacheNodesInput) DescribeReservedCacheNodesRequest
}

// Send marshals and sends the DescribeReservedCacheNodes API request.
func (r DescribeReservedCacheNodesRequest) Send(ctx context.Context) (*DescribeReservedCacheNodesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeReservedCacheNodesResponse{
		DescribeReservedCacheNodesOutput: r.Request.Data.(*DescribeReservedCacheNodesOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeReservedCacheNodesRequestPaginator returns a paginator for DescribeReservedCacheNodes.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeReservedCacheNodesRequest(input)
//   p := elasticache.NewDescribeReservedCacheNodesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeReservedCacheNodesPaginator(req DescribeReservedCacheNodesRequest) DescribeReservedCacheNodesPaginator {
	return DescribeReservedCacheNodesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeReservedCacheNodesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeReservedCacheNodesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeReservedCacheNodesPaginator struct {
	aws.Pager
}

func (p *DescribeReservedCacheNodesPaginator) CurrentPage() *DescribeReservedCacheNodesOutput {
	return p.Pager.CurrentPage().(*DescribeReservedCacheNodesOutput)
}

// DescribeReservedCacheNodesResponse is the response type for the
// DescribeReservedCacheNodes API operation.
type DescribeReservedCacheNodesResponse struct {
	*DescribeReservedCacheNodesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeReservedCacheNodes request.
func (r *DescribeReservedCacheNodesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
