// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glacier

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Provides options to abort a multipart upload identified by the upload ID.
//
// For information about the underlying REST API, see Abort Multipart Upload
// (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-abort-upload.html).
// For conceptual information, see Working with Archives in Amazon Glacier (http://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html).
type AbortMultipartUploadInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The upload ID of the multipart upload to delete.
	//
	// UploadId is a required field
	UploadId *string `location:"uri" locationName:"uploadId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s AbortMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AbortMultipartUploadInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AbortMultipartUploadInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.UploadId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UploadId"))
	}

	if s.VaultName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VaultName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AbortMultipartUploadInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UploadId != nil {
		v := *s.UploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "uploadId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VaultName != nil {
		v := *s.VaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "vaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type AbortMultipartUploadOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AbortMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AbortMultipartUploadOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opAbortMultipartUpload = "AbortMultipartUpload"

// AbortMultipartUploadRequest returns a request value for making API operation for
// Amazon Glacier.
//
// This operation aborts a multipart upload identified by the upload ID.
//
// After the Abort Multipart Upload request succeeds, you cannot upload any
// more parts to the multipart upload or complete the multipart upload. Aborting
// a completed upload fails. However, aborting an already-aborted upload will
// succeed, for a short time. For more information about uploading a part and
// completing a multipart upload, see UploadMultipartPart and CompleteMultipartUpload.
//
// This operation is idempotent.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Working with Archives
// in Amazon Glacier (http://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html)
// and Abort Multipart Upload (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-abort-upload.html)
// in the Amazon Glacier Developer Guide.
//
//    // Example sending a request using AbortMultipartUploadRequest.
//    req := client.AbortMultipartUploadRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) AbortMultipartUploadRequest(input *AbortMultipartUploadInput) AbortMultipartUploadRequest {
	op := &aws.Operation{
		Name:       opAbortMultipartUpload,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
	}

	if input == nil {
		input = &AbortMultipartUploadInput{}
	}

	req := c.newRequest(op, input, &AbortMultipartUploadOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return AbortMultipartUploadRequest{Request: req, Input: input, Copy: c.AbortMultipartUploadRequest}
}

// AbortMultipartUploadRequest is the request type for the
// AbortMultipartUpload API operation.
type AbortMultipartUploadRequest struct {
	*aws.Request
	Input *AbortMultipartUploadInput
	Copy  func(*AbortMultipartUploadInput) AbortMultipartUploadRequest
}

// Send marshals and sends the AbortMultipartUpload API request.
func (r AbortMultipartUploadRequest) Send(ctx context.Context) (*AbortMultipartUploadResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AbortMultipartUploadResponse{
		AbortMultipartUploadOutput: r.Request.Data.(*AbortMultipartUploadOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AbortMultipartUploadResponse is the response type for the
// AbortMultipartUpload API operation.
type AbortMultipartUploadResponse struct {
	*AbortMultipartUploadOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AbortMultipartUpload request.
func (r *AbortMultipartUploadResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
