// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Update findings feedback body
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFindingsFeedbackRequest
type UpdateFindingsFeedbackInput struct {
	_ struct{} `type:"structure"`

	// Additional feedback about the GuardDuty findings.
	Comments *string `locationName:"comments" type:"string"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// Valid values: USEFUL | NOT_USEFUL
	//
	// Feedback is a required field
	Feedback Feedback `locationName:"feedback" type:"string" required:"true" enum:"true"`

	// IDs of the findings that you want to mark as useful or not useful.
	//
	// FindingIds is a required field
	FindingIds []string `locationName:"findingIds" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateFindingsFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFindingsFeedbackInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFindingsFeedbackInput"}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}
	if len(s.Feedback) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Feedback"))
	}

	if s.FindingIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("FindingIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFindingsFeedbackInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.Comments != nil {
		v := *s.Comments

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "comments", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Feedback) > 0 {
		v := s.Feedback

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "feedback", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.FindingIds) > 0 {
		v := s.FindingIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "findingIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFindingsFeedbackResponse
type UpdateFindingsFeedbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateFindingsFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFindingsFeedbackOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateFindingsFeedback = "UpdateFindingsFeedback"

// UpdateFindingsFeedbackRequest returns a request value for making API operation for
// Amazon GuardDuty.
//
// Marks specified Amazon GuardDuty findings as useful or not useful.
//
//    // Example sending a request using UpdateFindingsFeedbackRequest.
//    req := client.UpdateFindingsFeedbackRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFindingsFeedback
func (c *Client) UpdateFindingsFeedbackRequest(input *UpdateFindingsFeedbackInput) UpdateFindingsFeedbackRequest {
	op := &aws.Operation{
		Name:       opUpdateFindingsFeedback,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/findings/feedback",
	}

	if input == nil {
		input = &UpdateFindingsFeedbackInput{}
	}

	req := c.newRequest(op, input, &UpdateFindingsFeedbackOutput{})
	return UpdateFindingsFeedbackRequest{Request: req, Input: input, Copy: c.UpdateFindingsFeedbackRequest}
}

// UpdateFindingsFeedbackRequest is the request type for the
// UpdateFindingsFeedback API operation.
type UpdateFindingsFeedbackRequest struct {
	*aws.Request
	Input *UpdateFindingsFeedbackInput
	Copy  func(*UpdateFindingsFeedbackInput) UpdateFindingsFeedbackRequest
}

// Send marshals and sends the UpdateFindingsFeedback API request.
func (r UpdateFindingsFeedbackRequest) Send(ctx context.Context) (*UpdateFindingsFeedbackResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateFindingsFeedbackResponse{
		UpdateFindingsFeedbackOutput: r.Request.Data.(*UpdateFindingsFeedbackOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateFindingsFeedbackResponse is the response type for the
// UpdateFindingsFeedback API operation.
type UpdateFindingsFeedbackResponse struct {
	*UpdateFindingsFeedbackOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateFindingsFeedback request.
func (r *UpdateFindingsFeedbackResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
