// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachGroupPolicyRequest
type DetachGroupPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name (friendly name, not ARN) of the IAM group to detach the policy from.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM policy you want to detach.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicyArn is a required field
	PolicyArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachGroupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachGroupPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetachGroupPolicyInput"}

	if s.GroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GroupName", 1))
	}

	if s.PolicyArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachGroupPolicyOutput
type DetachGroupPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachGroupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opDetachGroupPolicy = "DetachGroupPolicy"

// DetachGroupPolicyRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Removes the specified managed policy from the specified IAM group.
//
// A group can also have inline policies embedded with it. To delete an inline
// policy, use the DeleteGroupPolicy API. For information about policies, see
// Managed Policies and Inline Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
//    // Example sending a request using DetachGroupPolicyRequest.
//    req := client.DetachGroupPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachGroupPolicy
func (c *Client) DetachGroupPolicyRequest(input *DetachGroupPolicyInput) DetachGroupPolicyRequest {
	op := &aws.Operation{
		Name:       opDetachGroupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachGroupPolicyInput{}
	}

	req := c.newRequest(op, input, &DetachGroupPolicyOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DetachGroupPolicyRequest{Request: req, Input: input, Copy: c.DetachGroupPolicyRequest}
}

// DetachGroupPolicyRequest is the request type for the
// DetachGroupPolicy API operation.
type DetachGroupPolicyRequest struct {
	*aws.Request
	Input *DetachGroupPolicyInput
	Copy  func(*DetachGroupPolicyInput) DetachGroupPolicyRequest
}

// Send marshals and sends the DetachGroupPolicy API request.
func (r DetachGroupPolicyRequest) Send(ctx context.Context) (*DetachGroupPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DetachGroupPolicyResponse{
		DetachGroupPolicyOutput: r.Request.Data.(*DetachGroupPolicyOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DetachGroupPolicyResponse is the response type for the
// DetachGroupPolicy API operation.
type DetachGroupPolicyResponse struct {
	*DetachGroupPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DetachGroupPolicy request.
func (r *DetachGroupPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
