// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/StopAssessmentRunRequest
type StopAssessmentRunInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the assessment run that you want to stop.
	//
	// AssessmentRunArn is a required field
	AssessmentRunArn *string `locationName:"assessmentRunArn" min:"1" type:"string" required:"true"`

	// An input option that can be set to either START_EVALUATION or SKIP_EVALUATION.
	// START_EVALUATION (the default value), stops the AWS agent from collecting
	// data and begins the results evaluation and the findings generation process.
	// SKIP_EVALUATION cancels the assessment run immediately, after which no findings
	// are generated.
	StopAction StopAction `locationName:"stopAction" type:"string" enum:"true"`
}

// String returns the string representation
func (s StopAssessmentRunInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopAssessmentRunInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopAssessmentRunInput"}

	if s.AssessmentRunArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssessmentRunArn"))
	}
	if s.AssessmentRunArn != nil && len(*s.AssessmentRunArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssessmentRunArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/StopAssessmentRunOutput
type StopAssessmentRunOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopAssessmentRunOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopAssessmentRun = "StopAssessmentRun"

// StopAssessmentRunRequest returns a request value for making API operation for
// Amazon Inspector.
//
// Stops the assessment run that is specified by the ARN of the assessment run.
//
//    // Example sending a request using StopAssessmentRunRequest.
//    req := client.StopAssessmentRunRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/StopAssessmentRun
func (c *Client) StopAssessmentRunRequest(input *StopAssessmentRunInput) StopAssessmentRunRequest {
	op := &aws.Operation{
		Name:       opStopAssessmentRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopAssessmentRunInput{}
	}

	req := c.newRequest(op, input, &StopAssessmentRunOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return StopAssessmentRunRequest{Request: req, Input: input, Copy: c.StopAssessmentRunRequest}
}

// StopAssessmentRunRequest is the request type for the
// StopAssessmentRun API operation.
type StopAssessmentRunRequest struct {
	*aws.Request
	Input *StopAssessmentRunInput
	Copy  func(*StopAssessmentRunInput) StopAssessmentRunRequest
}

// Send marshals and sends the StopAssessmentRun API request.
func (r StopAssessmentRunRequest) Send(ctx context.Context) (*StopAssessmentRunResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopAssessmentRunResponse{
		StopAssessmentRunOutput: r.Request.Data.(*StopAssessmentRunOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopAssessmentRunResponse is the response type for the
// StopAssessmentRun API operation.
type StopAssessmentRunResponse struct {
	*StopAssessmentRunOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopAssessmentRun request.
func (r *StopAssessmentRunResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
