// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// The input for the DeletePolicyVersion operation.
type DeletePolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"policyName" min:"1" type:"string" required:"true"`

	// The policy version ID.
	//
	// PolicyVersionId is a required field
	PolicyVersionId *string `location:"uri" locationName:"policyVersionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeletePolicyVersionInput"}

	if s.PolicyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyName", 1))
	}

	if s.PolicyVersionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyVersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePolicyVersionInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.PolicyName != nil {
		v := *s.PolicyName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "policyName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyVersionId != nil {
		v := *s.PolicyVersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "policyVersionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeletePolicyVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePolicyVersionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeletePolicyVersion = "DeletePolicyVersion"

// DeletePolicyVersionRequest returns a request value for making API operation for
// AWS IoT.
//
// Deletes the specified version of the specified policy. You cannot delete
// the default version of a policy using this API. To delete the default version
// of a policy, use DeletePolicy. To find out which version of a policy is marked
// as the default version, use ListPolicyVersions.
//
//    // Example sending a request using DeletePolicyVersionRequest.
//    req := client.DeletePolicyVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeletePolicyVersionRequest(input *DeletePolicyVersionInput) DeletePolicyVersionRequest {
	op := &aws.Operation{
		Name:       opDeletePolicyVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/policies/{policyName}/version/{policyVersionId}",
	}

	if input == nil {
		input = &DeletePolicyVersionInput{}
	}

	req := c.newRequest(op, input, &DeletePolicyVersionOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeletePolicyVersionRequest{Request: req, Input: input, Copy: c.DeletePolicyVersionRequest}
}

// DeletePolicyVersionRequest is the request type for the
// DeletePolicyVersion API operation.
type DeletePolicyVersionRequest struct {
	*aws.Request
	Input *DeletePolicyVersionInput
	Copy  func(*DeletePolicyVersionInput) DeletePolicyVersionRequest
}

// Send marshals and sends the DeletePolicyVersion API request.
func (r DeletePolicyVersionRequest) Send(ctx context.Context) (*DeletePolicyVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePolicyVersionResponse{
		DeletePolicyVersionOutput: r.Request.Data.(*DeletePolicyVersionOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePolicyVersionResponse is the response type for the
// DeletePolicyVersion API operation.
type DeletePolicyVersionResponse struct {
	*DeletePolicyVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePolicyVersion request.
func (r *DeletePolicyVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
