// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListV2LoggingLevelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at one time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token used to get the next set of results, or null if there are no additional
	// results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The type of resource for which you are configuring logging. Must be THING_Group.
	TargetType LogTargetType `location:"querystring" locationName:"targetType" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListV2LoggingLevelsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListV2LoggingLevelsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListV2LoggingLevelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListV2LoggingLevelsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.TargetType) > 0 {
		v := s.TargetType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "targetType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type ListV2LoggingLevelsOutput struct {
	_ struct{} `type:"structure"`

	// The logging configuration for a target.
	LogTargetConfigurations []LogTargetConfiguration `locationName:"logTargetConfigurations" type:"list"`

	// The token used to get the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListV2LoggingLevelsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListV2LoggingLevelsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.LogTargetConfigurations) > 0 {
		v := s.LogTargetConfigurations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "logTargetConfigurations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListV2LoggingLevels = "ListV2LoggingLevels"

// ListV2LoggingLevelsRequest returns a request value for making API operation for
// AWS IoT.
//
// Lists logging levels.
//
//    // Example sending a request using ListV2LoggingLevelsRequest.
//    req := client.ListV2LoggingLevelsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListV2LoggingLevelsRequest(input *ListV2LoggingLevelsInput) ListV2LoggingLevelsRequest {
	op := &aws.Operation{
		Name:       opListV2LoggingLevels,
		HTTPMethod: "GET",
		HTTPPath:   "/v2LoggingLevel",
	}

	if input == nil {
		input = &ListV2LoggingLevelsInput{}
	}

	req := c.newRequest(op, input, &ListV2LoggingLevelsOutput{})
	return ListV2LoggingLevelsRequest{Request: req, Input: input, Copy: c.ListV2LoggingLevelsRequest}
}

// ListV2LoggingLevelsRequest is the request type for the
// ListV2LoggingLevels API operation.
type ListV2LoggingLevelsRequest struct {
	*aws.Request
	Input *ListV2LoggingLevelsInput
	Copy  func(*ListV2LoggingLevelsInput) ListV2LoggingLevelsRequest
}

// Send marshals and sends the ListV2LoggingLevels API request.
func (r ListV2LoggingLevelsRequest) Send(ctx context.Context) (*ListV2LoggingLevelsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListV2LoggingLevelsResponse{
		ListV2LoggingLevelsOutput: r.Request.Data.(*ListV2LoggingLevelsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListV2LoggingLevelsResponse is the response type for the
// ListV2LoggingLevels API operation.
type ListV2LoggingLevelsResponse struct {
	*ListV2LoggingLevelsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListV2LoggingLevels request.
func (r *ListV2LoggingLevelsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
