// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotanalytics

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdatePipelineRequest
type UpdatePipelineInput struct {
	_ struct{} `type:"structure"`

	// A list of "PipelineActivity" objects. Activities perform transformations
	// on your messages, such as removing, renaming or adding message attributes;
	// filtering messages based on attribute values; invoking your Lambda functions
	// on messages for advanced processing; or performing mathematical transformations
	// to normalize device data.
	//
	// The list can be 2-25 PipelineActivity objects and must contain both a channel
	// and a datastore activity. Each entry in the list must contain only one activity,
	// for example:
	//
	// pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ...
	// ]
	//
	// PipelineActivities is a required field
	PipelineActivities []PipelineActivity `locationName:"pipelineActivities" min:"1" type:"list" required:"true"`

	// The name of the pipeline to update.
	//
	// PipelineName is a required field
	PipelineName *string `location:"uri" locationName:"pipelineName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdatePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePipelineInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdatePipelineInput"}

	if s.PipelineActivities == nil {
		invalidParams.Add(aws.NewErrParamRequired("PipelineActivities"))
	}
	if s.PipelineActivities != nil && len(s.PipelineActivities) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PipelineActivities", 1))
	}

	if s.PipelineName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PipelineName", 1))
	}
	if s.PipelineActivities != nil {
		for i, v := range s.PipelineActivities {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PipelineActivities", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdatePipelineInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.PipelineActivities) > 0 {
		v := s.PipelineActivities

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "pipelineActivities", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.PipelineName != nil {
		v := *s.PipelineName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "pipelineName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdatePipelineOutput
type UpdatePipelineOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdatePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdatePipelineOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdatePipeline = "UpdatePipeline"

// UpdatePipelineRequest returns a request value for making API operation for
// AWS IoT Analytics.
//
// Updates the settings of a pipeline. You must specify both a channel and a
// datastore activity and, optionally, as many as 23 additional activities in
// the pipelineActivities array.
//
//    // Example sending a request using UpdatePipelineRequest.
//    req := client.UpdatePipelineRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/UpdatePipeline
func (c *Client) UpdatePipelineRequest(input *UpdatePipelineInput) UpdatePipelineRequest {
	op := &aws.Operation{
		Name:       opUpdatePipeline,
		HTTPMethod: "PUT",
		HTTPPath:   "/pipelines/{pipelineName}",
	}

	if input == nil {
		input = &UpdatePipelineInput{}
	}

	req := c.newRequest(op, input, &UpdatePipelineOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UpdatePipelineRequest{Request: req, Input: input, Copy: c.UpdatePipelineRequest}
}

// UpdatePipelineRequest is the request type for the
// UpdatePipeline API operation.
type UpdatePipelineRequest struct {
	*aws.Request
	Input *UpdatePipelineInput
	Copy  func(*UpdatePipelineInput) UpdatePipelineRequest
}

// Send marshals and sends the UpdatePipeline API request.
func (r UpdatePipelineRequest) Send(ctx context.Context) (*UpdatePipelineResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdatePipelineResponse{
		UpdatePipelineOutput: r.Request.Data.(*UpdatePipelineOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdatePipelineResponse is the response type for the
// UpdatePipeline API operation.
type UpdatePipelineResponse struct {
	*UpdatePipelineOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdatePipeline request.
func (r *UpdatePipelineResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
