// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancersRequest
type GetLoadBalancersInput struct {
	_ struct{} `type:"structure"`

	// A token used for paginating the results from your GetLoadBalancers request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetLoadBalancersInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancersResult
type GetLoadBalancersOutput struct {
	_ struct{} `type:"structure"`

	// An array of LoadBalancer objects describing your load balancers.
	LoadBalancers []LoadBalancer `locationName:"loadBalancers" type:"list"`

	// A token used for advancing to the next page of results from your GetLoadBalancers
	// request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetLoadBalancersOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetLoadBalancers = "GetLoadBalancers"

// GetLoadBalancersRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns information about all load balancers in an account.
//
// If you are describing a long list of load balancers, you can paginate the
// output to make the list more manageable. You can use the pageToken and nextPageToken
// values to retrieve the next items in the list.
//
//    // Example sending a request using GetLoadBalancersRequest.
//    req := client.GetLoadBalancersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancers
func (c *Client) GetLoadBalancersRequest(input *GetLoadBalancersInput) GetLoadBalancersRequest {
	op := &aws.Operation{
		Name:       opGetLoadBalancers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLoadBalancersInput{}
	}

	req := c.newRequest(op, input, &GetLoadBalancersOutput{})
	return GetLoadBalancersRequest{Request: req, Input: input, Copy: c.GetLoadBalancersRequest}
}

// GetLoadBalancersRequest is the request type for the
// GetLoadBalancers API operation.
type GetLoadBalancersRequest struct {
	*aws.Request
	Input *GetLoadBalancersInput
	Copy  func(*GetLoadBalancersInput) GetLoadBalancersRequest
}

// Send marshals and sends the GetLoadBalancers API request.
func (r GetLoadBalancersRequest) Send(ctx context.Context) (*GetLoadBalancersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetLoadBalancersResponse{
		GetLoadBalancersOutput: r.Request.Data.(*GetLoadBalancersOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetLoadBalancersResponse is the response type for the
// GetLoadBalancers API operation.
type GetLoadBalancersResponse struct {
	*GetLoadBalancersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetLoadBalancers request.
func (r *GetLoadBalancersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
