// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIpRequest
type GetStaticIpInput struct {
	_ struct{} `type:"structure"`

	// The name of the static IP in Lightsail.
	//
	// StaticIpName is a required field
	StaticIpName *string `locationName:"staticIpName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStaticIpInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStaticIpInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetStaticIpInput"}

	if s.StaticIpName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StaticIpName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIpResult
type GetStaticIpOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the requested static
	// IP.
	StaticIp *StaticIp `locationName:"staticIp" type:"structure"`
}

// String returns the string representation
func (s GetStaticIpOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetStaticIp = "GetStaticIp"

// GetStaticIpRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns information about a specific static IP.
//
//    // Example sending a request using GetStaticIpRequest.
//    req := client.GetStaticIpRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIp
func (c *Client) GetStaticIpRequest(input *GetStaticIpInput) GetStaticIpRequest {
	op := &aws.Operation{
		Name:       opGetStaticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStaticIpInput{}
	}

	req := c.newRequest(op, input, &GetStaticIpOutput{})
	return GetStaticIpRequest{Request: req, Input: input, Copy: c.GetStaticIpRequest}
}

// GetStaticIpRequest is the request type for the
// GetStaticIp API operation.
type GetStaticIpRequest struct {
	*aws.Request
	Input *GetStaticIpInput
	Copy  func(*GetStaticIpInput) GetStaticIpRequest
}

// Send marshals and sends the GetStaticIp API request.
func (r GetStaticIpRequest) Send(ctx context.Context) (*GetStaticIpResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetStaticIpResponse{
		GetStaticIpOutput: r.Request.Data.(*GetStaticIpOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetStaticIpResponse is the response type for the
// GetStaticIp API operation.
type GetStaticIpResponse struct {
	*GetStaticIpOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetStaticIp request.
func (r *GetStaticIpResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
