// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package medialive

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannelRequest
type DescribeChannelInput struct {
	_ struct{} `type:"structure"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeChannelInput"}

	if s.ChannelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChannelId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ChannelId != nil {
		v := *s.ChannelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "channelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannelResponse
type DescribeChannelOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// A standard channel has two encoding pipelines and a single pipeline channel
	// only has one.
	ChannelClass ChannelClass `locationName:"channelClass" type:"string" enum:"true"`

	Destinations []OutputDestination `locationName:"destinations" type:"list"`

	EgressEndpoints []ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	// Encoder Settings
	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	InputAttachments []InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	// The log level the user wants for their channel.
	LogLevel LogLevel `locationName:"logLevel" type:"string" enum:"true"`

	Name *string `locationName:"name" type:"string"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	RoleArn *string `locationName:"roleArn" type:"string"`

	State ChannelState `locationName:"state" type:"string" enum:"true"`

	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DescribeChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ChannelClass) > 0 {
		v := s.ChannelClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelClass", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Destinations) > 0 {
		v := s.Destinations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "destinations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.EgressEndpoints) > 0 {
		v := s.EgressEndpoints

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "egressEndpoints", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.EncoderSettings != nil {
		v := s.EncoderSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "encoderSettings", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.InputAttachments) > 0 {
		v := s.InputAttachments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "inputAttachments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.InputSpecification != nil {
		v := s.InputSpecification

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "inputSpecification", v, metadata)
	}
	if len(s.LogLevel) > 0 {
		v := s.LogLevel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "logLevel", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PipelinesRunningCount != nil {
		v := *s.PipelinesRunningCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pipelinesRunningCount", protocol.Int64Value(v), metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

const opDescribeChannel = "DescribeChannel"

// DescribeChannelRequest returns a request value for making API operation for
// AWS Elemental MediaLive.
//
// Gets details about a channel
//
//    // Example sending a request using DescribeChannelRequest.
//    req := client.DescribeChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannel
func (c *Client) DescribeChannelRequest(input *DescribeChannelInput) DescribeChannelRequest {
	op := &aws.Operation{
		Name:       opDescribeChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/channels/{channelId}",
	}

	if input == nil {
		input = &DescribeChannelInput{}
	}

	req := c.newRequest(op, input, &DescribeChannelOutput{})
	return DescribeChannelRequest{Request: req, Input: input, Copy: c.DescribeChannelRequest}
}

// DescribeChannelRequest is the request type for the
// DescribeChannel API operation.
type DescribeChannelRequest struct {
	*aws.Request
	Input *DescribeChannelInput
	Copy  func(*DescribeChannelInput) DescribeChannelRequest
}

// Send marshals and sends the DescribeChannel API request.
func (r DescribeChannelRequest) Send(ctx context.Context) (*DescribeChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeChannelResponse{
		DescribeChannelOutput: r.Request.Data.(*DescribeChannelOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeChannelResponse is the response type for the
// DescribeChannel API operation.
type DescribeChannelResponse struct {
	*DescribeChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeChannel request.
func (r *DescribeChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
