// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to retrieve an existing custom verification email template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetCustomVerificationEmailTemplateRequest
type GetCustomVerificationEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom verification email template that you want to retrieve.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetCustomVerificationEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCustomVerificationEmailTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCustomVerificationEmailTemplateInput"}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The content of the custom verification email template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetCustomVerificationEmailTemplateResponse
type GetCustomVerificationEmailTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is not successfully verified.
	FailureRedirectionURL *string `type:"string"`

	// The email address that the custom verification email is sent from.
	FromEmailAddress *string `type:"string"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is successfully verified.
	SuccessRedirectionURL *string `type:"string"`

	// The content of the custom verification email.
	TemplateContent *string `type:"string"`

	// The name of the custom verification email template.
	TemplateName *string `type:"string"`

	// The subject line of the custom verification email.
	TemplateSubject *string `type:"string"`
}

// String returns the string representation
func (s GetCustomVerificationEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetCustomVerificationEmailTemplate = "GetCustomVerificationEmailTemplate"

// GetCustomVerificationEmailTemplateRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Returns the custom email verification template for the template name you
// specify.
//
// For more information about custom verification email templates, see Using
// Custom Verification Email Templates (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html)
// in the Amazon SES Developer Guide.
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using GetCustomVerificationEmailTemplateRequest.
//    req := client.GetCustomVerificationEmailTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetCustomVerificationEmailTemplate
func (c *Client) GetCustomVerificationEmailTemplateRequest(input *GetCustomVerificationEmailTemplateInput) GetCustomVerificationEmailTemplateRequest {
	op := &aws.Operation{
		Name:       opGetCustomVerificationEmailTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCustomVerificationEmailTemplateInput{}
	}

	req := c.newRequest(op, input, &GetCustomVerificationEmailTemplateOutput{})
	return GetCustomVerificationEmailTemplateRequest{Request: req, Input: input, Copy: c.GetCustomVerificationEmailTemplateRequest}
}

// GetCustomVerificationEmailTemplateRequest is the request type for the
// GetCustomVerificationEmailTemplate API operation.
type GetCustomVerificationEmailTemplateRequest struct {
	*aws.Request
	Input *GetCustomVerificationEmailTemplateInput
	Copy  func(*GetCustomVerificationEmailTemplateInput) GetCustomVerificationEmailTemplateRequest
}

// Send marshals and sends the GetCustomVerificationEmailTemplate API request.
func (r GetCustomVerificationEmailTemplateRequest) Send(ctx context.Context) (*GetCustomVerificationEmailTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCustomVerificationEmailTemplateResponse{
		GetCustomVerificationEmailTemplateOutput: r.Request.Data.(*GetCustomVerificationEmailTemplateOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCustomVerificationEmailTemplateResponse is the response type for the
// GetCustomVerificationEmailTemplate API operation.
type GetCustomVerificationEmailTemplateResponse struct {
	*GetCustomVerificationEmailTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCustomVerificationEmailTemplate request.
func (r *GetCustomVerificationEmailTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
