// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTaskWithMaintenanceWindowRequest
type RegisterTaskWithMaintenanceWindowInput struct {
	_ struct{} `type:"structure"`

	// User-provided idempotency token.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// An optional description for the task.
	Description *string `min:"1" type:"string"`

	// A structure containing information about an Amazon S3 bucket to write instance-level
	// logs to.
	//
	// LoggingInfo has been deprecated. To specify an S3 bucket to contain logs,
	// instead use the OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters
	// structure. For information about how Systems Manager handles these options
	// for the supported Maintenance Window task types, see MaintenanceWindowTaskInvocationParameters.
	LoggingInfo *LoggingInfo `type:"structure"`

	// The maximum number of targets this task can be run for in parallel.
	//
	// MaxConcurrency is a required field
	MaxConcurrency *string `min:"1" type:"string" required:"true"`

	// The maximum number of errors allowed before this task stops being scheduled.
	//
	// MaxErrors is a required field
	MaxErrors *string `min:"1" type:"string" required:"true"`

	// An optional name for the task.
	Name *string `min:"3" type:"string"`

	// The priority of the task in the Maintenance Window, the lower the number
	// the higher the priority. Tasks in a Maintenance Window are scheduled in priority
	// order with tasks that have the same priority scheduled in parallel.
	Priority *int64 `type:"integer"`

	// The role to assume when running the Maintenance Window task.
	//
	// If you do not specify a service role ARN, Systems Manager will use your account's
	// service-linked role for Systems Manager by default. If no service-linked
	// role for Systems Manager exists in your account, it will be created when
	// you run RegisterTaskWithMaintenanceWindow without specifying a service role
	// ARN.
	//
	// For more information, see Service-Linked Role Permissions for Systems Manager
	// (http://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions)
	// and Should I Use a Service-Linked Role or a Custom Service Role to Run Maintenance
	// Window Tasks? (http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role)
	// in the AWS Systems Manager User Guide.
	ServiceRoleArn *string `type:"string"`

	// The targets (either instances or Maintenance Window targets).
	//
	// Specify instances using the following format:
	//
	// Key=InstanceIds,Values=<instance-id-1>,<instance-id-2>
	//
	// Specify Maintenance Window targets using the following format:
	//
	// Key=<WindowTargetIds>,Values=<window-target-id-1>,<window-target-id-2>
	//
	// Targets is a required field
	Targets []Target `type:"list" required:"true"`

	// The ARN of the task to run.
	//
	// TaskArn is a required field
	TaskArn *string `min:"1" type:"string" required:"true"`

	// The parameters that the task should use during execution. Populate only the
	// fields that match the task type. All other fields should be empty.
	TaskInvocationParameters *MaintenanceWindowTaskInvocationParameters `type:"structure"`

	// The parameters that should be passed to the task when it is run.
	//
	// TaskParameters has been deprecated. To specify parameters to pass to a task
	// when it runs, instead use the Parameters option in the TaskInvocationParameters
	// structure. For information about how Systems Manager handles these options
	// for the supported Maintenance Window task types, see MaintenanceWindowTaskInvocationParameters.
	TaskParameters map[string]MaintenanceWindowTaskParameterValueExpression `type:"map"`

	// The type of task being registered.
	//
	// TaskType is a required field
	TaskType MaintenanceWindowTaskType `type:"string" required:"true" enum:"true"`

	// The ID of the Maintenance Window the task should be added to.
	//
	// WindowId is a required field
	WindowId *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterTaskWithMaintenanceWindowInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterTaskWithMaintenanceWindowInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegisterTaskWithMaintenanceWindowInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.MaxConcurrency == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxConcurrency"))
	}
	if s.MaxConcurrency != nil && len(*s.MaxConcurrency) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MaxConcurrency", 1))
	}

	if s.MaxErrors == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxErrors"))
	}
	if s.MaxErrors != nil && len(*s.MaxErrors) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MaxErrors", 1))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 3))
	}

	if s.Targets == nil {
		invalidParams.Add(aws.NewErrParamRequired("Targets"))
	}

	if s.TaskArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskArn"))
	}
	if s.TaskArn != nil && len(*s.TaskArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskArn", 1))
	}
	if len(s.TaskType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("TaskType"))
	}

	if s.WindowId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WindowId"))
	}
	if s.WindowId != nil && len(*s.WindowId) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("WindowId", 20))
	}
	if s.LoggingInfo != nil {
		if err := s.LoggingInfo.Validate(); err != nil {
			invalidParams.AddNested("LoggingInfo", err.(aws.ErrInvalidParams))
		}
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TaskInvocationParameters != nil {
		if err := s.TaskInvocationParameters.Validate(); err != nil {
			invalidParams.AddNested("TaskInvocationParameters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTaskWithMaintenanceWindowResult
type RegisterTaskWithMaintenanceWindowOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the task in the Maintenance Window.
	WindowTaskId *string `min:"36" type:"string"`
}

// String returns the string representation
func (s RegisterTaskWithMaintenanceWindowOutput) String() string {
	return awsutil.Prettify(s)
}

const opRegisterTaskWithMaintenanceWindow = "RegisterTaskWithMaintenanceWindow"

// RegisterTaskWithMaintenanceWindowRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Adds a new task to a Maintenance Window.
//
//    // Example sending a request using RegisterTaskWithMaintenanceWindowRequest.
//    req := client.RegisterTaskWithMaintenanceWindowRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTaskWithMaintenanceWindow
func (c *Client) RegisterTaskWithMaintenanceWindowRequest(input *RegisterTaskWithMaintenanceWindowInput) RegisterTaskWithMaintenanceWindowRequest {
	op := &aws.Operation{
		Name:       opRegisterTaskWithMaintenanceWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterTaskWithMaintenanceWindowInput{}
	}

	req := c.newRequest(op, input, &RegisterTaskWithMaintenanceWindowOutput{})
	return RegisterTaskWithMaintenanceWindowRequest{Request: req, Input: input, Copy: c.RegisterTaskWithMaintenanceWindowRequest}
}

// RegisterTaskWithMaintenanceWindowRequest is the request type for the
// RegisterTaskWithMaintenanceWindow API operation.
type RegisterTaskWithMaintenanceWindowRequest struct {
	*aws.Request
	Input *RegisterTaskWithMaintenanceWindowInput
	Copy  func(*RegisterTaskWithMaintenanceWindowInput) RegisterTaskWithMaintenanceWindowRequest
}

// Send marshals and sends the RegisterTaskWithMaintenanceWindow API request.
func (r RegisterTaskWithMaintenanceWindowRequest) Send(ctx context.Context) (*RegisterTaskWithMaintenanceWindowResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterTaskWithMaintenanceWindowResponse{
		RegisterTaskWithMaintenanceWindowOutput: r.Request.Data.(*RegisterTaskWithMaintenanceWindowOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterTaskWithMaintenanceWindowResponse is the response type for the
// RegisterTaskWithMaintenanceWindow API operation.
type RegisterTaskWithMaintenanceWindowResponse struct {
	*RegisterTaskWithMaintenanceWindowOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterTaskWithMaintenanceWindow request.
func (r *RegisterTaskWithMaintenanceWindowResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
