// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAssociationsOnceRequest
type StartAssociationsOnceInput struct {
	_ struct{} `type:"structure"`

	// The association IDs that you want to run immediately and only one time.
	//
	// AssociationIds is a required field
	AssociationIds []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s StartAssociationsOnceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartAssociationsOnceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartAssociationsOnceInput"}

	if s.AssociationIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssociationIds"))
	}
	if s.AssociationIds != nil && len(s.AssociationIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssociationIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAssociationsOnceResult
type StartAssociationsOnceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartAssociationsOnceOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartAssociationsOnce = "StartAssociationsOnce"

// StartAssociationsOnceRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Use this API action to run an association immediately and only one time.
// This action can be helpful when troubleshooting associations.
//
//    // Example sending a request using StartAssociationsOnceRequest.
//    req := client.StartAssociationsOnceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAssociationsOnce
func (c *Client) StartAssociationsOnceRequest(input *StartAssociationsOnceInput) StartAssociationsOnceRequest {
	op := &aws.Operation{
		Name:       opStartAssociationsOnce,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartAssociationsOnceInput{}
	}

	req := c.newRequest(op, input, &StartAssociationsOnceOutput{})
	return StartAssociationsOnceRequest{Request: req, Input: input, Copy: c.StartAssociationsOnceRequest}
}

// StartAssociationsOnceRequest is the request type for the
// StartAssociationsOnce API operation.
type StartAssociationsOnceRequest struct {
	*aws.Request
	Input *StartAssociationsOnceInput
	Copy  func(*StartAssociationsOnceInput) StartAssociationsOnceRequest
}

// Send marshals and sends the StartAssociationsOnce API request.
func (r StartAssociationsOnceRequest) Send(ctx context.Context) (*StartAssociationsOnceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartAssociationsOnceResponse{
		StartAssociationsOnceOutput: r.Request.Data.(*StartAssociationsOnceOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartAssociationsOnceResponse is the response type for the
// StartAssociationsOnce API operation.
type StartAssociationsOnceResponse struct {
	*StartAssociationsOnceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartAssociationsOnce request.
func (r *StartAssociationsOnceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
