// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package textract

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// A Block represents items that are recognized in a document within a group
// of pixels close to each other. The information returned in a Block depends
// on the type of operation. In document-text detection (for example DetectDocumentText),
// you get information about the detected words and lines of text. In text analysis
// (for example AnalyzeDocument), you can also get information about the fields,
// tables and selection elements that are detected in the document.
//
// An array of Block objects is returned by both synchronous and asynchronous
// operations. In synchronous operations, such as DetectDocumentText, the array
// of Block objects is the entire set of results. In asynchronous operations,
// such as GetDocumentAnalysis, the array is returned over one or more responses.
//
// For more information, see How Amazon Textract Works (https://docs.aws.amazon.com/textract/latest/dg/how-it-works.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/Block
type Block struct {
	_ struct{} `type:"structure"`

	// The type of text that's recognized in a block. In text-detection operations,
	// the following types are returned:
	//
	//    * PAGE - Contains a list of the LINE Block objects that are detected on
	//    a document page.
	//
	//    * WORD - A word detected on a document page. A word is one or more ISO
	//    basic Latin script characters that aren't separated by spaces.
	//
	//    * LINE - A string of tab-delimited, contiguous words that's detected on
	//    a document page.
	//
	// In text analysis operations, the following types are returned:
	//
	//    * PAGE - Contains a list of child Block objects that are detected on a
	//    document page.
	//
	//    * KEY_VALUE_SET - Stores the KEY and VALUE Block objects for a field that's
	//    detected on a document page. Use the EntityType field to determine if
	//    a KEY_VALUE_SET object is a KEY Block object or a VALUE Block object.
	//
	//    * WORD - A word detected on a document page. A word is one or more ISO
	//    basic Latin script characters that aren't separated by spaces that's detected
	//    on a document page.
	//
	//    * LINE - A string of tab-delimited, contiguous words that's detected on
	//    a document page.
	//
	//    * TABLE - A table that's detected on a document page. A table is any grid-based
	//    information with 2 or more rows or columns with a cell span of 1 row and
	//    1 column each.
	//
	//    * CELL - A cell within a detected table. The cell is the parent of the
	//    block that contains the text in the cell.
	//
	//    * SELECTION_ELEMENT - A selectable element such as a radio button or checkbox
	//    that's detected on a document page. Use the value of SelectionStatus to
	//    determine the status of the selection element.
	BlockType BlockType `type:"string" enum:"true"`

	// The column in which a table cell appears. The first column position is 1.
	// ColumnIndex isn't returned by DetectDocumentText and GetDocumentTextDetection.
	ColumnIndex *int64 `type:"integer"`

	// The number of columns that a table cell spans. ColumnSpan isn't returned
	// by DetectDocumentText and GetDocumentTextDetection.
	ColumnSpan *int64 `type:"integer"`

	// The confidence that Amazon Textract has in the accuracy of the recognized
	// text and the accuracy of the geometry points around the recognized text.
	Confidence *float64 `type:"float"`

	// The type of entity. The following can be returned:
	//
	//    * KEY - An identifier for a field on the document.
	//
	//    * VALUE - The field text.
	//
	// EntityTypes isn't returned by DetectDocumentText and GetDocumentTextDetection.
	EntityTypes []EntityType `type:"list"`

	// The location of the recognized text on the image. It includes an axis-aligned,
	// coarse bounding box that surrounds the text, and a finer-grain polygon for
	// more accurate spatial information.
	Geometry *Geometry `type:"structure"`

	// The identifier for the recognized text. The identifier is only unique for
	// a single operation.
	Id *string `type:"string"`

	// The page in which a block was detected. Page is returned by asynchronous
	// operations. Page values greater than 1 are only returned for multi-page documents
	// that are in PDF format. A scanned image (JPG/PNG), even if it contains multiple
	// document pages, is always considered to be a single-page document and the
	// value of Page is always 1. Synchronous operations don't return Page as every
	// input document is considered to be a single-page document.
	Page *int64 `type:"integer"`

	// A list of child blocks of the current block. For example a LINE object has
	// child blocks for each WORD block that's part of the line of text. There aren't
	// Relationship objects in the list for relationships that don't exist, such
	// as when the current block has no child blocks. The list size can be the following:
	//
	//    * 0 - The block has no child blocks.
	//
	//    * 1 - The block has child blocks.
	Relationships []Relationship `type:"list"`

	// The row in which a table cell is located. The first row position is 1. RowIndex
	// isn't returned by DetectDocumentText and GetDocumentTextDetection.
	RowIndex *int64 `type:"integer"`

	// The number of rows that a table spans. RowSpan isn't returned by DetectDocumentText
	// and GetDocumentTextDetection.
	RowSpan *int64 `type:"integer"`

	// The selection status of a selectable element such as a radio button or checkbox.
	SelectionStatus SelectionStatus `type:"string" enum:"true"`

	// The word or line of text that's recognized by Amazon Textract.
	Text *string `type:"string"`
}

// String returns the string representation
func (s Block) String() string {
	return awsutil.Prettify(s)
}

// The bounding box around the recognized text, key, value, table or table cell
// on a document page. The left (x-coordinate) and top (y-coordinate) are coordinates
// that represent the top and left sides of the bounding box. Note that the
// upper-left corner of the image is the origin (0,0).
//
// The top and left values returned are ratios of the overall document page
// size. For example, if the input image is 700 x 200 pixels, and the top-left
// coordinate of the bounding box is 350 x 50 pixels, the API returns a left
// value of 0.5 (350/700) and a top value of 0.25 (50/200).
//
// The width and height values represent the dimensions of the bounding box
// as a ratio of the overall document page dimension. For example, if the document
// page size is 700 x 200 pixels, and the bounding box width is 70 pixels, the
// width returned is 0.1.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/BoundingBox
type BoundingBox struct {
	_ struct{} `type:"structure"`

	// The height of the bounding box as a ratio of the overall document page height.
	Height *float64 `type:"float"`

	// The left coordinate of the bounding box as a ratio of overall document page
	// width.
	Left *float64 `type:"float"`

	// The top coordinate of the bounding box as a ratio of overall document page
	// height.
	Top *float64 `type:"float"`

	// The width of the bounding box as a ratio of the overall document page width.
	Width *float64 `type:"float"`
}

// String returns the string representation
func (s BoundingBox) String() string {
	return awsutil.Prettify(s)
}

// The input document, either as bytes or as an S3 object.
//
// You pass image bytes to an Amazon Textract API operation by using the Bytes
// property. For example, you would use the Bytes property to pass a document
// loaded from a local file system. Image bytes passed by using the Bytes property
// must be base64 encoded. Your code might not need to encode document file
// bytes if you're using an AWS SDK to call Amazon Textract API operations.
//
// You pass images stored in an S3 bucket to an Amazon Textract API operation
// by using the S3Object property. Documents stored in an S3 bucket don't need
// to be base64 encoded.
//
// The AWS Region for the S3 bucket that contains the S3 object must match the
// AWS Region that you use for Amazon Textract operations.
//
// If you use the AWS CLI to call Amazon Textract operations, passing image
// bytes using the Bytes property isn't supported. You must first upload the
// document to an Amazon S3 bucket, and then call the operation using the S3Object
// property.
//
// For Amazon Textract to process an S3 object, the user must have permission
// to access the S3 object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/Document
type Document struct {
	_ struct{} `type:"structure"`

	// A blob of base-64 encoded documents bytes. The maximum size of a document
	// that's provided in a blob of bytes is 5 MB. The document bytes must be in
	// PNG or JPG format.
	//
	// If you are using an AWS SDK to call Amazon Textract, you might not need to
	// base64-encode image bytes passed using the Bytes field.
	//
	// Bytes is automatically base64 encoded/decoded by the SDK.
	Bytes []byte `min:"1" type:"blob"`

	// Identifies an S3 object as the document source. The maximum size of a document
	// stored in an S3 bucket is 5 MB.
	S3Object *S3Object `type:"structure"`
}

// String returns the string representation
func (s Document) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Document) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Document"}
	if s.Bytes != nil && len(s.Bytes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Bytes", 1))
	}
	if s.S3Object != nil {
		if err := s.S3Object.Validate(); err != nil {
			invalidParams.AddNested("S3Object", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The Amazon S3 bucket that contains the document to be processed. It's used
// by asynchronous operations such as StartDocumentTextDetection.
//
// The input document can be an image file in JPG or PNG format. It can also
// be a file in PDF format.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/DocumentLocation
type DocumentLocation struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket that contains the input document.
	S3Object *S3Object `type:"structure"`
}

// String returns the string representation
func (s DocumentLocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentLocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DocumentLocation"}
	if s.S3Object != nil {
		if err := s.S3Object.Validate(); err != nil {
			invalidParams.AddNested("S3Object", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the input document.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/DocumentMetadata
type DocumentMetadata struct {
	_ struct{} `type:"structure"`

	// The number of pages detected in the document.
	Pages *int64 `type:"integer"`
}

// String returns the string representation
func (s DocumentMetadata) String() string {
	return awsutil.Prettify(s)
}

// Information about where a recognized text, key, value, table, or table cell
// is located on a document page.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/Geometry
type Geometry struct {
	_ struct{} `type:"structure"`

	// An axis-aligned coarse representation of the location of the recognized text
	// on the document page.
	BoundingBox *BoundingBox `type:"structure"`

	// Within the bounding box, a fine-grained polygon around the recognized text.
	Polygon []Point `type:"list"`
}

// String returns the string representation
func (s Geometry) String() string {
	return awsutil.Prettify(s)
}

// The Amazon Simple Notification Service (Amazon SNS) topic to which Amazon
// Textract publishes the completion status of an asynchronous document operation,
// such as StartDocumentTextDetection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/NotificationChannel
type NotificationChannel struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role that gives Amazon Textract
	// publishing permissions to the Amazon SNS topic.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// The Amazon SNS topic that Amazon Textract posts the completion status to.
	//
	// SNSTopicArn is a required field
	SNSTopicArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s NotificationChannel) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationChannel) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NotificationChannel"}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if s.SNSTopicArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SNSTopicArn"))
	}
	if s.SNSTopicArn != nil && len(*s.SNSTopicArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("SNSTopicArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The X and Y coordinates of a point on a document page. The X and Y values
// returned are ratios of the overall document page size. For example, if the
// input document is 700 x 200 and the operation returns X=0.5 and Y=0.25, then
// the point is at the (350,50) pixel coordinate on the document page.
//
// An array of Point objects, Polygon, is returned by DetectDocumentText. Polygon
// represents a fine-grained polygon around detected text. For more information,
// see Geometry in the Amazon Textract Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/Point
type Point struct {
	_ struct{} `type:"structure"`

	// The value of the X coordinate for a point on a Polygon.
	X *float64 `type:"float"`

	// The value of the Y coordinate for a point on a Polygon.
	Y *float64 `type:"float"`
}

// String returns the string representation
func (s Point) String() string {
	return awsutil.Prettify(s)
}

// Information about how blocks are related to each other. A Block object contains
// 0 or more Relation objects in a list, Relationships. For more information,
// see Block.
//
// The Type element provides the type of the relationship for all blocks in
// the IDs array.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/Relationship
type Relationship struct {
	_ struct{} `type:"structure"`

	// An array of IDs for related blocks. You can get the type of the relationship
	// from the Type element.
	Ids []string `type:"list"`

	// The type of relationship that the blocks in the IDs array have with the current
	// block. The relationship can be VALUE or CHILD.
	Type RelationshipType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Relationship) String() string {
	return awsutil.Prettify(s)
}

// The S3 bucket name and file name that identifies the document.
//
// The AWS Region for the S3 bucket that contains the document must match the
// Region that you use for Amazon Textract operations.
//
// For Amazon Textract to process a file in an S3 bucket, the user must have
// permission to access the S3 bucket and file.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/S3Object
type S3Object struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket.
	Bucket *string `min:"3" type:"string"`

	// The file name of the input document. It must be an image file (.JPG or .PNG
	// format). Asynchronous operations also support PDF files.
	Name *string `min:"1" type:"string"`

	// If the bucket has versioning enabled, you can specify the object version.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation
func (s S3Object) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Object) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Object"}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Bucket", 3))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A warning about an issue that occurred during asynchronous text analysis
// (StartDocumentAnalysis) or asynchronous document-text detection (StartDocumentTextDetection).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/Warning
type Warning struct {
	_ struct{} `type:"structure"`

	// The error code for the warning.
	ErrorCode *string `type:"string"`

	// A list of the pages that the warning applies to.
	Pages []int64 `type:"list"`
}

// String returns the string representation
func (s Warning) String() string {
	return awsutil.Prettify(s)
}
