// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transfer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TestIdentityProviderRequest
type TestIdentityProviderInput struct {
	_ struct{} `type:"structure"`

	// A system assigned identifier for a specific server. That server's user authentication
	// method is tested with a user name and password.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`

	// This request parameter is name of the user account to be tested.
	//
	// UserName is a required field
	UserName *string `type:"string" required:"true"`

	// The password of the user account to be tested.
	UserPassword *string `type:"string"`
}

// String returns the string representation
func (s TestIdentityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestIdentityProviderInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TestIdentityProviderInput"}

	if s.ServerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerId"))
	}

	if s.UserName == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TestIdentityProviderResponse
type TestIdentityProviderOutput struct {
	_ struct{} `type:"structure"`

	// The result of the authorization test as a message.
	Message *string `type:"string"`

	// The HTTP status code that is the response from your API Gateway.
	//
	// StatusCode is a required field
	StatusCode *int64 `type:"integer" required:"true"`

	// The endpoint of the service used to authenticate a user.
	//
	// Url is a required field
	Url *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TestIdentityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

const opTestIdentityProvider = "TestIdentityProvider"

// TestIdentityProviderRequest returns a request value for making API operation for
// AWS Transfer for SFTP.
//
// If the IdentityProviderType of the server is API_Gateway, tests whether your
// API Gateway is set up successfully. We highly recommend that you call this
// method to test your authentication method as soon as you create your server.
// By doing so, you can troubleshoot issues with the API Gateway integration
// to ensure that your users can successfully use the service.
//
//    // Example sending a request using TestIdentityProviderRequest.
//    req := client.TestIdentityProviderRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TestIdentityProvider
func (c *Client) TestIdentityProviderRequest(input *TestIdentityProviderInput) TestIdentityProviderRequest {
	op := &aws.Operation{
		Name:       opTestIdentityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestIdentityProviderInput{}
	}

	req := c.newRequest(op, input, &TestIdentityProviderOutput{})
	return TestIdentityProviderRequest{Request: req, Input: input, Copy: c.TestIdentityProviderRequest}
}

// TestIdentityProviderRequest is the request type for the
// TestIdentityProvider API operation.
type TestIdentityProviderRequest struct {
	*aws.Request
	Input *TestIdentityProviderInput
	Copy  func(*TestIdentityProviderInput) TestIdentityProviderRequest
}

// Send marshals and sends the TestIdentityProvider API request.
func (r TestIdentityProviderRequest) Send(ctx context.Context) (*TestIdentityProviderResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &TestIdentityProviderResponse{
		TestIdentityProviderOutput: r.Request.Data.(*TestIdentityProviderOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// TestIdentityProviderResponse is the response type for the
// TestIdentityProvider API operation.
type TestIdentityProviderResponse struct {
	*TestIdentityProviderOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// TestIdentityProvider request.
func (r *TestIdentityProviderResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
