// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafregional

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/AssociateWebACLRequest
type AssociateWebACLInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the resource to be protected, either an
	// application load balancer or Amazon API Gateway stage.
	//
	// The ARN should be in one of the following formats:
	//
	//    * For an Application Load Balancer: arn:aws:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id
	//
	//    * For an Amazon API Gateway stage: arn:aws:apigateway:region::/restapis/api-id/stages/stage-name
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// A unique identifier (ID) for the web ACL.
	//
	// WebACLId is a required field
	WebACLId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateWebACLInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateWebACLInput"}

	if s.ResourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceArn", 1))
	}

	if s.WebACLId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WebACLId"))
	}
	if s.WebACLId != nil && len(*s.WebACLId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WebACLId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/AssociateWebACLResponse
type AssociateWebACLOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssociateWebACL = "AssociateWebACL"

// AssociateWebACLRequest returns a request value for making API operation for
// AWS WAF Regional.
//
// Associates a web ACL with a resource, either an application load balancer
// or Amazon API Gateway stage.
//
//    // Example sending a request using AssociateWebACLRequest.
//    req := client.AssociateWebACLRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/AssociateWebACL
func (c *Client) AssociateWebACLRequest(input *AssociateWebACLInput) AssociateWebACLRequest {
	op := &aws.Operation{
		Name:       opAssociateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateWebACLInput{}
	}

	req := c.newRequest(op, input, &AssociateWebACLOutput{})
	return AssociateWebACLRequest{Request: req, Input: input, Copy: c.AssociateWebACLRequest}
}

// AssociateWebACLRequest is the request type for the
// AssociateWebACL API operation.
type AssociateWebACLRequest struct {
	*aws.Request
	Input *AssociateWebACLInput
	Copy  func(*AssociateWebACLInput) AssociateWebACLRequest
}

// Send marshals and sends the AssociateWebACL API request.
func (r AssociateWebACLRequest) Send(ctx context.Context) (*AssociateWebACLResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateWebACLResponse{
		AssociateWebACLOutput: r.Request.Data.(*AssociateWebACLOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateWebACLResponse is the response type for the
// AssociateWebACL API operation.
type AssociateWebACLResponse struct {
	*AssociateWebACLOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateWebACL request.
func (r *AssociateWebACLResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
