// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workdocs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateCustomMetadataRequest
type CreateCustomMetadataInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Do not set this field when using administrative
	// API actions, as in accessing the API using AWS credentials.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string"`

	// Custom metadata in the form of name-value pairs.
	//
	// CustomMetadata is a required field
	CustomMetadata map[string]string `min:"1" type:"map" required:"true"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" min:"1" type:"string" required:"true"`

	// The ID of the version, if the custom metadata is being added to a document
	// version.
	VersionId *string `location:"querystring" locationName:"versionid" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateCustomMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomMetadataInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateCustomMetadataInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AuthenticationToken", 1))
	}

	if s.CustomMetadata == nil {
		invalidParams.Add(aws.NewErrParamRequired("CustomMetadata"))
	}
	if s.CustomMetadata != nil && len(s.CustomMetadata) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CustomMetadata", 1))
	}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceId", 1))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateCustomMetadataInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if len(s.CustomMetadata) > 0 {
		v := s.CustomMetadata

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "CustomMetadata", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.AuthenticationToken != nil {
		v := *s.AuthenticationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Authentication", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceId != nil {
		v := *s.ResourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ResourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "versionid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateCustomMetadataResponse
type CreateCustomMetadataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateCustomMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateCustomMetadataOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opCreateCustomMetadata = "CreateCustomMetadata"

// CreateCustomMetadataRequest returns a request value for making API operation for
// Amazon WorkDocs.
//
// Adds one or more custom properties to the specified resource (a folder, document,
// or version).
//
//    // Example sending a request using CreateCustomMetadataRequest.
//    req := client.CreateCustomMetadataRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/CreateCustomMetadata
func (c *Client) CreateCustomMetadataRequest(input *CreateCustomMetadataInput) CreateCustomMetadataRequest {
	op := &aws.Operation{
		Name:       opCreateCustomMetadata,
		HTTPMethod: "PUT",
		HTTPPath:   "/api/v1/resources/{ResourceId}/customMetadata",
	}

	if input == nil {
		input = &CreateCustomMetadataInput{}
	}

	req := c.newRequest(op, input, &CreateCustomMetadataOutput{})
	return CreateCustomMetadataRequest{Request: req, Input: input, Copy: c.CreateCustomMetadataRequest}
}

// CreateCustomMetadataRequest is the request type for the
// CreateCustomMetadata API operation.
type CreateCustomMetadataRequest struct {
	*aws.Request
	Input *CreateCustomMetadataInput
	Copy  func(*CreateCustomMetadataInput) CreateCustomMetadataRequest
}

// Send marshals and sends the CreateCustomMetadata API request.
func (r CreateCustomMetadataRequest) Send(ctx context.Context) (*CreateCustomMetadataResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateCustomMetadataResponse{
		CreateCustomMetadataOutput: r.Request.Data.(*CreateCustomMetadataOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateCustomMetadataResponse is the response type for the
// CreateCustomMetadata API operation.
type CreateCustomMetadataResponse struct {
	*CreateCustomMetadataOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateCustomMetadata request.
func (r *CreateCustomMetadataResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
