// THIS FILE IS AUTOGENERATED USING go generate. DO NOT EDIT.
package iamutil

func GetEnabledIamResources() GeneratedResources {
	return generatedIamResources
}

var generatedIamResources = map[string]map[string]map[string]IamRestResource{
	"": {
		"iap": {
			"v1": IamRestResource{
				Name:                      "v1",
				TypeKey:                   "",
				Service:                   "iap",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://iap.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://iap.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": IamRestResource{
				Name:                      "v1beta1",
				TypeKey:                   "",
				Service:                   "iap",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://iap.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://iap.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"b": {
		"storage": {
			"v1": IamRestResource{
				Name:               "buckets",
				TypeKey:            "b",
				Service:            "storage",
				IsPreferredVersion: true,
				Parameters:         []string{"bucket"},
				CollectionReplacementKeys: map[string]string{
					"b":       "bucket",
					"buckets": "bucket",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/storage/v1/",
					Path:       "b/{bucket}/iam",
				},
				SetMethod: RestMethod{
					HttpMethod:    "PUT",
					BaseURL:       "https://www.googleapis.com/storage/v1/",
					Path:          "b/{bucket}/iam",
					RequestFormat: `%s`,
				},
			},
		},
	},
	"b/o": {
		"storage": {
			"v1": IamRestResource{
				Name:               "objects",
				TypeKey:            "b/o",
				Service:            "storage",
				IsPreferredVersion: true,
				Parameters:         []string{"bucket", "object"},
				CollectionReplacementKeys: map[string]string{
					"b":       "bucket",
					"buckets": "bucket",
					"o":       "object",
					"objects": "object",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/storage/v1/",
					Path:       "b/{bucket}/o/{object}/iam",
				},
				SetMethod: RestMethod{
					HttpMethod:    "PUT",
					BaseURL:       "https://www.googleapis.com/storage/v1/",
					Path:          "b/{bucket}/o/{object}/iam",
					RequestFormat: `%s`,
				},
			},
		},
	},
	"billingAccounts": {
		"cloudbilling": {
			"v1": IamRestResource{
				Name:                      "billingAccounts",
				TypeKey:                   "billingAccounts",
				Service:                   "cloudbilling",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudbilling.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudbilling.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"buckets": {
		"storage": {
			"v1": IamRestResource{
				Name:               "buckets",
				TypeKey:            "buckets",
				Service:            "storage",
				IsPreferredVersion: true,
				Parameters:         []string{"bucket"},
				CollectionReplacementKeys: map[string]string{
					"b":       "bucket",
					"buckets": "bucket",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/storage/v1/",
					Path:       "b/{bucket}/iam",
				},
				SetMethod: RestMethod{
					HttpMethod:    "PUT",
					BaseURL:       "https://www.googleapis.com/storage/v1/",
					Path:          "b/{bucket}/iam",
					RequestFormat: `%s`,
				},
			},
		},
	},
	"buckets/objects": {
		"storage": {
			"v1": IamRestResource{
				Name:               "objects",
				TypeKey:            "buckets/objects",
				Service:            "storage",
				IsPreferredVersion: true,
				Parameters:         []string{"bucket", "object"},
				CollectionReplacementKeys: map[string]string{
					"b":       "bucket",
					"buckets": "bucket",
					"o":       "object",
					"objects": "object",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/storage/v1/",
					Path:       "b/{bucket}/o/{object}/iam",
				},
				SetMethod: RestMethod{
					HttpMethod:    "PUT",
					BaseURL:       "https://www.googleapis.com/storage/v1/",
					Path:          "b/{bucket}/o/{object}/iam",
					RequestFormat: `%s`,
				},
			},
		},
	},
	"datasets": {
		"genomics": {
			"v1": IamRestResource{
				Name:                      "datasets",
				TypeKey:                   "datasets",
				Service:                   "genomics",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://genomics.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://genomics.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"folders": {
		"cloudresourcemanager": {
			"v2": IamRestResource{
				Name:                      "folders",
				TypeKey:                   "folders",
				Service:                   "cloudresourcemanager",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2beta1": IamRestResource{
				Name:                      "folders",
				TypeKey:                   "folders",
				Service:                   "cloudresourcemanager",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"organizations": {
		"cloudresourcemanager": {
			"v1": IamRestResource{
				Name:                      "organizations",
				TypeKey:                   "organizations",
				Service:                   "cloudresourcemanager",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": IamRestResource{
				Name:                      "organizations",
				TypeKey:                   "organizations",
				Service:                   "cloudresourcemanager",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects": {
		"cloudresourcemanager": {
			"v1": IamRestResource{
				Name:               "projects",
				TypeKey:            "projects",
				Service:            "cloudresourcemanager",
				IsPreferredVersion: false,
				Parameters:         []string{"resource"},
				CollectionReplacementKeys: map[string]string{
					"projects": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v1/projects/{resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v1/projects/{resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": IamRestResource{
				Name:               "projects",
				TypeKey:            "projects",
				Service:            "cloudresourcemanager",
				IsPreferredVersion: false,
				Parameters:         []string{"resource"},
				CollectionReplacementKeys: map[string]string{
					"projects": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v1beta1/projects/{resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v1beta1/projects/{resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/backendBuckets": {
		"compute": {
			"alpha": IamRestResource{
				Name:               "backendBuckets",
				TypeKey:            "projects/backendBuckets",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"backendBuckets": "resource",
					"projects":       "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/global/backendBuckets/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/global/backendBuckets/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/configs": {
		"runtimeconfig": {
			"v1beta1": IamRestResource{
				Name:                      "configs",
				TypeKey:                   "projects/configs",
				Service:                   "runtimeconfig",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://runtimeconfig.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://runtimeconfig.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/deployments": {
		"deploymentmanager": {
			"alpha": IamRestResource{
				Name:               "deployments",
				TypeKey:            "projects/deployments",
				Service:            "deploymentmanager",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"deployments": "resource",
					"projects":    "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/deploymentmanager/alpha/projects/",
					Path:       "{project}/global/deployments/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/deploymentmanager/alpha/projects/",
					Path:          "{project}/global/deployments/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2": IamRestResource{
				Name:               "deployments",
				TypeKey:            "projects/deployments",
				Service:            "deploymentmanager",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"deployments": "resource",
					"projects":    "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/deploymentmanager/v2/projects/",
					Path:       "{project}/global/deployments/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/deploymentmanager/v2/projects/",
					Path:          "{project}/global/deployments/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2beta": IamRestResource{
				Name:               "deployments",
				TypeKey:            "projects/deployments",
				Service:            "deploymentmanager",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"deployments": "resource",
					"projects":    "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/deploymentmanager/v2beta/projects/",
					Path:       "{project}/global/deployments/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/deploymentmanager/v2beta/projects/",
					Path:          "{project}/global/deployments/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/images": {
		"compute": {
			"alpha": IamRestResource{
				Name:               "images",
				TypeKey:            "projects/images",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"images":   "resource",
					"projects": "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/global/images/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/global/images/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": IamRestResource{
				Name:               "images",
				TypeKey:            "projects/images",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"images":   "resource",
					"projects": "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/beta/projects/",
					Path:       "{project}/global/images/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/beta/projects/",
					Path:          "{project}/global/images/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": IamRestResource{
				Name:               "images",
				TypeKey:            "projects/images",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"images":   "resource",
					"projects": "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/v1/projects/",
					Path:       "{project}/global/images/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/v1/projects/",
					Path:          "{project}/global/images/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instanceTemplates": {
		"compute": {
			"alpha": IamRestResource{
				Name:               "instanceTemplates",
				TypeKey:            "projects/instanceTemplates",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instanceTemplates": "resource",
					"projects":          "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/global/instanceTemplates/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/global/instanceTemplates/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": IamRestResource{
				Name:               "instanceTemplates",
				TypeKey:            "projects/instanceTemplates",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instanceTemplates": "resource",
					"projects":          "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/beta/projects/",
					Path:       "{project}/global/instanceTemplates/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/beta/projects/",
					Path:          "{project}/global/instanceTemplates/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": IamRestResource{
				Name:               "instanceTemplates",
				TypeKey:            "projects/instanceTemplates",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instanceTemplates": "resource",
					"projects":          "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/v1/projects/",
					Path:       "{project}/global/instanceTemplates/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/v1/projects/",
					Path:          "{project}/global/instanceTemplates/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instances": {
		"bigtableadmin": {
			"v2": IamRestResource{
				Name:                      "instances",
				TypeKey:                   "projects/instances",
				Service:                   "bigtableadmin",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://bigtableadmin.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://bigtableadmin.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
		"spanner": {
			"v1": IamRestResource{
				Name:                      "instances",
				TypeKey:                   "projects/instances",
				Service:                   "spanner",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://spanner.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://spanner.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instances/databases": {
		"spanner": {
			"v1": IamRestResource{
				Name:                      "databases",
				TypeKey:                   "projects/instances/databases",
				Service:                   "spanner",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://spanner.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://spanner.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/interconnects": {
		"compute": {
			"alpha": IamRestResource{
				Name:               "interconnects",
				TypeKey:            "projects/interconnects",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"interconnects": "resource",
					"projects":      "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/global/interconnects/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/global/interconnects/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/licenseCodes": {
		"compute": {
			"alpha": IamRestResource{
				Name:               "licenseCodes",
				TypeKey:            "projects/licenseCodes",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"licenseCodes": "resource",
					"projects":     "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/global/licenseCodes/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/global/licenseCodes/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/licenses": {
		"compute": {
			"alpha": IamRestResource{
				Name:               "licenses",
				TypeKey:            "projects/licenses",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"licenses": "resource",
					"projects": "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/global/licenses/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/global/licenses/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": IamRestResource{
				Name:               "licenses",
				TypeKey:            "projects/licenses",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"licenses": "resource",
					"projects": "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/beta/projects/",
					Path:       "{project}/global/licenses/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/beta/projects/",
					Path:          "{project}/global/licenses/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": IamRestResource{
				Name:               "licenses",
				TypeKey:            "projects/licenses",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"licenses": "resource",
					"projects": "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/v1/projects/",
					Path:       "{project}/global/licenses/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/v1/projects/",
					Path:          "{project}/global/licenses/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/autoscalingPolicies": {
		"dataproc": {
			"v1beta2": IamRestResource{
				Name:                      "autoscalingPolicies",
				TypeKey:                   "projects/locations/autoscalingPolicies",
				Service:                   "dataproc",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/datasets": {
		"healthcare": {
			"v1alpha": IamRestResource{
				Name:                      "datasets",
				TypeKey:                   "projects/locations/datasets",
				Service:                   "healthcare",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha2": IamRestResource{
				Name:                      "datasets",
				TypeKey:                   "projects/locations/datasets",
				Service:                   "healthcare",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1alpha2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1alpha2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/datasets/annotationStores": {
		"healthcare": {
			"v1alpha": IamRestResource{
				Name:                      "annotationStores",
				TypeKey:                   "projects/locations/datasets/annotationStores",
				Service:                   "healthcare",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha2": IamRestResource{
				Name:                      "annotationStores",
				TypeKey:                   "projects/locations/datasets/annotationStores",
				Service:                   "healthcare",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1alpha2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1alpha2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/datasets/dicomStores": {
		"healthcare": {
			"v1alpha": IamRestResource{
				Name:                      "dicomStores",
				TypeKey:                   "projects/locations/datasets/dicomStores",
				Service:                   "healthcare",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha2": IamRestResource{
				Name:                      "dicomStores",
				TypeKey:                   "projects/locations/datasets/dicomStores",
				Service:                   "healthcare",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1alpha2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1alpha2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/datasets/fhirStores": {
		"healthcare": {
			"v1alpha": IamRestResource{
				Name:                      "fhirStores",
				TypeKey:                   "projects/locations/datasets/fhirStores",
				Service:                   "healthcare",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha2": IamRestResource{
				Name:                      "fhirStores",
				TypeKey:                   "projects/locations/datasets/fhirStores",
				Service:                   "healthcare",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1alpha2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1alpha2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/datasets/fhirStores/securityLabels": {
		"healthcare": {
			"v1alpha": IamRestResource{
				Name:                      "securityLabels",
				TypeKey:                   "projects/locations/datasets/fhirStores/securityLabels",
				Service:                   "healthcare",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha2": IamRestResource{
				Name:                      "securityLabels",
				TypeKey:                   "projects/locations/datasets/fhirStores/securityLabels",
				Service:                   "healthcare",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1alpha2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1alpha2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/functions": {
		"cloudfunctions": {
			"v1": IamRestResource{
				Name:                      "functions",
				TypeKey:                   "projects/locations/functions",
				Service:                   "cloudfunctions",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudfunctions.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudfunctions.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/keyRings": {
		"cloudkms": {
			"v1": IamRestResource{
				Name:                      "keyRings",
				TypeKey:                   "projects/locations/keyRings",
				Service:                   "cloudkms",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudkms.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudkms.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/keyRings/cryptoKeys": {
		"cloudkms": {
			"v1": IamRestResource{
				Name:                      "cryptoKeys",
				TypeKey:                   "projects/locations/keyRings/cryptoKeys",
				Service:                   "cloudkms",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudkms.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudkms.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/keyRings/importJobs": {
		"cloudkms": {
			"v1": IamRestResource{
				Name:                      "importJobs",
				TypeKey:                   "projects/locations/keyRings/importJobs",
				Service:                   "cloudkms",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudkms.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudkms.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/queues": {
		"cloudtasks": {
			"v2beta2": IamRestResource{
				Name:                      "queues",
				TypeKey:                   "projects/locations/queues",
				Service:                   "cloudtasks",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudtasks.googleapis.com/",
					Path:       "v2beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudtasks.googleapis.com/",
					Path:          "v2beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2beta3": IamRestResource{
				Name:                      "queues",
				TypeKey:                   "projects/locations/queues",
				Service:                   "cloudtasks",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudtasks.googleapis.com/",
					Path:       "v2beta3/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudtasks.googleapis.com/",
					Path:          "v2beta3/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/registries": {
		"cloudiot": {
			"v1": IamRestResource{
				Name:                      "registries",
				TypeKey:                   "projects/locations/registries",
				Service:                   "cloudiot",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudiot.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudiot.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/registries/groups": {
		"cloudiot": {
			"v1": IamRestResource{
				Name:                      "groups",
				TypeKey:                   "projects/locations/registries/groups",
				Service:                   "cloudiot",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudiot.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudiot.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/workflowTemplates": {
		"dataproc": {
			"v1": IamRestResource{
				Name:                      "workflowTemplates",
				TypeKey:                   "projects/locations/workflowTemplates",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": IamRestResource{
				Name:                      "workflowTemplates",
				TypeKey:                   "projects/locations/workflowTemplates",
				Service:                   "dataproc",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/machineImages": {
		"compute": {
			"alpha": IamRestResource{
				Name:               "machineImages",
				TypeKey:            "projects/machineImages",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"machineImages": "resource",
					"projects":      "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/global/machineImages/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/global/machineImages/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/notes": {
		"containeranalysis": {
			"v1alpha1": IamRestResource{
				Name:                      "notes",
				TypeKey:                   "projects/notes",
				Service:                   "containeranalysis",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1alpha1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1alpha1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": IamRestResource{
				Name:                      "notes",
				TypeKey:                   "projects/notes",
				Service:                   "containeranalysis",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/occurrences": {
		"containeranalysis": {
			"v1alpha1": IamRestResource{
				Name:                      "occurrences",
				TypeKey:                   "projects/occurrences",
				Service:                   "containeranalysis",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1alpha1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1alpha1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": IamRestResource{
				Name:                      "occurrences",
				TypeKey:                   "projects/occurrences",
				Service:                   "containeranalysis",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/autoscalingPolicies": {
		"dataproc": {
			"v1beta2": IamRestResource{
				Name:                      "autoscalingPolicies",
				TypeKey:                   "projects/regions/autoscalingPolicies",
				Service:                   "dataproc",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/clusters": {
		"dataproc": {
			"v1": IamRestResource{
				Name:                      "clusters",
				TypeKey:                   "projects/regions/clusters",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": IamRestResource{
				Name:                      "clusters",
				TypeKey:                   "projects/regions/clusters",
				Service:                   "dataproc",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/disks": {
		"compute": {
			"alpha": IamRestResource{
				Name:               "regionDisks",
				TypeKey:            "projects/regions/disks",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"disks":    "resource",
					"projects": "project",
					"regions":  "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/regions/{region}/disks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/regions/{region}/disks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": IamRestResource{
				Name:               "regionDisks",
				TypeKey:            "projects/regions/disks",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"disks":    "resource",
					"projects": "project",
					"regions":  "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/beta/projects/",
					Path:       "{project}/regions/{region}/disks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/beta/projects/",
					Path:          "{project}/regions/{region}/disks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/interconnectAttachments": {
		"compute": {
			"alpha": IamRestResource{
				Name:               "interconnectAttachments",
				TypeKey:            "projects/regions/interconnectAttachments",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"interconnectAttachments": "resource",
					"projects":                "project",
					"regions":                 "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/regions/{region}/interconnectAttachments/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/regions/{region}/interconnectAttachments/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/jobs": {
		"dataproc": {
			"v1": IamRestResource{
				Name:                      "jobs",
				TypeKey:                   "projects/regions/jobs",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": IamRestResource{
				Name:                      "jobs",
				TypeKey:                   "projects/regions/jobs",
				Service:                   "dataproc",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/nodeTemplates": {
		"compute": {
			"alpha": IamRestResource{
				Name:               "nodeTemplates",
				TypeKey:            "projects/regions/nodeTemplates",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"nodeTemplates": "resource",
					"projects":      "project",
					"regions":       "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/regions/{region}/nodeTemplates/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/regions/{region}/nodeTemplates/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": IamRestResource{
				Name:               "nodeTemplates",
				TypeKey:            "projects/regions/nodeTemplates",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"nodeTemplates": "resource",
					"projects":      "project",
					"regions":       "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/beta/projects/",
					Path:       "{project}/regions/{region}/nodeTemplates/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/beta/projects/",
					Path:          "{project}/regions/{region}/nodeTemplates/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": IamRestResource{
				Name:               "nodeTemplates",
				TypeKey:            "projects/regions/nodeTemplates",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"nodeTemplates": "resource",
					"projects":      "project",
					"regions":       "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/v1/projects/",
					Path:       "{project}/regions/{region}/nodeTemplates/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/v1/projects/",
					Path:          "{project}/regions/{region}/nodeTemplates/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/operations": {
		"dataproc": {
			"v1": IamRestResource{
				Name:                      "operations",
				TypeKey:                   "projects/regions/operations",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": IamRestResource{
				Name:                      "operations",
				TypeKey:                   "projects/regions/operations",
				Service:                   "dataproc",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/resourcePolicies": {
		"compute": {
			"alpha": IamRestResource{
				Name:               "resourcePolicies",
				TypeKey:            "projects/regions/resourcePolicies",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":         "project",
					"regions":          "region",
					"resourcePolicies": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/regions/{region}/resourcePolicies/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/regions/{region}/resourcePolicies/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/subnetworks": {
		"compute": {
			"alpha": IamRestResource{
				Name:               "subnetworks",
				TypeKey:            "projects/regions/subnetworks",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":    "project",
					"regions":     "region",
					"subnetworks": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/regions/{region}/subnetworks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/regions/{region}/subnetworks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": IamRestResource{
				Name:               "subnetworks",
				TypeKey:            "projects/regions/subnetworks",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":    "project",
					"regions":     "region",
					"subnetworks": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/beta/projects/",
					Path:       "{project}/regions/{region}/subnetworks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/beta/projects/",
					Path:          "{project}/regions/{region}/subnetworks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": IamRestResource{
				Name:               "subnetworks",
				TypeKey:            "projects/regions/subnetworks",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":    "project",
					"regions":     "region",
					"subnetworks": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/v1/projects/",
					Path:       "{project}/regions/{region}/subnetworks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/v1/projects/",
					Path:          "{project}/regions/{region}/subnetworks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/workflowTemplates": {
		"dataproc": {
			"v1": IamRestResource{
				Name:                      "workflowTemplates",
				TypeKey:                   "projects/regions/workflowTemplates",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": IamRestResource{
				Name:                      "workflowTemplates",
				TypeKey:                   "projects/regions/workflowTemplates",
				Service:                   "dataproc",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/repos": {
		"sourcerepo": {
			"v1": IamRestResource{
				Name:                      "repos",
				TypeKey:                   "projects/repos",
				Service:                   "sourcerepo",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://sourcerepo.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://sourcerepo.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/serviceAccounts": {
		"iam": {
			"v1": IamRestResource{
				Name:                      "serviceAccounts",
				TypeKey:                   "projects/serviceAccounts",
				Service:                   "iam",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://iam.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://iam.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/snapshots": {
		"compute": {
			"alpha": IamRestResource{
				Name:               "snapshots",
				TypeKey:            "projects/snapshots",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":  "project",
					"snapshots": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/global/snapshots/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/global/snapshots/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": IamRestResource{
				Name:               "snapshots",
				TypeKey:            "projects/snapshots",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":  "project",
					"snapshots": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/beta/projects/",
					Path:       "{project}/global/snapshots/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/beta/projects/",
					Path:          "{project}/global/snapshots/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": IamRestResource{
				Name:               "snapshots",
				TypeKey:            "projects/snapshots",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":  "project",
					"snapshots": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/v1/projects/",
					Path:       "{project}/global/snapshots/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/v1/projects/",
					Path:          "{project}/global/snapshots/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
		"pubsub": {
			"v1": IamRestResource{
				Name:                      "snapshots",
				TypeKey:                   "projects/snapshots",
				Service:                   "pubsub",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://pubsub.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://pubsub.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/subscriptions": {
		"pubsub": {
			"v1": IamRestResource{
				Name:                      "subscriptions",
				TypeKey:                   "projects/subscriptions",
				Service:                   "pubsub",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://pubsub.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://pubsub.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": IamRestResource{
				Name:                      "subscriptions",
				TypeKey:                   "projects/subscriptions",
				Service:                   "pubsub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://pubsub.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://pubsub.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/topics": {
		"pubsub": {
			"v1": IamRestResource{
				Name:                      "topics",
				TypeKey:                   "projects/topics",
				Service:                   "pubsub",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://pubsub.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://pubsub.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": IamRestResource{
				Name:                      "topics",
				TypeKey:                   "projects/topics",
				Service:                   "pubsub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://pubsub.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://pubsub.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/zones/allocations": {
		"compute": {
			"alpha": IamRestResource{
				Name:               "allocations",
				TypeKey:            "projects/zones/allocations",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"allocations": "resource",
					"projects":    "project",
					"zones":       "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/zones/{zone}/allocations/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/zones/{zone}/allocations/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": IamRestResource{
				Name:               "allocations",
				TypeKey:            "projects/zones/allocations",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"allocations": "resource",
					"projects":    "project",
					"zones":       "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/beta/projects/",
					Path:       "{project}/zones/{zone}/allocations/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/beta/projects/",
					Path:          "{project}/zones/{zone}/allocations/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/zones/disks": {
		"compute": {
			"alpha": IamRestResource{
				Name:               "disks",
				TypeKey:            "projects/zones/disks",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"disks":    "resource",
					"projects": "project",
					"zones":    "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/zones/{zone}/disks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/zones/{zone}/disks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": IamRestResource{
				Name:               "disks",
				TypeKey:            "projects/zones/disks",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"disks":    "resource",
					"projects": "project",
					"zones":    "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/beta/projects/",
					Path:       "{project}/zones/{zone}/disks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/beta/projects/",
					Path:          "{project}/zones/{zone}/disks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": IamRestResource{
				Name:               "disks",
				TypeKey:            "projects/zones/disks",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"disks":    "resource",
					"projects": "project",
					"zones":    "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/v1/projects/",
					Path:       "{project}/zones/{zone}/disks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/v1/projects/",
					Path:          "{project}/zones/{zone}/disks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/zones/instances": {
		"compute": {
			"alpha": IamRestResource{
				Name:               "instances",
				TypeKey:            "projects/zones/instances",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instances": "resource",
					"projects":  "project",
					"zones":     "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/zones/{zone}/instances/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/zones/{zone}/instances/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": IamRestResource{
				Name:               "instances",
				TypeKey:            "projects/zones/instances",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instances": "resource",
					"projects":  "project",
					"zones":     "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/beta/projects/",
					Path:       "{project}/zones/{zone}/instances/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/beta/projects/",
					Path:          "{project}/zones/{zone}/instances/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": IamRestResource{
				Name:               "instances",
				TypeKey:            "projects/zones/instances",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instances": "resource",
					"projects":  "project",
					"zones":     "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/v1/projects/",
					Path:       "{project}/zones/{zone}/instances/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/v1/projects/",
					Path:          "{project}/zones/{zone}/instances/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/zones/nodeGroups": {
		"compute": {
			"alpha": IamRestResource{
				Name:               "nodeGroups",
				TypeKey:            "projects/zones/nodeGroups",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"nodeGroups": "resource",
					"projects":   "project",
					"zones":      "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/alpha/projects/",
					Path:       "{project}/zones/{zone}/nodeGroups/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/alpha/projects/",
					Path:          "{project}/zones/{zone}/nodeGroups/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": IamRestResource{
				Name:               "nodeGroups",
				TypeKey:            "projects/zones/nodeGroups",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"nodeGroups": "resource",
					"projects":   "project",
					"zones":      "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/beta/projects/",
					Path:       "{project}/zones/{zone}/nodeGroups/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/beta/projects/",
					Path:          "{project}/zones/{zone}/nodeGroups/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": IamRestResource{
				Name:               "nodeGroups",
				TypeKey:            "projects/zones/nodeGroups",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"nodeGroups": "resource",
					"projects":   "project",
					"zones":      "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://www.googleapis.com/compute/v1/projects/",
					Path:       "{project}/zones/{zone}/nodeGroups/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://www.googleapis.com/compute/v1/projects/",
					Path:          "{project}/zones/{zone}/nodeGroups/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"providers/notes": {
		"containeranalysis": {
			"v1alpha1": IamRestResource{
				Name:                      "notes",
				TypeKey:                   "providers/notes",
				Service:                   "containeranalysis",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1alpha1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1alpha1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"services": {
		"servicemanagement": {
			"v1": IamRestResource{
				Name:                      "services",
				TypeKey:                   "services",
				Service:                   "servicemanagement",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://servicemanagement.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://servicemanagement.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"services/consumers": {
		"servicemanagement": {
			"v1": IamRestResource{
				Name:                      "consumers",
				TypeKey:                   "services/consumers",
				Service:                   "servicemanagement",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://servicemanagement.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://servicemanagement.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
}
