// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dataproc/v1beta2/autoscaling_policies.proto

package dataproc

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Describes an autoscaling policy for Dataproc cluster autoscaler.
type AutoscalingPolicy struct {
	// Required. The policy id.
	//
	// The id must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). Cannot begin or end with underscore
	// or hyphen. Must consist of between 3 and 50 characters.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. The "resource name" of the autoscaling policy, as described
	// in https://cloud.google.com/apis/design/resource_names.
	//
	// * For `projects.regions.autoscalingPolicies`, the resource name of the
	//   policy has the following format:
	//   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
	//
	// * For `projects.locations.autoscalingPolicies`, the resource name of the
	//   policy has the following format:
	//   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Autoscaling algorithm for policy.
	//
	// Types that are valid to be assigned to Algorithm:
	//	*AutoscalingPolicy_BasicAlgorithm
	Algorithm isAutoscalingPolicy_Algorithm `protobuf_oneof:"algorithm"`
	// Required. Describes how the autoscaler will operate for primary workers.
	WorkerConfig *InstanceGroupAutoscalingPolicyConfig `protobuf:"bytes,4,opt,name=worker_config,json=workerConfig,proto3" json:"worker_config,omitempty"`
	// Optional. Describes how the autoscaler will operate for secondary workers.
	SecondaryWorkerConfig *InstanceGroupAutoscalingPolicyConfig `protobuf:"bytes,5,opt,name=secondary_worker_config,json=secondaryWorkerConfig,proto3" json:"secondary_worker_config,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}                              `json:"-"`
	XXX_unrecognized      []byte                                `json:"-"`
	XXX_sizecache         int32                                 `json:"-"`
}

func (m *AutoscalingPolicy) Reset()         { *m = AutoscalingPolicy{} }
func (m *AutoscalingPolicy) String() string { return proto.CompactTextString(m) }
func (*AutoscalingPolicy) ProtoMessage()    {}
func (*AutoscalingPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_913da8702c1b2ed6, []int{0}
}

func (m *AutoscalingPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AutoscalingPolicy.Unmarshal(m, b)
}
func (m *AutoscalingPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AutoscalingPolicy.Marshal(b, m, deterministic)
}
func (m *AutoscalingPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AutoscalingPolicy.Merge(m, src)
}
func (m *AutoscalingPolicy) XXX_Size() int {
	return xxx_messageInfo_AutoscalingPolicy.Size(m)
}
func (m *AutoscalingPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_AutoscalingPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_AutoscalingPolicy proto.InternalMessageInfo

func (m *AutoscalingPolicy) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *AutoscalingPolicy) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type isAutoscalingPolicy_Algorithm interface {
	isAutoscalingPolicy_Algorithm()
}

type AutoscalingPolicy_BasicAlgorithm struct {
	BasicAlgorithm *BasicAutoscalingAlgorithm `protobuf:"bytes,3,opt,name=basic_algorithm,json=basicAlgorithm,proto3,oneof"`
}

func (*AutoscalingPolicy_BasicAlgorithm) isAutoscalingPolicy_Algorithm() {}

func (m *AutoscalingPolicy) GetAlgorithm() isAutoscalingPolicy_Algorithm {
	if m != nil {
		return m.Algorithm
	}
	return nil
}

func (m *AutoscalingPolicy) GetBasicAlgorithm() *BasicAutoscalingAlgorithm {
	if x, ok := m.GetAlgorithm().(*AutoscalingPolicy_BasicAlgorithm); ok {
		return x.BasicAlgorithm
	}
	return nil
}

func (m *AutoscalingPolicy) GetWorkerConfig() *InstanceGroupAutoscalingPolicyConfig {
	if m != nil {
		return m.WorkerConfig
	}
	return nil
}

func (m *AutoscalingPolicy) GetSecondaryWorkerConfig() *InstanceGroupAutoscalingPolicyConfig {
	if m != nil {
		return m.SecondaryWorkerConfig
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AutoscalingPolicy) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AutoscalingPolicy_BasicAlgorithm)(nil),
	}
}

// Basic algorithm for autoscaling.
type BasicAutoscalingAlgorithm struct {
	// Required. YARN autoscaling configuration.
	YarnConfig *BasicYarnAutoscalingConfig `protobuf:"bytes,1,opt,name=yarn_config,json=yarnConfig,proto3" json:"yarn_config,omitempty"`
	// Optional. Duration between scaling events. A scaling period starts after
	// the update operation from the previous event has completed.
	//
	// Bounds: [2m, 1d]. Default: 2m.
	CooldownPeriod       *duration.Duration `protobuf:"bytes,2,opt,name=cooldown_period,json=cooldownPeriod,proto3" json:"cooldown_period,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *BasicAutoscalingAlgorithm) Reset()         { *m = BasicAutoscalingAlgorithm{} }
func (m *BasicAutoscalingAlgorithm) String() string { return proto.CompactTextString(m) }
func (*BasicAutoscalingAlgorithm) ProtoMessage()    {}
func (*BasicAutoscalingAlgorithm) Descriptor() ([]byte, []int) {
	return fileDescriptor_913da8702c1b2ed6, []int{1}
}

func (m *BasicAutoscalingAlgorithm) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BasicAutoscalingAlgorithm.Unmarshal(m, b)
}
func (m *BasicAutoscalingAlgorithm) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BasicAutoscalingAlgorithm.Marshal(b, m, deterministic)
}
func (m *BasicAutoscalingAlgorithm) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BasicAutoscalingAlgorithm.Merge(m, src)
}
func (m *BasicAutoscalingAlgorithm) XXX_Size() int {
	return xxx_messageInfo_BasicAutoscalingAlgorithm.Size(m)
}
func (m *BasicAutoscalingAlgorithm) XXX_DiscardUnknown() {
	xxx_messageInfo_BasicAutoscalingAlgorithm.DiscardUnknown(m)
}

var xxx_messageInfo_BasicAutoscalingAlgorithm proto.InternalMessageInfo

func (m *BasicAutoscalingAlgorithm) GetYarnConfig() *BasicYarnAutoscalingConfig {
	if m != nil {
		return m.YarnConfig
	}
	return nil
}

func (m *BasicAutoscalingAlgorithm) GetCooldownPeriod() *duration.Duration {
	if m != nil {
		return m.CooldownPeriod
	}
	return nil
}

// Basic autoscaling configurations for YARN.
type BasicYarnAutoscalingConfig struct {
	// Required. Timeout for YARN graceful decommissioning of Node Managers.
	// Specifies the duration to wait for jobs to complete before forcefully
	// removing workers (and potentially interrupting jobs). Only applicable to
	// downscaling operations.
	//
	// Bounds: [0s, 1d].
	GracefulDecommissionTimeout *duration.Duration `protobuf:"bytes,5,opt,name=graceful_decommission_timeout,json=gracefulDecommissionTimeout,proto3" json:"graceful_decommission_timeout,omitempty"`
	// Required. Fraction of average pending memory in the last cooldown period
	// for which to add workers. A scale-up factor of 1.0 will result in scaling
	// up so that there is no pending memory remaining after the update (more
	// aggressive scaling). A scale-up factor closer to 0 will result in a smaller
	// magnitude of scaling up (less aggressive scaling).
	//
	// Bounds: [0.0, 1.0].
	ScaleUpFactor float64 `protobuf:"fixed64,1,opt,name=scale_up_factor,json=scaleUpFactor,proto3" json:"scale_up_factor,omitempty"`
	// Required. Fraction of average pending memory in the last cooldown period
	// for which to remove workers. A scale-down factor of 1 will result in
	// scaling down so that there is no available memory remaining after the
	// update (more aggressive scaling). A scale-down factor of 0 disables
	// removing workers, which can be beneficial for autoscaling a single job.
	//
	// Bounds: [0.0, 1.0].
	ScaleDownFactor float64 `protobuf:"fixed64,2,opt,name=scale_down_factor,json=scaleDownFactor,proto3" json:"scale_down_factor,omitempty"`
	// Optional. Minimum scale-up threshold as a fraction of total cluster size
	// before scaling occurs. For example, in a 20-worker cluster, a threshold of
	// 0.1 means the autoscaler must recommend at least a 2-worker scale-up for
	// the cluster to scale. A threshold of 0 means the autoscaler will scale up
	// on any recommended change.
	//
	// Bounds: [0.0, 1.0]. Default: 0.0.
	ScaleUpMinWorkerFraction float64 `protobuf:"fixed64,3,opt,name=scale_up_min_worker_fraction,json=scaleUpMinWorkerFraction,proto3" json:"scale_up_min_worker_fraction,omitempty"`
	// Optional. Minimum scale-down threshold as a fraction of total cluster size
	// before scaling occurs. For example, in a 20-worker cluster, a threshold of
	// 0.1 means the autoscaler must recommend at least a 2 worker scale-down for
	// the cluster to scale. A threshold of 0 means the autoscaler will scale down
	// on any recommended change.
	//
	// Bounds: [0.0, 1.0]. Default: 0.0.
	ScaleDownMinWorkerFraction float64  `protobuf:"fixed64,4,opt,name=scale_down_min_worker_fraction,json=scaleDownMinWorkerFraction,proto3" json:"scale_down_min_worker_fraction,omitempty"`
	XXX_NoUnkeyedLiteral       struct{} `json:"-"`
	XXX_unrecognized           []byte   `json:"-"`
	XXX_sizecache              int32    `json:"-"`
}

func (m *BasicYarnAutoscalingConfig) Reset()         { *m = BasicYarnAutoscalingConfig{} }
func (m *BasicYarnAutoscalingConfig) String() string { return proto.CompactTextString(m) }
func (*BasicYarnAutoscalingConfig) ProtoMessage()    {}
func (*BasicYarnAutoscalingConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_913da8702c1b2ed6, []int{2}
}

func (m *BasicYarnAutoscalingConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BasicYarnAutoscalingConfig.Unmarshal(m, b)
}
func (m *BasicYarnAutoscalingConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BasicYarnAutoscalingConfig.Marshal(b, m, deterministic)
}
func (m *BasicYarnAutoscalingConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BasicYarnAutoscalingConfig.Merge(m, src)
}
func (m *BasicYarnAutoscalingConfig) XXX_Size() int {
	return xxx_messageInfo_BasicYarnAutoscalingConfig.Size(m)
}
func (m *BasicYarnAutoscalingConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_BasicYarnAutoscalingConfig.DiscardUnknown(m)
}

var xxx_messageInfo_BasicYarnAutoscalingConfig proto.InternalMessageInfo

func (m *BasicYarnAutoscalingConfig) GetGracefulDecommissionTimeout() *duration.Duration {
	if m != nil {
		return m.GracefulDecommissionTimeout
	}
	return nil
}

func (m *BasicYarnAutoscalingConfig) GetScaleUpFactor() float64 {
	if m != nil {
		return m.ScaleUpFactor
	}
	return 0
}

func (m *BasicYarnAutoscalingConfig) GetScaleDownFactor() float64 {
	if m != nil {
		return m.ScaleDownFactor
	}
	return 0
}

func (m *BasicYarnAutoscalingConfig) GetScaleUpMinWorkerFraction() float64 {
	if m != nil {
		return m.ScaleUpMinWorkerFraction
	}
	return 0
}

func (m *BasicYarnAutoscalingConfig) GetScaleDownMinWorkerFraction() float64 {
	if m != nil {
		return m.ScaleDownMinWorkerFraction
	}
	return 0
}

// Configuration for the size bounds of an instance group, including its
// proportional size to other groups.
type InstanceGroupAutoscalingPolicyConfig struct {
	// Optional. Minimum number of instances for this group.
	//
	// Primary workers - Bounds: [2, max_instances]. Default: 2.
	// Secondary workers - Bounds: [0, max_instances]. Default: 0.
	MinInstances int32 `protobuf:"varint,1,opt,name=min_instances,json=minInstances,proto3" json:"min_instances,omitempty"`
	// Optional. Maximum number of instances for this group. Required for primary
	// workers. Note that by default, clusters will not use secondary workers.
	// Required for secondary workers if the minimum secondary instances is set.
	//
	// Primary workers - Bounds: [min_instances, ). Required.
	// Secondary workers - Bounds: [min_instances, ). Default: 0.
	MaxInstances int32 `protobuf:"varint,2,opt,name=max_instances,json=maxInstances,proto3" json:"max_instances,omitempty"`
	// Optional. Weight for the instance group, which is used to determine the
	// fraction of total workers in the cluster from this instance group.
	// For example, if primary workers have weight 2, and secondary workers have
	// weight 1, the cluster will have approximately 2 primary workers for each
	// secondary worker.
	//
	// The cluster may not reach the specified balance if constrained
	// by min/max bounds or other autoscaling settings. For example, if
	// `max_instances` for secondary workers is 0, then only primary workers will
	// be added. The cluster can also be out of balance when created.
	//
	// If weight is not set on any instance group, the cluster will default to
	// equal weight for all groups: the cluster will attempt to maintain an equal
	// number of workers in each group within the configured size bounds for each
	// group. If weight is set for one group only, the cluster will default to
	// zero weight on the unset group. For example if weight is set only on
	// primary workers, the cluster will use primary workers only and no
	// secondary workers.
	Weight               int32    `protobuf:"varint,3,opt,name=weight,proto3" json:"weight,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InstanceGroupAutoscalingPolicyConfig) Reset()         { *m = InstanceGroupAutoscalingPolicyConfig{} }
func (m *InstanceGroupAutoscalingPolicyConfig) String() string { return proto.CompactTextString(m) }
func (*InstanceGroupAutoscalingPolicyConfig) ProtoMessage()    {}
func (*InstanceGroupAutoscalingPolicyConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_913da8702c1b2ed6, []int{3}
}

func (m *InstanceGroupAutoscalingPolicyConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstanceGroupAutoscalingPolicyConfig.Unmarshal(m, b)
}
func (m *InstanceGroupAutoscalingPolicyConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstanceGroupAutoscalingPolicyConfig.Marshal(b, m, deterministic)
}
func (m *InstanceGroupAutoscalingPolicyConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceGroupAutoscalingPolicyConfig.Merge(m, src)
}
func (m *InstanceGroupAutoscalingPolicyConfig) XXX_Size() int {
	return xxx_messageInfo_InstanceGroupAutoscalingPolicyConfig.Size(m)
}
func (m *InstanceGroupAutoscalingPolicyConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceGroupAutoscalingPolicyConfig.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceGroupAutoscalingPolicyConfig proto.InternalMessageInfo

func (m *InstanceGroupAutoscalingPolicyConfig) GetMinInstances() int32 {
	if m != nil {
		return m.MinInstances
	}
	return 0
}

func (m *InstanceGroupAutoscalingPolicyConfig) GetMaxInstances() int32 {
	if m != nil {
		return m.MaxInstances
	}
	return 0
}

func (m *InstanceGroupAutoscalingPolicyConfig) GetWeight() int32 {
	if m != nil {
		return m.Weight
	}
	return 0
}

// A request to create an autoscaling policy.
type CreateAutoscalingPolicyRequest struct {
	// Required. The "resource name" of the region or location, as described
	// in https://cloud.google.com/apis/design/resource_names.
	//
	// * For `projects.regions.autoscalingPolicies.create`, the resource name
	//   has the following format:
	//   `projects/{project_id}/regions/{region}`
	//
	// * For `projects.locations.autoscalingPolicies.create`, the resource name
	//   has the following format:
	//   `projects/{project_id}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The autoscaling policy to create.
	Policy               *AutoscalingPolicy `protobuf:"bytes,2,opt,name=policy,proto3" json:"policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *CreateAutoscalingPolicyRequest) Reset()         { *m = CreateAutoscalingPolicyRequest{} }
func (m *CreateAutoscalingPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateAutoscalingPolicyRequest) ProtoMessage()    {}
func (*CreateAutoscalingPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_913da8702c1b2ed6, []int{4}
}

func (m *CreateAutoscalingPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateAutoscalingPolicyRequest.Unmarshal(m, b)
}
func (m *CreateAutoscalingPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateAutoscalingPolicyRequest.Marshal(b, m, deterministic)
}
func (m *CreateAutoscalingPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateAutoscalingPolicyRequest.Merge(m, src)
}
func (m *CreateAutoscalingPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateAutoscalingPolicyRequest.Size(m)
}
func (m *CreateAutoscalingPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateAutoscalingPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateAutoscalingPolicyRequest proto.InternalMessageInfo

func (m *CreateAutoscalingPolicyRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateAutoscalingPolicyRequest) GetPolicy() *AutoscalingPolicy {
	if m != nil {
		return m.Policy
	}
	return nil
}

// A request to fetch an autoscaling policy.
type GetAutoscalingPolicyRequest struct {
	// Required. The "resource name" of the autoscaling policy, as described
	// in https://cloud.google.com/apis/design/resource_names.
	//
	// * For `projects.regions.autoscalingPolicies.get`, the resource name
	//   of the policy has the following format:
	//   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
	//
	// * For `projects.locations.autoscalingPolicies.get`, the resource name
	//   of the policy has the following format:
	//   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAutoscalingPolicyRequest) Reset()         { *m = GetAutoscalingPolicyRequest{} }
func (m *GetAutoscalingPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*GetAutoscalingPolicyRequest) ProtoMessage()    {}
func (*GetAutoscalingPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_913da8702c1b2ed6, []int{5}
}

func (m *GetAutoscalingPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAutoscalingPolicyRequest.Unmarshal(m, b)
}
func (m *GetAutoscalingPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAutoscalingPolicyRequest.Marshal(b, m, deterministic)
}
func (m *GetAutoscalingPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAutoscalingPolicyRequest.Merge(m, src)
}
func (m *GetAutoscalingPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_GetAutoscalingPolicyRequest.Size(m)
}
func (m *GetAutoscalingPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAutoscalingPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAutoscalingPolicyRequest proto.InternalMessageInfo

func (m *GetAutoscalingPolicyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to update an autoscaling policy.
type UpdateAutoscalingPolicyRequest struct {
	// Required. The updated autoscaling policy.
	Policy               *AutoscalingPolicy `protobuf:"bytes,1,opt,name=policy,proto3" json:"policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *UpdateAutoscalingPolicyRequest) Reset()         { *m = UpdateAutoscalingPolicyRequest{} }
func (m *UpdateAutoscalingPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateAutoscalingPolicyRequest) ProtoMessage()    {}
func (*UpdateAutoscalingPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_913da8702c1b2ed6, []int{6}
}

func (m *UpdateAutoscalingPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateAutoscalingPolicyRequest.Unmarshal(m, b)
}
func (m *UpdateAutoscalingPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateAutoscalingPolicyRequest.Marshal(b, m, deterministic)
}
func (m *UpdateAutoscalingPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateAutoscalingPolicyRequest.Merge(m, src)
}
func (m *UpdateAutoscalingPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateAutoscalingPolicyRequest.Size(m)
}
func (m *UpdateAutoscalingPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateAutoscalingPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateAutoscalingPolicyRequest proto.InternalMessageInfo

func (m *UpdateAutoscalingPolicyRequest) GetPolicy() *AutoscalingPolicy {
	if m != nil {
		return m.Policy
	}
	return nil
}

// A request to delete an autoscaling policy.
//
// Autoscaling policies in use by one or more clusters will not be deleted.
type DeleteAutoscalingPolicyRequest struct {
	// Required. The "resource name" of the autoscaling policy, as described
	// in https://cloud.google.com/apis/design/resource_names.
	//
	// * For `projects.regions.autoscalingPolicies.delete`, the resource name
	//   of the policy has the following format:
	//   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
	//
	// * For `projects.locations.autoscalingPolicies.delete`, the resource name
	//   of the policy has the following format:
	//   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAutoscalingPolicyRequest) Reset()         { *m = DeleteAutoscalingPolicyRequest{} }
func (m *DeleteAutoscalingPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAutoscalingPolicyRequest) ProtoMessage()    {}
func (*DeleteAutoscalingPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_913da8702c1b2ed6, []int{7}
}

func (m *DeleteAutoscalingPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAutoscalingPolicyRequest.Unmarshal(m, b)
}
func (m *DeleteAutoscalingPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAutoscalingPolicyRequest.Marshal(b, m, deterministic)
}
func (m *DeleteAutoscalingPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAutoscalingPolicyRequest.Merge(m, src)
}
func (m *DeleteAutoscalingPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteAutoscalingPolicyRequest.Size(m)
}
func (m *DeleteAutoscalingPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAutoscalingPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAutoscalingPolicyRequest proto.InternalMessageInfo

func (m *DeleteAutoscalingPolicyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to list autoscaling policies in a project.
type ListAutoscalingPoliciesRequest struct {
	// Required. The "resource name" of the region or location, as described
	// in https://cloud.google.com/apis/design/resource_names.
	//
	// * For `projects.regions.autoscalingPolicies.list`, the resource name
	//   of the region has the following format:
	//   `projects/{project_id}/regions/{region}`
	//
	// * For `projects.locations.autoscalingPolicies.list`, the resource name
	//   of the location has the following format:
	//   `projects/{project_id}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of results to return in each response.
	// Must be less than or equal to 1000. Defaults to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The page token, returned by a previous call, to request the
	// next page of results.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAutoscalingPoliciesRequest) Reset()         { *m = ListAutoscalingPoliciesRequest{} }
func (m *ListAutoscalingPoliciesRequest) String() string { return proto.CompactTextString(m) }
func (*ListAutoscalingPoliciesRequest) ProtoMessage()    {}
func (*ListAutoscalingPoliciesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_913da8702c1b2ed6, []int{8}
}

func (m *ListAutoscalingPoliciesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAutoscalingPoliciesRequest.Unmarshal(m, b)
}
func (m *ListAutoscalingPoliciesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAutoscalingPoliciesRequest.Marshal(b, m, deterministic)
}
func (m *ListAutoscalingPoliciesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAutoscalingPoliciesRequest.Merge(m, src)
}
func (m *ListAutoscalingPoliciesRequest) XXX_Size() int {
	return xxx_messageInfo_ListAutoscalingPoliciesRequest.Size(m)
}
func (m *ListAutoscalingPoliciesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAutoscalingPoliciesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAutoscalingPoliciesRequest proto.InternalMessageInfo

func (m *ListAutoscalingPoliciesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListAutoscalingPoliciesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListAutoscalingPoliciesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// A response to a request to list autoscaling policies in a project.
type ListAutoscalingPoliciesResponse struct {
	// Output only. Autoscaling policies list.
	Policies []*AutoscalingPolicy `protobuf:"bytes,1,rep,name=policies,proto3" json:"policies,omitempty"`
	// Output only. This token is included in the response if there are more
	// results to fetch.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAutoscalingPoliciesResponse) Reset()         { *m = ListAutoscalingPoliciesResponse{} }
func (m *ListAutoscalingPoliciesResponse) String() string { return proto.CompactTextString(m) }
func (*ListAutoscalingPoliciesResponse) ProtoMessage()    {}
func (*ListAutoscalingPoliciesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_913da8702c1b2ed6, []int{9}
}

func (m *ListAutoscalingPoliciesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAutoscalingPoliciesResponse.Unmarshal(m, b)
}
func (m *ListAutoscalingPoliciesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAutoscalingPoliciesResponse.Marshal(b, m, deterministic)
}
func (m *ListAutoscalingPoliciesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAutoscalingPoliciesResponse.Merge(m, src)
}
func (m *ListAutoscalingPoliciesResponse) XXX_Size() int {
	return xxx_messageInfo_ListAutoscalingPoliciesResponse.Size(m)
}
func (m *ListAutoscalingPoliciesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAutoscalingPoliciesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAutoscalingPoliciesResponse proto.InternalMessageInfo

func (m *ListAutoscalingPoliciesResponse) GetPolicies() []*AutoscalingPolicy {
	if m != nil {
		return m.Policies
	}
	return nil
}

func (m *ListAutoscalingPoliciesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*AutoscalingPolicy)(nil), "google.cloud.dataproc.v1beta2.AutoscalingPolicy")
	proto.RegisterType((*BasicAutoscalingAlgorithm)(nil), "google.cloud.dataproc.v1beta2.BasicAutoscalingAlgorithm")
	proto.RegisterType((*BasicYarnAutoscalingConfig)(nil), "google.cloud.dataproc.v1beta2.BasicYarnAutoscalingConfig")
	proto.RegisterType((*InstanceGroupAutoscalingPolicyConfig)(nil), "google.cloud.dataproc.v1beta2.InstanceGroupAutoscalingPolicyConfig")
	proto.RegisterType((*CreateAutoscalingPolicyRequest)(nil), "google.cloud.dataproc.v1beta2.CreateAutoscalingPolicyRequest")
	proto.RegisterType((*GetAutoscalingPolicyRequest)(nil), "google.cloud.dataproc.v1beta2.GetAutoscalingPolicyRequest")
	proto.RegisterType((*UpdateAutoscalingPolicyRequest)(nil), "google.cloud.dataproc.v1beta2.UpdateAutoscalingPolicyRequest")
	proto.RegisterType((*DeleteAutoscalingPolicyRequest)(nil), "google.cloud.dataproc.v1beta2.DeleteAutoscalingPolicyRequest")
	proto.RegisterType((*ListAutoscalingPoliciesRequest)(nil), "google.cloud.dataproc.v1beta2.ListAutoscalingPoliciesRequest")
	proto.RegisterType((*ListAutoscalingPoliciesResponse)(nil), "google.cloud.dataproc.v1beta2.ListAutoscalingPoliciesResponse")
}

func init() {
	proto.RegisterFile("google/cloud/dataproc/v1beta2/autoscaling_policies.proto", fileDescriptor_913da8702c1b2ed6)
}

var fileDescriptor_913da8702c1b2ed6 = []byte{
	// 1237 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0xcf, 0x6f, 0xdc, 0x44,
	0x14, 0x66, 0x9c, 0x34, 0x6a, 0x26, 0x4d, 0xab, 0x0e, 0x3f, 0x76, 0xbb, 0x69, 0xd3, 0x60, 0x71,
	0x28, 0x29, 0xac, 0x69, 0xb8, 0x94, 0xd0, 0x22, 0x39, 0x49, 0x1b, 0xaa, 0xb6, 0xd2, 0xb2, 0x6d,
	0x85, 0xe8, 0xc5, 0x9a, 0xb5, 0x67, 0x9d, 0xa1, 0xb6, 0xc7, 0x8c, 0x67, 0xbb, 0x4d, 0x97, 0x48,
	0x88, 0x03, 0x12, 0x02, 0x09, 0x24, 0x0e, 0x48, 0x48, 0x1c, 0x10, 0x12, 0x07, 0x4e, 0x70, 0x42,
	0xe2, 0xce, 0x05, 0x89, 0x03, 0x70, 0xeb, 0xa9, 0x07, 0x4e, 0x88, 0x7f, 0x00, 0xc4, 0x01, 0x79,
	0x66, 0xec, 0xb8, 0xdd, 0xb5, 0x37, 0xd9, 0x96, 0x9b, 0x33, 0xef, 0xbd, 0xef, 0xbd, 0xf7, 0xcd,
	0xf7, 0x66, 0x66, 0x03, 0xcf, 0xfa, 0x8c, 0xf9, 0x01, 0xb1, 0xdc, 0x80, 0xf5, 0x3c, 0xcb, 0xc3,
	0x02, 0xc7, 0x9c, 0xb9, 0xd6, 0xed, 0x33, 0x1d, 0x22, 0xf0, 0x8a, 0x85, 0x7b, 0x82, 0x25, 0x2e,
	0x0e, 0x68, 0xe4, 0x3b, 0x31, 0x0b, 0xa8, 0x4b, 0x49, 0xd2, 0x8c, 0x39, 0x13, 0x0c, 0x9d, 0x50,
	0x91, 0x4d, 0x19, 0xd9, 0xcc, 0x22, 0x9b, 0x3a, 0xb2, 0x71, 0x5c, 0x03, 0xe3, 0x98, 0x5a, 0x38,
	0x8a, 0x98, 0xc0, 0x82, 0xb2, 0x48, 0x07, 0x37, 0x6a, 0x05, 0xab, 0x1b, 0x50, 0x12, 0x09, 0x6d,
	0x38, 0x59, 0x30, 0x74, 0x29, 0x09, 0x3c, 0xa7, 0x43, 0xb6, 0xf0, 0x6d, 0xca, 0xb8, 0x76, 0x38,
	0x56, 0x70, 0xe0, 0x24, 0x61, 0x3d, 0xee, 0x12, 0x6d, 0x5a, 0xd4, 0x26, 0xf9, 0x57, 0xa7, 0xd7,
	0xb5, 0xbc, 0x1e, 0x97, 0x59, 0xb5, 0x7d, 0xe1, 0x61, 0x3b, 0x09, 0x63, 0xb1, 0xad, 0x8c, 0xe6,
	0xdf, 0xd3, 0xf0, 0xa8, 0xbd, 0xdb, 0x6d, 0x2b, 0x6d, 0x76, 0x1b, 0x3d, 0x09, 0x0d, 0xea, 0xd5,
	0xc1, 0x12, 0x38, 0x35, 0xbb, 0x36, 0x75, 0xdf, 0x36, 0xda, 0x06, 0xf5, 0x50, 0x0d, 0x4e, 0x47,
	0x38, 0x24, 0x75, 0x23, 0x5b, 0x9e, 0x6a, 0xcb, 0x05, 0xe4, 0xc2, 0x23, 0x1d, 0x9c, 0x50, 0xd7,
	0xc1, 0x81, 0xcf, 0x38, 0x15, 0x5b, 0x61, 0x7d, 0x6a, 0x09, 0x9c, 0x9a, 0x5b, 0x39, 0xdb, 0xac,
	0x24, 0xab, 0xb9, 0x96, 0x46, 0x15, 0xb2, 0xdb, 0x59, 0xfc, 0xeb, 0x4f, 0xb4, 0x0f, 0x4b, 0xc8,
	0x7c, 0x05, 0x85, 0x70, 0xbe, 0xcf, 0xf8, 0x2d, 0xc2, 0x1d, 0x97, 0x45, 0x5d, 0xea, 0xd7, 0xa7,
	0x65, 0x8a, 0xf5, 0x31, 0x29, 0x2e, 0x45, 0x89, 0xc0, 0x91, 0x4b, 0x36, 0x39, 0xeb, 0xc5, 0x43,
	0x8d, 0xae, 0x4b, 0x28, 0xd5, 0xe2, 0x21, 0x05, 0xaf, 0x96, 0xd0, 0x7b, 0x00, 0xd6, 0x12, 0xe2,
	0xb2, 0xc8, 0xc3, 0x7c, 0xdb, 0x79, 0x30, 0xf3, 0x81, 0xc7, 0x9a, 0x19, 0xb4, 0x9f, 0xce, 0x13,
	0xbd, 0x59, 0x28, 0x61, 0xf5, 0x57, 0xf0, 0xa7, 0xfd, 0x0b, 0x80, 0xcf, 0xe7, 0xc8, 0x2a, 0x1f,
	0x8e, 0x69, 0xd2, 0x74, 0x59, 0x68, 0x0d, 0x6f, 0xdb, 0x95, 0x98, 0xb3, 0xb7, 0x89, 0x2b, 0x12,
	0x6b, 0xa0, 0xbf, 0x76, 0x2c, 0x4e, 0xfc, 0x54, 0x80, 0xd6, 0x40, 0x7d, 0xec, 0x14, 0xb5, 0xdd,
	0xd2, 0xd2, 0xb6, 0x06, 0x43, 0x82, 0xdf, 0xde, 0x41, 0xad, 0x11, 0x68, 0x01, 0x73, 0x95, 0xa0,
	0xad, 0x41, 0xf6, 0xb9, 0x77, 0xc4, 0x25, 0xb0, 0x36, 0x07, 0x67, 0x73, 0x91, 0x98, 0x3f, 0x01,
	0x78, 0xac, 0x54, 0x02, 0xc8, 0x81, 0x73, 0xdb, 0x98, 0x47, 0x19, 0xe9, 0x40, 0x92, 0xfe, 0xca,
	0x5e, 0x14, 0xf5, 0x16, 0xe6, 0x51, 0x01, 0xb2, 0xb8, 0xc9, 0x30, 0x85, 0xd4, 0x5b, 0xbc, 0x09,
	0x8f, 0xb8, 0x8c, 0x05, 0x1e, 0xeb, 0x47, 0x4e, 0x4c, 0x38, 0x65, 0x9e, 0x94, 0xf6, 0xdc, 0xca,
	0xb1, 0x2c, 0x49, 0x36, 0x31, 0xcd, 0x0d, 0x3d, 0x51, 0x6a, 0xbf, 0x0e, 0x67, 0x61, 0x2d, 0x19,
	0x65, 0xfe, 0x65, 0xc0, 0x46, 0x79, 0x62, 0xd4, 0x81, 0x27, 0x7c, 0x8e, 0x5d, 0xd2, 0xed, 0x05,
	0x8e, 0x47, 0x5c, 0x16, 0x86, 0x34, 0x49, 0x28, 0x8b, 0x1c, 0x41, 0x43, 0xc2, 0x7a, 0x42, 0xeb,
	0xa9, 0x3a, 0xab, 0xd1, 0x5e, 0xc8, 0x40, 0x36, 0x0a, 0x18, 0xd7, 0x15, 0x04, 0x3a, 0x0d, 0x8f,
	0xa4, 0x49, 0x89, 0xd3, 0x8b, 0x9d, 0x2e, 0x76, 0x05, 0xe3, 0x92, 0x30, 0xa0, 0x42, 0xe7, 0xa5,
	0xed, 0x46, 0x7c, 0x51, 0x5a, 0x90, 0x05, 0x8f, 0x2a, 0x67, 0xd9, 0xba, 0x76, 0x37, 0x76, 0xdd,
	0x15, 0xd4, 0x06, 0xeb, 0x47, 0x3a, 0x60, 0x1d, 0x1e, 0xcf, 0xd1, 0x43, 0x1a, 0x65, 0xe3, 0xd0,
	0xe5, 0xd8, 0x4d, 0xeb, 0x93, 0xd3, 0x0e, 0x14, 0x37, 0x75, 0x9d, 0xea, 0x2a, 0x8d, 0x94, 0x98,
	0x2f, 0x6a, 0x27, 0xb4, 0x09, 0x17, 0x0b, 0x59, 0x47, 0xc1, 0x4c, 0xef, 0xc2, 0x34, 0xf2, 0x12,
	0x86, 0x80, 0xcc, 0xcf, 0x01, 0x7c, 0x6e, 0x2f, 0xc3, 0x85, 0x4e, 0xc1, 0xf9, 0x34, 0x0d, 0xd5,
	0xbe, 0x89, 0xa4, 0xe4, 0x80, 0x4a, 0x70, 0x28, 0xa4, 0x51, 0x06, 0x92, 0x48, 0x4f, 0x7c, 0xa7,
	0xe0, 0x69, 0x14, 0x3d, 0xf1, 0x9d, 0x5d, 0xcf, 0x05, 0x38, 0xd3, 0x27, 0xd4, 0xdf, 0x12, 0xb2,
	0x69, 0xed, 0xa2, 0x97, 0xcc, 0x1f, 0x01, 0x5c, 0x5c, 0xe7, 0x04, 0x0b, 0x32, 0x54, 0x52, 0x9b,
	0xbc, 0xd3, 0x23, 0x89, 0x40, 0x97, 0xe0, 0x4c, 0x8c, 0x39, 0x89, 0x84, 0x3e, 0x5d, 0xcf, 0xdc,
	0xb7, 0x8d, 0x7f, 0xec, 0xd3, 0x68, 0xef, 0x53, 0xde, 0xd6, 0x00, 0xe8, 0x2a, 0x9c, 0x51, 0x83,
	0xa5, 0x65, 0xfb, 0xd2, 0x98, 0xd9, 0x18, 0x42, 0x52, 0xbb, 0xad, 0x41, 0x4c, 0x0f, 0x2e, 0x6c,
	0x12, 0x51, 0x5a, 0xf8, 0x05, 0x7d, 0xfa, 0x3f, 0x50, 0xf6, 0x3e, 0x0e, 0x27, 0x75, 0x57, 0x98,
	0x5f, 0x02, 0xb8, 0x78, 0x23, 0xf6, 0xaa, 0x28, 0x1a, 0xe4, 0x7d, 0x81, 0x09, 0xfb, 0x9a, 0xa0,
	0xba, 0x8c, 0x05, 0x1f, 0x2e, 0x6e, 0x90, 0x80, 0x54, 0x94, 0xf7, 0x98, 0x88, 0xf8, 0x1e, 0xc0,
	0xc5, 0x2b, 0x34, 0x19, 0x22, 0x9c, 0x92, 0xe4, 0x7f, 0xd0, 0xca, 0x12, 0x9c, 0x8d, 0xb1, 0x4f,
	0x9c, 0x84, 0xde, 0x25, 0x45, 0x71, 0x1f, 0x4c, 0x57, 0xaf, 0xd1, 0xbb, 0x04, 0x99, 0x10, 0x4a,
	0x0f, 0xc1, 0x6e, 0x11, 0x35, 0xd1, 0xb3, 0xca, 0x45, 0x06, 0x5e, 0x4f, 0x57, 0xcd, 0xaf, 0x00,
	0x3c, 0x59, 0x5a, 0x73, 0x12, 0xb3, 0x28, 0x21, 0xe8, 0x0d, 0x78, 0x30, 0x7b, 0x31, 0xd5, 0xc1,
	0xd2, 0xd4, 0xa4, 0xba, 0x9c, 0x6a, 0xe7, 0x30, 0xe9, 0xe1, 0x16, 0x91, 0x3b, 0xc2, 0x29, 0xd4,
	0x57, 0x78, 0x83, 0xcc, 0xa7, 0xb6, 0x56, 0x56, 0xe3, 0xca, 0x27, 0x87, 0x60, 0x7d, 0x08, 0xf1,
	0x1a, 0xe1, 0xb7, 0xa9, 0x4b, 0xd0, 0x77, 0x06, 0xac, 0x95, 0x0c, 0x28, 0x3a, 0x3f, 0xa6, 0xcc,
	0xea, 0xc1, 0x6e, 0xec, 0xbb, 0x4b, 0xf3, 0x6b, 0x70, 0xcf, 0x9e, 0x57, 0xfb, 0xf3, 0x82, 0x52,
	0xdf, 0xfb, 0xbf, 0xff, 0xf1, 0x99, 0xf1, 0x31, 0x30, 0xcf, 0xe5, 0x0f, 0xd1, 0x81, 0xb2, 0x9f,
	0xcf, 0xaf, 0xe2, 0xe5, 0xc2, 0x15, 0xbc, 0x3c, 0xf2, 0xea, 0x5d, 0xd5, 0x52, 0xbe, 0xb9, 0x61,
	0xae, 0x56, 0xe1, 0x64, 0x0f, 0x83, 0x6a, 0x14, 0xf4, 0x83, 0x01, 0x6b, 0x25, 0x03, 0x3b, 0x96,
	0xb2, 0xea, 0x41, 0x9f, 0x80, 0xb2, 0x6f, 0xc1, 0x3d, 0x7b, 0xa6, 0xc0, 0xd5, 0x17, 0xa0, 0xb1,
	0x5e, 0xe8, 0x51, 0x1a, 0x9a, 0xe9, 0x78, 0x95, 0x10, 0x36, 0xf2, 0xa9, 0xb2, 0xbc, 0x93, 0x53,
	0x76, 0xb9, 0x61, 0x8f, 0x85, 0xcb, 0x79, 0x1b, 0x03, 0x86, 0x3e, 0x35, 0xe0, 0x53, 0xa3, 0x4e,
	0x54, 0xb4, 0x3a, 0xa6, 0xef, 0x8a, 0x63, 0x78, 0x02, 0xce, 0x3e, 0x04, 0xf7, 0x6c, 0x79, 0xe4,
	0x48, 0xc6, 0xde, 0x45, 0x05, 0x71, 0xed, 0x9f, 0xa9, 0x9b, 0xe7, 0xd0, 0x6a, 0x79, 0xfc, 0x38,
	0x6a, 0xd0, 0x37, 0x06, 0xac, 0x95, 0x1c, 0x20, 0x63, 0xc5, 0x54, 0x7d, 0x58, 0x36, 0x5e, 0x9b,
	0x34, 0x5c, 0x9d, 0x5b, 0xe6, 0x47, 0x52, 0x5a, 0x72, 0x4a, 0x86, 0x89, 0xda, 0xff, 0x14, 0x3e,
	0x48, 0xd4, 0x7e, 0xa7, 0x0f, 0xfd, 0x0b, 0x60, 0xad, 0xe4, 0x1e, 0x1a, 0x4b, 0x54, 0xf5, 0xfd,
	0xd5, 0x78, 0x66, 0xe8, 0x9d, 0x79, 0x21, 0xfd, 0x3d, 0xf8, 0xb0, 0x4e, 0x96, 0x1f, 0x51, 0x27,
	0xcb, 0x8f, 0xa0, 0x93, 0xc6, 0xe5, 0x9f, 0xed, 0x5a, 0xc9, 0x25, 0xf7, 0x9b, 0xdd, 0xdc, 0x12,
	0x22, 0x4e, 0x56, 0x2d, 0xab, 0xdf, 0xef, 0x3f, 0x7c, 0x03, 0xe2, 0x9e, 0xd8, 0x52, 0x3f, 0xea,
	0x5f, 0x8c, 0x03, 0x2c, 0xba, 0x8c, 0x87, 0x6b, 0x1f, 0x00, 0xf8, 0xac, 0xcb, 0xc2, 0x6a, 0xd6,
	0xd6, 0xea, 0x23, 0xc4, 0xd1, 0x4a, 0x19, 0x6a, 0x81, 0x9b, 0x17, 0x74, 0xa8, 0xcf, 0x02, 0x1c,
	0xf9, 0x4d, 0xc6, 0x7d, 0xcb, 0x27, 0x91, 0xe4, 0xcf, 0xda, 0x2d, 0xa0, 0xe4, 0x9f, 0x09, 0xaf,
	0x66, 0x0b, 0x9d, 0x19, 0x19, 0xf1, 0xf2, 0x7f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xf3, 0xba, 0x81,
	0x3f, 0x7d, 0x10, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AutoscalingPolicyServiceClient is the client API for AutoscalingPolicyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AutoscalingPolicyServiceClient interface {
	// Creates new autoscaling policy.
	CreateAutoscalingPolicy(ctx context.Context, in *CreateAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error)
	// Updates (replaces) autoscaling policy.
	//
	// Disabled check for update_mask, because all updates will be full
	// replacements.
	UpdateAutoscalingPolicy(ctx context.Context, in *UpdateAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error)
	// Retrieves autoscaling policy.
	GetAutoscalingPolicy(ctx context.Context, in *GetAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error)
	// Lists autoscaling policies in the project.
	ListAutoscalingPolicies(ctx context.Context, in *ListAutoscalingPoliciesRequest, opts ...grpc.CallOption) (*ListAutoscalingPoliciesResponse, error)
	// Deletes an autoscaling policy. It is an error to delete an autoscaling
	// policy that is in use by one or more clusters.
	DeleteAutoscalingPolicy(ctx context.Context, in *DeleteAutoscalingPolicyRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type autoscalingPolicyServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAutoscalingPolicyServiceClient(cc grpc.ClientConnInterface) AutoscalingPolicyServiceClient {
	return &autoscalingPolicyServiceClient{cc}
}

func (c *autoscalingPolicyServiceClient) CreateAutoscalingPolicy(ctx context.Context, in *CreateAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error) {
	out := new(AutoscalingPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.AutoscalingPolicyService/CreateAutoscalingPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalingPolicyServiceClient) UpdateAutoscalingPolicy(ctx context.Context, in *UpdateAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error) {
	out := new(AutoscalingPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.AutoscalingPolicyService/UpdateAutoscalingPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalingPolicyServiceClient) GetAutoscalingPolicy(ctx context.Context, in *GetAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error) {
	out := new(AutoscalingPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.AutoscalingPolicyService/GetAutoscalingPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalingPolicyServiceClient) ListAutoscalingPolicies(ctx context.Context, in *ListAutoscalingPoliciesRequest, opts ...grpc.CallOption) (*ListAutoscalingPoliciesResponse, error) {
	out := new(ListAutoscalingPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.AutoscalingPolicyService/ListAutoscalingPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalingPolicyServiceClient) DeleteAutoscalingPolicy(ctx context.Context, in *DeleteAutoscalingPolicyRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.AutoscalingPolicyService/DeleteAutoscalingPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AutoscalingPolicyServiceServer is the server API for AutoscalingPolicyService service.
type AutoscalingPolicyServiceServer interface {
	// Creates new autoscaling policy.
	CreateAutoscalingPolicy(context.Context, *CreateAutoscalingPolicyRequest) (*AutoscalingPolicy, error)
	// Updates (replaces) autoscaling policy.
	//
	// Disabled check for update_mask, because all updates will be full
	// replacements.
	UpdateAutoscalingPolicy(context.Context, *UpdateAutoscalingPolicyRequest) (*AutoscalingPolicy, error)
	// Retrieves autoscaling policy.
	GetAutoscalingPolicy(context.Context, *GetAutoscalingPolicyRequest) (*AutoscalingPolicy, error)
	// Lists autoscaling policies in the project.
	ListAutoscalingPolicies(context.Context, *ListAutoscalingPoliciesRequest) (*ListAutoscalingPoliciesResponse, error)
	// Deletes an autoscaling policy. It is an error to delete an autoscaling
	// policy that is in use by one or more clusters.
	DeleteAutoscalingPolicy(context.Context, *DeleteAutoscalingPolicyRequest) (*empty.Empty, error)
}

// UnimplementedAutoscalingPolicyServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAutoscalingPolicyServiceServer struct {
}

func (*UnimplementedAutoscalingPolicyServiceServer) CreateAutoscalingPolicy(ctx context.Context, req *CreateAutoscalingPolicyRequest) (*AutoscalingPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAutoscalingPolicy not implemented")
}
func (*UnimplementedAutoscalingPolicyServiceServer) UpdateAutoscalingPolicy(ctx context.Context, req *UpdateAutoscalingPolicyRequest) (*AutoscalingPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAutoscalingPolicy not implemented")
}
func (*UnimplementedAutoscalingPolicyServiceServer) GetAutoscalingPolicy(ctx context.Context, req *GetAutoscalingPolicyRequest) (*AutoscalingPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAutoscalingPolicy not implemented")
}
func (*UnimplementedAutoscalingPolicyServiceServer) ListAutoscalingPolicies(ctx context.Context, req *ListAutoscalingPoliciesRequest) (*ListAutoscalingPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAutoscalingPolicies not implemented")
}
func (*UnimplementedAutoscalingPolicyServiceServer) DeleteAutoscalingPolicy(ctx context.Context, req *DeleteAutoscalingPolicyRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAutoscalingPolicy not implemented")
}

func RegisterAutoscalingPolicyServiceServer(s *grpc.Server, srv AutoscalingPolicyServiceServer) {
	s.RegisterService(&_AutoscalingPolicyService_serviceDesc, srv)
}

func _AutoscalingPolicyService_CreateAutoscalingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAutoscalingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).CreateAutoscalingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.AutoscalingPolicyService/CreateAutoscalingPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).CreateAutoscalingPolicy(ctx, req.(*CreateAutoscalingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoscalingPolicyService_UpdateAutoscalingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAutoscalingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).UpdateAutoscalingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.AutoscalingPolicyService/UpdateAutoscalingPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).UpdateAutoscalingPolicy(ctx, req.(*UpdateAutoscalingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoscalingPolicyService_GetAutoscalingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAutoscalingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).GetAutoscalingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.AutoscalingPolicyService/GetAutoscalingPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).GetAutoscalingPolicy(ctx, req.(*GetAutoscalingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoscalingPolicyService_ListAutoscalingPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAutoscalingPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).ListAutoscalingPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.AutoscalingPolicyService/ListAutoscalingPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).ListAutoscalingPolicies(ctx, req.(*ListAutoscalingPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoscalingPolicyService_DeleteAutoscalingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAutoscalingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).DeleteAutoscalingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.AutoscalingPolicyService/DeleteAutoscalingPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).DeleteAutoscalingPolicy(ctx, req.(*DeleteAutoscalingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AutoscalingPolicyService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1beta2.AutoscalingPolicyService",
	HandlerType: (*AutoscalingPolicyServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAutoscalingPolicy",
			Handler:    _AutoscalingPolicyService_CreateAutoscalingPolicy_Handler,
		},
		{
			MethodName: "UpdateAutoscalingPolicy",
			Handler:    _AutoscalingPolicyService_UpdateAutoscalingPolicy_Handler,
		},
		{
			MethodName: "GetAutoscalingPolicy",
			Handler:    _AutoscalingPolicyService_GetAutoscalingPolicy_Handler,
		},
		{
			MethodName: "ListAutoscalingPolicies",
			Handler:    _AutoscalingPolicyService_ListAutoscalingPolicies_Handler,
		},
		{
			MethodName: "DeleteAutoscalingPolicy",
			Handler:    _AutoscalingPolicyService_DeleteAutoscalingPolicy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1beta2/autoscaling_policies.proto",
}
