// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2/agent.proto

package dialogflow

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Match mode determines how intents are detected from user queries.
type Agent_MatchMode int32

const (
	// Not specified.
	Agent_MATCH_MODE_UNSPECIFIED Agent_MatchMode = 0
	// Best for agents with a small number of examples in intents and/or wide
	// use of templates syntax and composite entities.
	Agent_MATCH_MODE_HYBRID Agent_MatchMode = 1
	// Can be used for agents with a large number of examples in intents,
	// especially the ones using @sys.any or very large custom entities.
	Agent_MATCH_MODE_ML_ONLY Agent_MatchMode = 2
)

var Agent_MatchMode_name = map[int32]string{
	0: "MATCH_MODE_UNSPECIFIED",
	1: "MATCH_MODE_HYBRID",
	2: "MATCH_MODE_ML_ONLY",
}

var Agent_MatchMode_value = map[string]int32{
	"MATCH_MODE_UNSPECIFIED": 0,
	"MATCH_MODE_HYBRID":      1,
	"MATCH_MODE_ML_ONLY":     2,
}

func (x Agent_MatchMode) String() string {
	return proto.EnumName(Agent_MatchMode_name, int32(x))
}

func (Agent_MatchMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_59198d2091110e70, []int{0, 0}
}

// API version for the agent.
type Agent_ApiVersion int32

const (
	// Not specified.
	Agent_API_VERSION_UNSPECIFIED Agent_ApiVersion = 0
	// Legacy V1 API.
	Agent_API_VERSION_V1 Agent_ApiVersion = 1
	// V2 API.
	Agent_API_VERSION_V2 Agent_ApiVersion = 2
	// V2beta1 API.
	Agent_API_VERSION_V2_BETA_1 Agent_ApiVersion = 3
)

var Agent_ApiVersion_name = map[int32]string{
	0: "API_VERSION_UNSPECIFIED",
	1: "API_VERSION_V1",
	2: "API_VERSION_V2",
	3: "API_VERSION_V2_BETA_1",
}

var Agent_ApiVersion_value = map[string]int32{
	"API_VERSION_UNSPECIFIED": 0,
	"API_VERSION_V1":          1,
	"API_VERSION_V2":          2,
	"API_VERSION_V2_BETA_1":   3,
}

func (x Agent_ApiVersion) String() string {
	return proto.EnumName(Agent_ApiVersion_name, int32(x))
}

func (Agent_ApiVersion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_59198d2091110e70, []int{0, 1}
}

// Represents the agent tier.
type Agent_Tier int32

const (
	// Not specified. This value should never be used.
	Agent_TIER_UNSPECIFIED Agent_Tier = 0
	// Standard tier.
	Agent_TIER_STANDARD Agent_Tier = 1
	// Enterprise tier (Essentials).
	Agent_TIER_ENTERPRISE Agent_Tier = 2
	// Enterprise tier (Plus).
	Agent_TIER_ENTERPRISE_PLUS Agent_Tier = 3
)

var Agent_Tier_name = map[int32]string{
	0: "TIER_UNSPECIFIED",
	1: "TIER_STANDARD",
	2: "TIER_ENTERPRISE",
	3: "TIER_ENTERPRISE_PLUS",
}

var Agent_Tier_value = map[string]int32{
	"TIER_UNSPECIFIED":     0,
	"TIER_STANDARD":        1,
	"TIER_ENTERPRISE":      2,
	"TIER_ENTERPRISE_PLUS": 3,
}

func (x Agent_Tier) String() string {
	return proto.EnumName(Agent_Tier_name, int32(x))
}

func (Agent_Tier) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_59198d2091110e70, []int{0, 2}
}

// Represents a conversational agent.
type Agent struct {
	// Required. The project of this agent.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The name of this agent.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The default language of the agent as a language tag. See
	// [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes. This field cannot be
	// set by the `Update` method.
	DefaultLanguageCode string `protobuf:"bytes,3,opt,name=default_language_code,json=defaultLanguageCode,proto3" json:"default_language_code,omitempty"`
	// Optional. The list of all languages supported by this agent (except for the
	// `default_language_code`).
	SupportedLanguageCodes []string `protobuf:"bytes,4,rep,name=supported_language_codes,json=supportedLanguageCodes,proto3" json:"supported_language_codes,omitempty"`
	// Required. The time zone of this agent from the
	// [time zone database](https://www.iana.org/time-zones), e.g.,
	// America/New_York, Europe/Paris.
	TimeZone string `protobuf:"bytes,5,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Optional. The description of this agent.
	// The maximum length is 500 characters. If exceeded, the request is rejected.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The URI of the agent's avatar.
	// Avatars are used throughout the Dialogflow console and in the self-hosted
	// [Web
	// Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
	// integration.
	AvatarUri string `protobuf:"bytes,7,opt,name=avatar_uri,json=avatarUri,proto3" json:"avatar_uri,omitempty"`
	// Optional. Determines whether this agent should log conversation queries.
	EnableLogging bool `protobuf:"varint,8,opt,name=enable_logging,json=enableLogging,proto3" json:"enable_logging,omitempty"`
	// Optional. Determines how intents are detected from user queries.
	MatchMode Agent_MatchMode `protobuf:"varint,9,opt,name=match_mode,json=matchMode,proto3,enum=google.cloud.dialogflow.v2.Agent_MatchMode" json:"match_mode,omitempty"`
	// Optional. To filter out false positive results and still get variety in
	// matched natural language inputs for your agent, you can tune the machine
	// learning classification threshold. If the returned score value is less than
	// the threshold value, then a fallback intent will be triggered or, if there
	// are no fallback intents defined, no intent will be triggered. The score
	// values range from 0.0 (completely uncertain) to 1.0 (completely certain).
	// If set to 0.0, the default of 0.3 is used.
	ClassificationThreshold float32 `protobuf:"fixed32,10,opt,name=classification_threshold,json=classificationThreshold,proto3" json:"classification_threshold,omitempty"`
	// Optional. API version displayed in Dialogflow console. If not specified,
	// V2 API is assumed. Clients are free to query different service endpoints
	// for different API versions. However, bots connectors and webhook calls will
	// follow the specified API version.
	ApiVersion Agent_ApiVersion `protobuf:"varint,14,opt,name=api_version,json=apiVersion,proto3,enum=google.cloud.dialogflow.v2.Agent_ApiVersion" json:"api_version,omitempty"`
	// Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
	Tier                 Agent_Tier `protobuf:"varint,15,opt,name=tier,proto3,enum=google.cloud.dialogflow.v2.Agent_Tier" json:"tier,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Agent) Reset()         { *m = Agent{} }
func (m *Agent) String() string { return proto.CompactTextString(m) }
func (*Agent) ProtoMessage()    {}
func (*Agent) Descriptor() ([]byte, []int) {
	return fileDescriptor_59198d2091110e70, []int{0}
}

func (m *Agent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Agent.Unmarshal(m, b)
}
func (m *Agent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Agent.Marshal(b, m, deterministic)
}
func (m *Agent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Agent.Merge(m, src)
}
func (m *Agent) XXX_Size() int {
	return xxx_messageInfo_Agent.Size(m)
}
func (m *Agent) XXX_DiscardUnknown() {
	xxx_messageInfo_Agent.DiscardUnknown(m)
}

var xxx_messageInfo_Agent proto.InternalMessageInfo

func (m *Agent) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *Agent) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Agent) GetDefaultLanguageCode() string {
	if m != nil {
		return m.DefaultLanguageCode
	}
	return ""
}

func (m *Agent) GetSupportedLanguageCodes() []string {
	if m != nil {
		return m.SupportedLanguageCodes
	}
	return nil
}

func (m *Agent) GetTimeZone() string {
	if m != nil {
		return m.TimeZone
	}
	return ""
}

func (m *Agent) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Agent) GetAvatarUri() string {
	if m != nil {
		return m.AvatarUri
	}
	return ""
}

func (m *Agent) GetEnableLogging() bool {
	if m != nil {
		return m.EnableLogging
	}
	return false
}

func (m *Agent) GetMatchMode() Agent_MatchMode {
	if m != nil {
		return m.MatchMode
	}
	return Agent_MATCH_MODE_UNSPECIFIED
}

func (m *Agent) GetClassificationThreshold() float32 {
	if m != nil {
		return m.ClassificationThreshold
	}
	return 0
}

func (m *Agent) GetApiVersion() Agent_ApiVersion {
	if m != nil {
		return m.ApiVersion
	}
	return Agent_API_VERSION_UNSPECIFIED
}

func (m *Agent) GetTier() Agent_Tier {
	if m != nil {
		return m.Tier
	}
	return Agent_TIER_UNSPECIFIED
}

// The request message for [Agents.GetAgent][google.cloud.dialogflow.v2.Agents.GetAgent].
type GetAgentRequest struct {
	// Required. The project that the agent to fetch is associated with.
	// Format: `projects/<Project ID>`.
	Parent               string   `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAgentRequest) Reset()         { *m = GetAgentRequest{} }
func (m *GetAgentRequest) String() string { return proto.CompactTextString(m) }
func (*GetAgentRequest) ProtoMessage()    {}
func (*GetAgentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_59198d2091110e70, []int{1}
}

func (m *GetAgentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAgentRequest.Unmarshal(m, b)
}
func (m *GetAgentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAgentRequest.Marshal(b, m, deterministic)
}
func (m *GetAgentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAgentRequest.Merge(m, src)
}
func (m *GetAgentRequest) XXX_Size() int {
	return xxx_messageInfo_GetAgentRequest.Size(m)
}
func (m *GetAgentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAgentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAgentRequest proto.InternalMessageInfo

func (m *GetAgentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// The request message for [Agents.SetAgent][google.cloud.dialogflow.v2.Agents.SetAgent].
type SetAgentRequest struct {
	// Required. The agent to update.
	Agent *Agent `protobuf:"bytes,1,opt,name=agent,proto3" json:"agent,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SetAgentRequest) Reset()         { *m = SetAgentRequest{} }
func (m *SetAgentRequest) String() string { return proto.CompactTextString(m) }
func (*SetAgentRequest) ProtoMessage()    {}
func (*SetAgentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_59198d2091110e70, []int{2}
}

func (m *SetAgentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetAgentRequest.Unmarshal(m, b)
}
func (m *SetAgentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetAgentRequest.Marshal(b, m, deterministic)
}
func (m *SetAgentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetAgentRequest.Merge(m, src)
}
func (m *SetAgentRequest) XXX_Size() int {
	return xxx_messageInfo_SetAgentRequest.Size(m)
}
func (m *SetAgentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetAgentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetAgentRequest proto.InternalMessageInfo

func (m *SetAgentRequest) GetAgent() *Agent {
	if m != nil {
		return m.Agent
	}
	return nil
}

func (m *SetAgentRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request message for [Agents.DeleteAgent][google.cloud.dialogflow.v2.Agents.DeleteAgent].
type DeleteAgentRequest struct {
	// Required. The project that the agent to delete is associated with.
	// Format: `projects/<Project ID>`.
	Parent               string   `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAgentRequest) Reset()         { *m = DeleteAgentRequest{} }
func (m *DeleteAgentRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAgentRequest) ProtoMessage()    {}
func (*DeleteAgentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_59198d2091110e70, []int{3}
}

func (m *DeleteAgentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAgentRequest.Unmarshal(m, b)
}
func (m *DeleteAgentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAgentRequest.Marshal(b, m, deterministic)
}
func (m *DeleteAgentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAgentRequest.Merge(m, src)
}
func (m *DeleteAgentRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteAgentRequest.Size(m)
}
func (m *DeleteAgentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAgentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAgentRequest proto.InternalMessageInfo

func (m *DeleteAgentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// The request message for [Agents.SearchAgents][google.cloud.dialogflow.v2.Agents.SearchAgents].
type SearchAgentsRequest struct {
	// Required. The project to list agents from.
	// Format: `projects/<Project ID or '-'>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchAgentsRequest) Reset()         { *m = SearchAgentsRequest{} }
func (m *SearchAgentsRequest) String() string { return proto.CompactTextString(m) }
func (*SearchAgentsRequest) ProtoMessage()    {}
func (*SearchAgentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_59198d2091110e70, []int{4}
}

func (m *SearchAgentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchAgentsRequest.Unmarshal(m, b)
}
func (m *SearchAgentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchAgentsRequest.Marshal(b, m, deterministic)
}
func (m *SearchAgentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchAgentsRequest.Merge(m, src)
}
func (m *SearchAgentsRequest) XXX_Size() int {
	return xxx_messageInfo_SearchAgentsRequest.Size(m)
}
func (m *SearchAgentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchAgentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchAgentsRequest proto.InternalMessageInfo

func (m *SearchAgentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *SearchAgentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchAgentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response message for [Agents.SearchAgents][google.cloud.dialogflow.v2.Agents.SearchAgents].
type SearchAgentsResponse struct {
	// The list of agents. There will be a maximum number of items returned based
	// on the page_size field in the request.
	Agents []*Agent `protobuf:"bytes,1,rep,name=agents,proto3" json:"agents,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchAgentsResponse) Reset()         { *m = SearchAgentsResponse{} }
func (m *SearchAgentsResponse) String() string { return proto.CompactTextString(m) }
func (*SearchAgentsResponse) ProtoMessage()    {}
func (*SearchAgentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_59198d2091110e70, []int{5}
}

func (m *SearchAgentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchAgentsResponse.Unmarshal(m, b)
}
func (m *SearchAgentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchAgentsResponse.Marshal(b, m, deterministic)
}
func (m *SearchAgentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchAgentsResponse.Merge(m, src)
}
func (m *SearchAgentsResponse) XXX_Size() int {
	return xxx_messageInfo_SearchAgentsResponse.Size(m)
}
func (m *SearchAgentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchAgentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchAgentsResponse proto.InternalMessageInfo

func (m *SearchAgentsResponse) GetAgents() []*Agent {
	if m != nil {
		return m.Agents
	}
	return nil
}

func (m *SearchAgentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for [Agents.TrainAgent][google.cloud.dialogflow.v2.Agents.TrainAgent].
type TrainAgentRequest struct {
	// Required. The project that the agent to train is associated with.
	// Format: `projects/<Project ID>`.
	Parent               string   `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TrainAgentRequest) Reset()         { *m = TrainAgentRequest{} }
func (m *TrainAgentRequest) String() string { return proto.CompactTextString(m) }
func (*TrainAgentRequest) ProtoMessage()    {}
func (*TrainAgentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_59198d2091110e70, []int{6}
}

func (m *TrainAgentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TrainAgentRequest.Unmarshal(m, b)
}
func (m *TrainAgentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TrainAgentRequest.Marshal(b, m, deterministic)
}
func (m *TrainAgentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TrainAgentRequest.Merge(m, src)
}
func (m *TrainAgentRequest) XXX_Size() int {
	return xxx_messageInfo_TrainAgentRequest.Size(m)
}
func (m *TrainAgentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TrainAgentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TrainAgentRequest proto.InternalMessageInfo

func (m *TrainAgentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// The request message for [Agents.ExportAgent][google.cloud.dialogflow.v2.Agents.ExportAgent].
type ExportAgentRequest struct {
	// Required. The project that the agent to export is associated with.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The [Google Cloud Storage](https://cloud.google.com/storage/docs/)
	// URI to export the agent to.
	// The format of this URI must be `gs://<bucket-name>/<object-name>`.
	// If left unspecified, the serialized agent is returned inline.
	AgentUri             string   `protobuf:"bytes,2,opt,name=agent_uri,json=agentUri,proto3" json:"agent_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportAgentRequest) Reset()         { *m = ExportAgentRequest{} }
func (m *ExportAgentRequest) String() string { return proto.CompactTextString(m) }
func (*ExportAgentRequest) ProtoMessage()    {}
func (*ExportAgentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_59198d2091110e70, []int{7}
}

func (m *ExportAgentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportAgentRequest.Unmarshal(m, b)
}
func (m *ExportAgentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportAgentRequest.Marshal(b, m, deterministic)
}
func (m *ExportAgentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportAgentRequest.Merge(m, src)
}
func (m *ExportAgentRequest) XXX_Size() int {
	return xxx_messageInfo_ExportAgentRequest.Size(m)
}
func (m *ExportAgentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportAgentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportAgentRequest proto.InternalMessageInfo

func (m *ExportAgentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ExportAgentRequest) GetAgentUri() string {
	if m != nil {
		return m.AgentUri
	}
	return ""
}

// The response message for [Agents.ExportAgent][google.cloud.dialogflow.v2.Agents.ExportAgent].
type ExportAgentResponse struct {
	// The exported agent.
	//
	// Types that are valid to be assigned to Agent:
	//	*ExportAgentResponse_AgentUri
	//	*ExportAgentResponse_AgentContent
	Agent                isExportAgentResponse_Agent `protobuf_oneof:"agent"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *ExportAgentResponse) Reset()         { *m = ExportAgentResponse{} }
func (m *ExportAgentResponse) String() string { return proto.CompactTextString(m) }
func (*ExportAgentResponse) ProtoMessage()    {}
func (*ExportAgentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_59198d2091110e70, []int{8}
}

func (m *ExportAgentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportAgentResponse.Unmarshal(m, b)
}
func (m *ExportAgentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportAgentResponse.Marshal(b, m, deterministic)
}
func (m *ExportAgentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportAgentResponse.Merge(m, src)
}
func (m *ExportAgentResponse) XXX_Size() int {
	return xxx_messageInfo_ExportAgentResponse.Size(m)
}
func (m *ExportAgentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportAgentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExportAgentResponse proto.InternalMessageInfo

type isExportAgentResponse_Agent interface {
	isExportAgentResponse_Agent()
}

type ExportAgentResponse_AgentUri struct {
	AgentUri string `protobuf:"bytes,1,opt,name=agent_uri,json=agentUri,proto3,oneof"`
}

type ExportAgentResponse_AgentContent struct {
	AgentContent []byte `protobuf:"bytes,2,opt,name=agent_content,json=agentContent,proto3,oneof"`
}

func (*ExportAgentResponse_AgentUri) isExportAgentResponse_Agent() {}

func (*ExportAgentResponse_AgentContent) isExportAgentResponse_Agent() {}

func (m *ExportAgentResponse) GetAgent() isExportAgentResponse_Agent {
	if m != nil {
		return m.Agent
	}
	return nil
}

func (m *ExportAgentResponse) GetAgentUri() string {
	if x, ok := m.GetAgent().(*ExportAgentResponse_AgentUri); ok {
		return x.AgentUri
	}
	return ""
}

func (m *ExportAgentResponse) GetAgentContent() []byte {
	if x, ok := m.GetAgent().(*ExportAgentResponse_AgentContent); ok {
		return x.AgentContent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ExportAgentResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ExportAgentResponse_AgentUri)(nil),
		(*ExportAgentResponse_AgentContent)(nil),
	}
}

// The request message for [Agents.ImportAgent][google.cloud.dialogflow.v2.Agents.ImportAgent].
type ImportAgentRequest struct {
	// Required. The project that the agent to import is associated with.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The agent to import.
	//
	// Types that are valid to be assigned to Agent:
	//	*ImportAgentRequest_AgentUri
	//	*ImportAgentRequest_AgentContent
	Agent                isImportAgentRequest_Agent `protobuf_oneof:"agent"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *ImportAgentRequest) Reset()         { *m = ImportAgentRequest{} }
func (m *ImportAgentRequest) String() string { return proto.CompactTextString(m) }
func (*ImportAgentRequest) ProtoMessage()    {}
func (*ImportAgentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_59198d2091110e70, []int{9}
}

func (m *ImportAgentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportAgentRequest.Unmarshal(m, b)
}
func (m *ImportAgentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportAgentRequest.Marshal(b, m, deterministic)
}
func (m *ImportAgentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportAgentRequest.Merge(m, src)
}
func (m *ImportAgentRequest) XXX_Size() int {
	return xxx_messageInfo_ImportAgentRequest.Size(m)
}
func (m *ImportAgentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportAgentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportAgentRequest proto.InternalMessageInfo

func (m *ImportAgentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

type isImportAgentRequest_Agent interface {
	isImportAgentRequest_Agent()
}

type ImportAgentRequest_AgentUri struct {
	AgentUri string `protobuf:"bytes,2,opt,name=agent_uri,json=agentUri,proto3,oneof"`
}

type ImportAgentRequest_AgentContent struct {
	AgentContent []byte `protobuf:"bytes,3,opt,name=agent_content,json=agentContent,proto3,oneof"`
}

func (*ImportAgentRequest_AgentUri) isImportAgentRequest_Agent() {}

func (*ImportAgentRequest_AgentContent) isImportAgentRequest_Agent() {}

func (m *ImportAgentRequest) GetAgent() isImportAgentRequest_Agent {
	if m != nil {
		return m.Agent
	}
	return nil
}

func (m *ImportAgentRequest) GetAgentUri() string {
	if x, ok := m.GetAgent().(*ImportAgentRequest_AgentUri); ok {
		return x.AgentUri
	}
	return ""
}

func (m *ImportAgentRequest) GetAgentContent() []byte {
	if x, ok := m.GetAgent().(*ImportAgentRequest_AgentContent); ok {
		return x.AgentContent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ImportAgentRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ImportAgentRequest_AgentUri)(nil),
		(*ImportAgentRequest_AgentContent)(nil),
	}
}

// The request message for [Agents.RestoreAgent][google.cloud.dialogflow.v2.Agents.RestoreAgent].
type RestoreAgentRequest struct {
	// Required. The project that the agent to restore is associated with.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The agent to restore.
	//
	// Types that are valid to be assigned to Agent:
	//	*RestoreAgentRequest_AgentUri
	//	*RestoreAgentRequest_AgentContent
	Agent                isRestoreAgentRequest_Agent `protobuf_oneof:"agent"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *RestoreAgentRequest) Reset()         { *m = RestoreAgentRequest{} }
func (m *RestoreAgentRequest) String() string { return proto.CompactTextString(m) }
func (*RestoreAgentRequest) ProtoMessage()    {}
func (*RestoreAgentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_59198d2091110e70, []int{10}
}

func (m *RestoreAgentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreAgentRequest.Unmarshal(m, b)
}
func (m *RestoreAgentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreAgentRequest.Marshal(b, m, deterministic)
}
func (m *RestoreAgentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreAgentRequest.Merge(m, src)
}
func (m *RestoreAgentRequest) XXX_Size() int {
	return xxx_messageInfo_RestoreAgentRequest.Size(m)
}
func (m *RestoreAgentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreAgentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreAgentRequest proto.InternalMessageInfo

func (m *RestoreAgentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

type isRestoreAgentRequest_Agent interface {
	isRestoreAgentRequest_Agent()
}

type RestoreAgentRequest_AgentUri struct {
	AgentUri string `protobuf:"bytes,2,opt,name=agent_uri,json=agentUri,proto3,oneof"`
}

type RestoreAgentRequest_AgentContent struct {
	AgentContent []byte `protobuf:"bytes,3,opt,name=agent_content,json=agentContent,proto3,oneof"`
}

func (*RestoreAgentRequest_AgentUri) isRestoreAgentRequest_Agent() {}

func (*RestoreAgentRequest_AgentContent) isRestoreAgentRequest_Agent() {}

func (m *RestoreAgentRequest) GetAgent() isRestoreAgentRequest_Agent {
	if m != nil {
		return m.Agent
	}
	return nil
}

func (m *RestoreAgentRequest) GetAgentUri() string {
	if x, ok := m.GetAgent().(*RestoreAgentRequest_AgentUri); ok {
		return x.AgentUri
	}
	return ""
}

func (m *RestoreAgentRequest) GetAgentContent() []byte {
	if x, ok := m.GetAgent().(*RestoreAgentRequest_AgentContent); ok {
		return x.AgentContent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*RestoreAgentRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*RestoreAgentRequest_AgentUri)(nil),
		(*RestoreAgentRequest_AgentContent)(nil),
	}
}

// The request message for [Agents.GetValidationResult][google.cloud.dialogflow.v2.Agents.GetValidationResult].
type GetValidationResultRequest struct {
	// Required. The project that the agent is associated with.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The language for which you want a validation result. If not
	// specified, the agent's default language is used. [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetValidationResultRequest) Reset()         { *m = GetValidationResultRequest{} }
func (m *GetValidationResultRequest) String() string { return proto.CompactTextString(m) }
func (*GetValidationResultRequest) ProtoMessage()    {}
func (*GetValidationResultRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_59198d2091110e70, []int{11}
}

func (m *GetValidationResultRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetValidationResultRequest.Unmarshal(m, b)
}
func (m *GetValidationResultRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetValidationResultRequest.Marshal(b, m, deterministic)
}
func (m *GetValidationResultRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetValidationResultRequest.Merge(m, src)
}
func (m *GetValidationResultRequest) XXX_Size() int {
	return xxx_messageInfo_GetValidationResultRequest.Size(m)
}
func (m *GetValidationResultRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetValidationResultRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetValidationResultRequest proto.InternalMessageInfo

func (m *GetValidationResultRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *GetValidationResultRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.dialogflow.v2.Agent_MatchMode", Agent_MatchMode_name, Agent_MatchMode_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2.Agent_ApiVersion", Agent_ApiVersion_name, Agent_ApiVersion_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2.Agent_Tier", Agent_Tier_name, Agent_Tier_value)
	proto.RegisterType((*Agent)(nil), "google.cloud.dialogflow.v2.Agent")
	proto.RegisterType((*GetAgentRequest)(nil), "google.cloud.dialogflow.v2.GetAgentRequest")
	proto.RegisterType((*SetAgentRequest)(nil), "google.cloud.dialogflow.v2.SetAgentRequest")
	proto.RegisterType((*DeleteAgentRequest)(nil), "google.cloud.dialogflow.v2.DeleteAgentRequest")
	proto.RegisterType((*SearchAgentsRequest)(nil), "google.cloud.dialogflow.v2.SearchAgentsRequest")
	proto.RegisterType((*SearchAgentsResponse)(nil), "google.cloud.dialogflow.v2.SearchAgentsResponse")
	proto.RegisterType((*TrainAgentRequest)(nil), "google.cloud.dialogflow.v2.TrainAgentRequest")
	proto.RegisterType((*ExportAgentRequest)(nil), "google.cloud.dialogflow.v2.ExportAgentRequest")
	proto.RegisterType((*ExportAgentResponse)(nil), "google.cloud.dialogflow.v2.ExportAgentResponse")
	proto.RegisterType((*ImportAgentRequest)(nil), "google.cloud.dialogflow.v2.ImportAgentRequest")
	proto.RegisterType((*RestoreAgentRequest)(nil), "google.cloud.dialogflow.v2.RestoreAgentRequest")
	proto.RegisterType((*GetValidationResultRequest)(nil), "google.cloud.dialogflow.v2.GetValidationResultRequest")
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2/agent.proto", fileDescriptor_59198d2091110e70)
}

var fileDescriptor_59198d2091110e70 = []byte{
	// 1506 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x58, 0xcd, 0x6f, 0x1b, 0x45,
	0x14, 0xef, 0x38, 0x4d, 0xea, 0x3c, 0xe7, 0xc3, 0x9d, 0x34, 0xa9, 0xeb, 0x12, 0x6a, 0xb6, 0x34,
	0x0a, 0x69, 0xeb, 0x6d, 0x5d, 0x51, 0x44, 0x4a, 0x0b, 0x9b, 0xd8, 0x6d, 0x2c, 0xf2, 0x61, 0xad,
	0x9d, 0x48, 0xed, 0xa1, 0xcb, 0x64, 0x3d, 0xd9, 0x2c, 0x5d, 0xef, 0x2c, 0xbb, 0xeb, 0xf4, 0x4b,
	0x5c, 0xa8, 0xb8, 0x70, 0x43, 0x48, 0x48, 0xbd, 0xc2, 0x05, 0x71, 0x02, 0xf1, 0x07, 0x20, 0x21,
	0xf5, 0xd2, 0x23, 0xdc, 0x7a, 0xaa, 0x10, 0x27, 0xfe, 0x02, 0xc4, 0x09, 0xed, 0xcc, 0x3a, 0x5e,
	0xdb, 0xc9, 0x3a, 0x45, 0xe4, 0xc0, 0xcd, 0x7e, 0xf3, 0x3e, 0x7e, 0xbf, 0x37, 0x3b, 0xbf, 0x37,
	0xbb, 0x30, 0x63, 0x30, 0x66, 0x58, 0x54, 0xd6, 0x2d, 0xd6, 0xac, 0xcb, 0x75, 0x93, 0x58, 0xcc,
	0xd8, 0xb2, 0xd8, 0x7d, 0x79, 0xa7, 0x20, 0x13, 0x83, 0xda, 0x7e, 0xde, 0x71, 0x99, 0xcf, 0x70,
	0x56, 0xf8, 0xe5, 0xb9, 0x5f, 0xbe, 0xed, 0x97, 0xdf, 0x29, 0x64, 0x5f, 0x0b, 0x73, 0x10, 0xc7,
	0x94, 0x89, 0x6d, 0x33, 0x9f, 0xf8, 0x26, 0xb3, 0x3d, 0x11, 0x99, 0x3d, 0x19, 0x59, 0xd5, 0x2d,
	0x73, 0x37, 0x65, 0xf6, 0x4c, 0x64, 0x61, 0xcb, 0xa4, 0x56, 0x5d, 0xdb, 0xa4, 0xdb, 0x64, 0xc7,
	0x64, 0x6e, 0xe8, 0x70, 0x2a, 0xe2, 0xe0, 0x52, 0x8f, 0x35, 0x5d, 0x9d, 0x86, 0x4b, 0x85, 0x18,
	0xd8, 0x3b, 0xc4, 0x32, 0xeb, 0x1c, 0x82, 0xe6, 0x52, 0xaf, 0x69, 0xb5, 0xea, 0x9d, 0x0d, 0x63,
	0x2c, 0x66, 0x1b, 0x6e, 0xd3, 0xb6, 0x4d, 0xdb, 0x90, 0x99, 0x43, 0xdd, 0x0e, 0xb4, 0xa7, 0x43,
	0x27, 0xfe, 0x6f, 0xb3, 0xb9, 0x25, 0xd3, 0x86, 0xe3, 0x3f, 0x0c, 0x17, 0x73, 0xdd, 0x8b, 0x02,
	0x76, 0x83, 0x78, 0xf7, 0x84, 0x87, 0xf4, 0x34, 0x09, 0x83, 0x4a, 0xd0, 0x36, 0xfc, 0x21, 0x0c,
	0x39, 0xc4, 0xa5, 0xb6, 0x9f, 0x41, 0x39, 0x34, 0x3b, 0xbc, 0x70, 0xe5, 0xa5, 0x92, 0xf8, 0x5b,
	0xb9, 0x08, 0xe7, 0x39, 0xe4, 0x16, 0x9d, 0x06, 0xb1, 0x89, 0x41, 0xdd, 0xbc, 0x48, 0x4c, 0x1c,
	0xd3, 0xcb, 0xeb, 0xac, 0x21, 0x57, 0x5c, 0xf6, 0x31, 0xd5, 0x7d, 0x35, 0x4c, 0x81, 0x67, 0x60,
	0xa4, 0x6e, 0x7a, 0x8e, 0x45, 0x1e, 0x6a, 0x36, 0x69, 0xd0, 0x4c, 0x82, 0xa7, 0x1c, 0x78, 0xa9,
	0x24, 0xd4, 0x54, 0xb8, 0xb0, 0x4a, 0x1a, 0x14, 0xbf, 0x03, 0x93, 0x75, 0xba, 0x45, 0x9a, 0x96,
	0xaf, 0x59, 0xc4, 0x36, 0x9a, 0xc4, 0xa0, 0x9a, 0xce, 0xea, 0x34, 0x33, 0xd0, 0x0e, 0x98, 0x08,
	0x3d, 0x96, 0x43, 0x87, 0x45, 0x56, 0xa7, 0xf8, 0x3a, 0x64, 0xbc, 0xa6, 0xe3, 0x30, 0xd7, 0xa7,
	0xf5, 0xce, 0x50, 0x2f, 0x73, 0x34, 0x37, 0x20, 0x62, 0x91, 0x3a, 0xb5, 0xeb, 0x14, 0x8d, 0xf6,
	0x70, 0x0e, 0x86, 0x7d, 0xb3, 0x41, 0xb5, 0x47, 0xcc, 0xa6, 0x99, 0xc1, 0x76, 0xad, 0x64, 0x60,
	0xbd, 0xc3, 0x6c, 0x8a, 0xcf, 0x41, 0xaa, 0x4e, 0x3d, 0xdd, 0x35, 0x9d, 0xa0, 0xdb, 0x99, 0xa1,
	0x96, 0x0f, 0x52, 0xa3, 0x76, 0x2c, 0x01, 0x90, 0x1d, 0xe2, 0x13, 0x57, 0x6b, 0xba, 0x66, 0xe6,
	0x58, 0xdb, 0x6b, 0x58, 0x98, 0xd7, 0x5d, 0x13, 0xcf, 0xc1, 0x18, 0xb5, 0xc9, 0xa6, 0x45, 0x35,
	0x8b, 0x19, 0x86, 0x69, 0x1b, 0x99, 0x64, 0x0e, 0xcd, 0x26, 0x85, 0xdf, 0xa8, 0x58, 0x5a, 0x16,
	0x2b, 0x78, 0x0d, 0xa0, 0x41, 0x7c, 0x7d, 0x5b, 0x6b, 0x04, 0x5d, 0x18, 0xce, 0xa1, 0xd9, 0xb1,
	0xc2, 0xf9, 0xfc, 0xfe, 0xcf, 0x72, 0x9e, 0x6f, 0x5e, 0x7e, 0x25, 0x88, 0x59, 0x61, 0x75, 0x1a,
	0x16, 0x6f, 0xb4, 0xfe, 0xe3, 0x1b, 0x90, 0xd1, 0x2d, 0xe2, 0x79, 0xe6, 0x96, 0xa9, 0x8b, 0x67,
	0xcc, 0xdf, 0x76, 0xa9, 0xb7, 0xcd, 0xac, 0x7a, 0x06, 0x72, 0x68, 0x36, 0x21, 0x22, 0x4e, 0x76,
	0x3a, 0xd5, 0x5a, 0x3e, 0x58, 0x85, 0x14, 0x71, 0x4c, 0x6d, 0x87, 0xba, 0x5e, 0xd0, 0x87, 0x31,
	0x8e, 0xe8, 0x42, 0x7f, 0x44, 0x8a, 0x63, 0x6e, 0x88, 0x18, 0x51, 0x00, 0xc8, 0xae, 0x01, 0xbf,
	0x0f, 0x47, 0x7d, 0x93, 0xba, 0x99, 0x71, 0x9e, 0x6c, 0xa6, 0x7f, 0xb2, 0x9a, 0x49, 0x5d, 0x91,
	0x86, 0x07, 0x4a, 0x1b, 0x30, 0xbc, 0xcb, 0x18, 0x67, 0x61, 0x6a, 0x45, 0xa9, 0x2d, 0x2e, 0x69,
	0x2b, 0x6b, 0xc5, 0x92, 0xb6, 0xbe, 0x5a, 0xad, 0x94, 0x16, 0xcb, 0x37, 0xcb, 0xa5, 0x62, 0xfa,
	0x08, 0x9e, 0x84, 0xe3, 0x91, 0xb5, 0xa5, 0xdb, 0x0b, 0x6a, 0xb9, 0x98, 0x46, 0x78, 0x0a, 0x70,
	0xc4, 0xbc, 0xb2, 0xac, 0xad, 0xad, 0x2e, 0xdf, 0x4e, 0x27, 0x24, 0x0b, 0xa0, 0x8d, 0x1b, 0x9f,
	0x86, 0x93, 0x4a, 0xa5, 0xac, 0x6d, 0x94, 0xd4, 0x6a, 0x79, 0x6d, 0xb5, 0x2b, 0x33, 0x86, 0xb1,
	0xe8, 0xe2, 0xc6, 0xe5, 0x34, 0xea, 0xb1, 0x15, 0xd2, 0x09, 0x7c, 0x0a, 0x26, 0x3b, 0x6d, 0xda,
	0x42, 0xa9, 0xa6, 0x68, 0x97, 0xd3, 0x03, 0xd2, 0x5d, 0x38, 0x1a, 0x10, 0xc3, 0x27, 0x20, 0x5d,
	0x2b, 0x97, 0xd4, 0xae, 0x02, 0xc7, 0x61, 0x94, 0x5b, 0xab, 0x35, 0x65, 0xb5, 0xa8, 0xa8, 0x01,
	0xec, 0x09, 0x18, 0xe7, 0xa6, 0xd2, 0x6a, 0xad, 0xa4, 0x56, 0xd4, 0x72, 0xb5, 0x94, 0x4e, 0xe0,
	0x0c, 0x9c, 0xe8, 0x32, 0x6a, 0x95, 0xe5, 0xf5, 0x6a, 0x7a, 0x60, 0xfe, 0xc6, 0x9f, 0xca, 0x35,
	0x38, 0x13, 0xe9, 0x67, 0xd7, 0xa1, 0x15, 0xe7, 0x3e, 0xe3, 0x88, 0xb3, 0xeb, 0xc9, 0x8f, 0xc3,
	0x5f, 0x9f, 0x0a, 0x21, 0x95, 0xee, 0xc2, 0xf8, 0x2d, 0xea, 0x73, 0x2f, 0x95, 0x7e, 0xd2, 0xa4,
	0xde, 0x7f, 0x2b, 0x12, 0xd2, 0x97, 0x08, 0xc6, 0xab, 0x5d, 0x05, 0xde, 0x83, 0x41, 0x5e, 0x9c,
	0xe7, 0x4f, 0x15, 0xde, 0xe8, 0xfb, 0x6c, 0x88, 0x73, 0x2b, 0x82, 0xf0, 0x07, 0x90, 0x6a, 0x3a,
	0x75, 0xe2, 0x53, 0x2e, 0x71, 0x5c, 0x75, 0x52, 0x85, 0x6c, 0x2b, 0x47, 0x4b, 0x05, 0xf3, 0x37,
	0x03, 0x15, 0x5c, 0x21, 0xde, 0xbd, 0xf0, 0xd1, 0x14, 0x31, 0x81, 0x41, 0x22, 0x80, 0x8b, 0xd4,
	0xa2, 0x3e, 0x3d, 0x3c, 0xda, 0xdf, 0x22, 0x98, 0xa8, 0x52, 0xe2, 0xea, 0xdb, 0xbc, 0x86, 0x77,
	0x18, 0x45, 0x02, 0x81, 0x73, 0x02, 0x45, 0xf4, 0xcc, 0x47, 0x42, 0x7d, 0x07, 0x05, 0xd7, 0x64,
	0x60, 0xad, 0x9a, 0x8f, 0x28, 0x9e, 0x06, 0xe0, 0x1e, 0x3e, 0xbb, 0x47, 0x6d, 0xa1, 0xb7, 0x2a,
	0x8f, 0xa9, 0x05, 0x06, 0xe9, 0x21, 0x9c, 0xe8, 0x04, 0xe9, 0x39, 0xcc, 0xf6, 0x28, 0x7e, 0x17,
	0x86, 0x78, 0xaf, 0xbd, 0x0c, 0xca, 0x0d, 0x1c, 0x68, 0x87, 0xd4, 0x30, 0x00, 0xcf, 0xc0, 0xb8,
	0x4d, 0x1f, 0xf8, 0x5a, 0xa4, 0x2c, 0x9f, 0x0b, 0xea, 0x68, 0x60, 0xae, 0xec, 0x96, 0xfe, 0x08,
	0x8e, 0xd7, 0x5c, 0x62, 0xda, 0x87, 0xb7, 0x05, 0x4f, 0x10, 0xe0, 0xd2, 0x83, 0x60, 0x30, 0x1c,
	0x5a, 0x8d, 0x60, 0x07, 0x38, 0x6f, 0x3e, 0x18, 0x22, 0xf3, 0x2f, 0xc9, 0xad, 0xeb, 0xae, 0x29,
	0xd5, 0x61, 0xa2, 0x03, 0x44, 0xd8, 0xe1, 0xe9, 0x68, 0x20, 0x07, 0xb2, 0x74, 0xa4, 0x1d, 0x85,
	0xcf, 0xc1, 0xa8, 0x58, 0xd6, 0x99, 0xed, 0x07, 0x58, 0x83, 0xdc, 0x23, 0x4b, 0x47, 0xd4, 0x11,
	0x6e, 0x5e, 0x14, 0xd6, 0x85, 0x63, 0xe1, 0x41, 0x92, 0x7e, 0x40, 0x80, 0xcb, 0x8d, 0xc3, 0xe5,
	0x3a, 0xdd, 0xc3, 0x35, 0x1e, 0xf2, 0x40, 0x3c, 0xe4, 0x1f, 0x11, 0x4c, 0xa8, 0xd4, 0xf3, 0x99,
	0x4b, 0xff, 0x37, 0x98, 0x75, 0xc8, 0xde, 0xa2, 0xfe, 0xc6, 0xee, 0x55, 0x4e, 0xe5, 0x37, 0xb9,
	0x16, 0xf2, 0xd3, 0x5d, 0xc8, 0xf9, 0x93, 0xd0, 0x42, 0x32, 0x0b, 0xa3, 0xfb, 0x5c, 0x7e, 0x90,
	0x3a, 0x62, 0x45, 0xee, 0x2d, 0x85, 0x67, 0xa3, 0x30, 0x24, 0xce, 0x23, 0xfe, 0x02, 0x41, 0xb2,
	0xa5, 0xce, 0x38, 0xf6, 0x86, 0xd0, 0xa5, 0xe1, 0xd9, 0xfe, 0x27, 0x56, 0xca, 0xbf, 0x50, 0x42,
	0x70, 0x9f, 0xfd, 0xf6, 0xc7, 0x57, 0x89, 0x33, 0x78, 0x3a, 0xb8, 0xa7, 0x3e, 0x16, 0xa6, 0xeb,
	0xbb, 0x03, 0x63, 0x2e, 0x9c, 0x14, 0xf8, 0x6b, 0x04, 0xc9, 0xea, 0x81, 0xc0, 0x54, 0x5f, 0x1d,
	0xcc, 0xfc, 0x0b, 0x45, 0xf4, 0x98, 0x63, 0xb9, 0x20, 0x9d, 0xe5, 0x58, 0xc2, 0xbb, 0xfe, 0x3e,
	0x88, 0xe6, 0xc3, 0x81, 0xf0, 0x39, 0x82, 0x54, 0x44, 0xcf, 0x71, 0x3e, 0xae, 0x5c, 0xaf, 0xf0,
	0x67, 0xa7, 0x7a, 0x66, 0x47, 0x29, 0xb8, 0x5e, 0xf7, 0x34, 0x68, 0xae, 0x4f, 0x83, 0xbe, 0x43,
	0x30, 0x12, 0x95, 0x53, 0x2c, 0xc7, 0x37, 0xa9, 0x67, 0x3a, 0x64, 0x2f, 0x1d, 0x3c, 0x40, 0xe8,
	0x88, 0xf4, 0x76, 0x27, 0xc6, 0x19, 0xfc, 0x66, 0x2c, 0xc6, 0x79, 0x8f, 0x27, 0xc1, 0xcf, 0x10,
	0x40, 0x5b, 0x7e, 0xf1, 0xc5, 0xb8, 0xba, 0x3d, 0x32, 0x9d, 0x9d, 0x6e, 0xb9, 0x47, 0x5e, 0x5a,
	0xf2, 0x6b, 0xad, 0x97, 0x16, 0xc9, 0x7c, 0xae, 0xc8, 0x30, 0xb9, 0x67, 0x4f, 0xf1, 0x54, 0xb7,
	0xb9, 0xea, 0xbb, 0x4d, 0xdd, 0xef, 0x64, 0x31, 0x1b, 0x6e, 0xff, 0xbe, 0x2c, 0xfc, 0x00, 0xd2,
	0x3c, 0x9a, 0xc3, 0xbf, 0x23, 0x48, 0x45, 0xe4, 0x35, 0x7e, 0xeb, 0x7b, 0x87, 0x41, 0x3f, 0x26,
	0x4f, 0xd0, 0x73, 0x65, 0x09, 0x0e, 0x9c, 0x33, 0xd4, 0xf6, 0x03, 0x71, 0x7c, 0x4b, 0xea, 0xb3,
	0x53, 0x94, 0x67, 0x0e, 0x48, 0xfe, 0x8c, 0x20, 0x15, 0x11, 0xf7, 0x78, 0x92, 0xbd, 0x53, 0xa0,
	0x1f, 0x49, 0xf2, 0xea, 0xdb, 0x75, 0x30, 0x06, 0x66, 0xa3, 0xc5, 0xe0, 0x17, 0x04, 0x23, 0x51,
	0xad, 0x8f, 0x3f, 0x19, 0x7b, 0x4c, 0x85, 0x7e, 0x1c, 0x36, 0xff, 0x25, 0x87, 0x39, 0xe9, 0x5c,
	0x3c, 0x07, 0x57, 0x60, 0x09, 0x48, 0xfc, 0x84, 0x60, 0x62, 0x0f, 0xf5, 0xc7, 0x57, 0xfb, 0xe8,
	0xf2, 0x3e, 0xe3, 0x22, 0x1b, 0xfb, 0x7e, 0xd5, 0x1d, 0x24, 0x5d, 0xe5, 0x78, 0x2f, 0xe1, 0x7c,
	0x2c, 0xde, 0xc8, 0x67, 0x06, 0x11, 0x97, 0x7d, 0xf0, 0x5c, 0x39, 0xb5, 0xef, 0xdb, 0xc1, 0xaf,
	0xca, 0xed, 0x6d, 0xdf, 0x77, 0xbc, 0x79, 0x59, 0xbe, 0x7f, 0xbf, 0xe7, 0xd5, 0x81, 0x34, 0xfd,
	0x6d, 0xf1, 0x2d, 0xe3, 0xa2, 0x63, 0x11, 0x7f, 0x8b, 0xb9, 0x8d, 0x0b, 0xfd, 0xdc, 0xdb, 0xa5,
	0x16, 0x9e, 0x22, 0x78, 0x5d, 0x67, 0x8d, 0x18, 0x96, 0x0b, 0xc0, 0xf7, 0xb8, 0x12, 0x6c, 0x4c,
	0x05, 0xdd, 0x29, 0x86, 0x9e, 0x06, 0x0b, 0xe6, 0x61, 0x9e, 0xb9, 0x86, 0x6c, 0x50, 0x9b, 0x6f,
	0x9b, 0xdc, 0xae, 0xb5, 0xd7, 0xd7, 0x95, 0x6b, 0xed, 0x7f, 0x7f, 0x21, 0xf4, 0x4d, 0x22, 0x51,
	0xbc, 0xf9, 0x7d, 0x22, 0x7b, 0x4b, 0xa4, 0x5b, 0xe4, 0x85, 0x8b, 0xed, 0xc2, 0x1b, 0x85, 0xcd,
	0x21, 0x9e, 0xf5, 0xca, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xad, 0x7d, 0xe4, 0x5e, 0x69, 0x12,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AgentsClient is the client API for Agents service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AgentsClient interface {
	// Retrieves the specified agent.
	GetAgent(ctx context.Context, in *GetAgentRequest, opts ...grpc.CallOption) (*Agent, error)
	// Creates/updates the specified agent.
	SetAgent(ctx context.Context, in *SetAgentRequest, opts ...grpc.CallOption) (*Agent, error)
	// Deletes the specified agent.
	DeleteAgent(ctx context.Context, in *DeleteAgentRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns the list of agents.
	//
	// Since there is at most one conversational agent per project, this method is
	// useful primarily for listing all agents across projects the caller has
	// access to. One can achieve that with a wildcard project collection id "-".
	// Refer to [List
	// Sub-Collections](https://cloud.google.com/apis/design/design_patterns#list_sub-collections).
	SearchAgents(ctx context.Context, in *SearchAgentsRequest, opts ...grpc.CallOption) (*SearchAgentsResponse, error)
	// Trains the specified agent.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	TrainAgent(ctx context.Context, in *TrainAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Exports the specified agent to a ZIP file.
	//
	// Operation <response: [ExportAgentResponse][google.cloud.dialogflow.v2.ExportAgentResponse]>
	ExportAgent(ctx context.Context, in *ExportAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Imports the specified agent from a ZIP file.
	//
	// Uploads new intents and entity types without deleting the existing ones.
	// Intents and entity types with the same name are replaced with the new
	// versions from ImportAgentRequest.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	ImportAgent(ctx context.Context, in *ImportAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Restores the specified agent from a ZIP file.
	//
	// Replaces the current agent version with a new one. All the intents and
	// entity types in the older version are deleted.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	RestoreAgent(ctx context.Context, in *RestoreAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets agent validation result. Agent validation is performed during
	// training time and is updated automatically when training is completed.
	GetValidationResult(ctx context.Context, in *GetValidationResultRequest, opts ...grpc.CallOption) (*ValidationResult, error)
}

type agentsClient struct {
	cc grpc.ClientConnInterface
}

func NewAgentsClient(cc grpc.ClientConnInterface) AgentsClient {
	return &agentsClient{cc}
}

func (c *agentsClient) GetAgent(ctx context.Context, in *GetAgentRequest, opts ...grpc.CallOption) (*Agent, error) {
	out := new(Agent)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Agents/GetAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) SetAgent(ctx context.Context, in *SetAgentRequest, opts ...grpc.CallOption) (*Agent, error) {
	out := new(Agent)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Agents/SetAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) DeleteAgent(ctx context.Context, in *DeleteAgentRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Agents/DeleteAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) SearchAgents(ctx context.Context, in *SearchAgentsRequest, opts ...grpc.CallOption) (*SearchAgentsResponse, error) {
	out := new(SearchAgentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Agents/SearchAgents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) TrainAgent(ctx context.Context, in *TrainAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Agents/TrainAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) ExportAgent(ctx context.Context, in *ExportAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Agents/ExportAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) ImportAgent(ctx context.Context, in *ImportAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Agents/ImportAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) RestoreAgent(ctx context.Context, in *RestoreAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Agents/RestoreAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) GetValidationResult(ctx context.Context, in *GetValidationResultRequest, opts ...grpc.CallOption) (*ValidationResult, error) {
	out := new(ValidationResult)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Agents/GetValidationResult", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AgentsServer is the server API for Agents service.
type AgentsServer interface {
	// Retrieves the specified agent.
	GetAgent(context.Context, *GetAgentRequest) (*Agent, error)
	// Creates/updates the specified agent.
	SetAgent(context.Context, *SetAgentRequest) (*Agent, error)
	// Deletes the specified agent.
	DeleteAgent(context.Context, *DeleteAgentRequest) (*empty.Empty, error)
	// Returns the list of agents.
	//
	// Since there is at most one conversational agent per project, this method is
	// useful primarily for listing all agents across projects the caller has
	// access to. One can achieve that with a wildcard project collection id "-".
	// Refer to [List
	// Sub-Collections](https://cloud.google.com/apis/design/design_patterns#list_sub-collections).
	SearchAgents(context.Context, *SearchAgentsRequest) (*SearchAgentsResponse, error)
	// Trains the specified agent.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	TrainAgent(context.Context, *TrainAgentRequest) (*longrunning.Operation, error)
	// Exports the specified agent to a ZIP file.
	//
	// Operation <response: [ExportAgentResponse][google.cloud.dialogflow.v2.ExportAgentResponse]>
	ExportAgent(context.Context, *ExportAgentRequest) (*longrunning.Operation, error)
	// Imports the specified agent from a ZIP file.
	//
	// Uploads new intents and entity types without deleting the existing ones.
	// Intents and entity types with the same name are replaced with the new
	// versions from ImportAgentRequest.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	ImportAgent(context.Context, *ImportAgentRequest) (*longrunning.Operation, error)
	// Restores the specified agent from a ZIP file.
	//
	// Replaces the current agent version with a new one. All the intents and
	// entity types in the older version are deleted.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	RestoreAgent(context.Context, *RestoreAgentRequest) (*longrunning.Operation, error)
	// Gets agent validation result. Agent validation is performed during
	// training time and is updated automatically when training is completed.
	GetValidationResult(context.Context, *GetValidationResultRequest) (*ValidationResult, error)
}

// UnimplementedAgentsServer can be embedded to have forward compatible implementations.
type UnimplementedAgentsServer struct {
}

func (*UnimplementedAgentsServer) GetAgent(ctx context.Context, req *GetAgentRequest) (*Agent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAgent not implemented")
}
func (*UnimplementedAgentsServer) SetAgent(ctx context.Context, req *SetAgentRequest) (*Agent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetAgent not implemented")
}
func (*UnimplementedAgentsServer) DeleteAgent(ctx context.Context, req *DeleteAgentRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAgent not implemented")
}
func (*UnimplementedAgentsServer) SearchAgents(ctx context.Context, req *SearchAgentsRequest) (*SearchAgentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchAgents not implemented")
}
func (*UnimplementedAgentsServer) TrainAgent(ctx context.Context, req *TrainAgentRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TrainAgent not implemented")
}
func (*UnimplementedAgentsServer) ExportAgent(ctx context.Context, req *ExportAgentRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportAgent not implemented")
}
func (*UnimplementedAgentsServer) ImportAgent(ctx context.Context, req *ImportAgentRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportAgent not implemented")
}
func (*UnimplementedAgentsServer) RestoreAgent(ctx context.Context, req *RestoreAgentRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreAgent not implemented")
}
func (*UnimplementedAgentsServer) GetValidationResult(ctx context.Context, req *GetValidationResultRequest) (*ValidationResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetValidationResult not implemented")
}

func RegisterAgentsServer(s *grpc.Server, srv AgentsServer) {
	s.RegisterService(&_Agents_serviceDesc, srv)
}

func _Agents_GetAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).GetAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Agents/GetAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).GetAgent(ctx, req.(*GetAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_SetAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).SetAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Agents/SetAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).SetAgent(ctx, req.(*SetAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_DeleteAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).DeleteAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Agents/DeleteAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).DeleteAgent(ctx, req.(*DeleteAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_SearchAgents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAgentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).SearchAgents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Agents/SearchAgents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).SearchAgents(ctx, req.(*SearchAgentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_TrainAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TrainAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).TrainAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Agents/TrainAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).TrainAgent(ctx, req.(*TrainAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_ExportAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).ExportAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Agents/ExportAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).ExportAgent(ctx, req.(*ExportAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_ImportAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).ImportAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Agents/ImportAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).ImportAgent(ctx, req.(*ImportAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_RestoreAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).RestoreAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Agents/RestoreAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).RestoreAgent(ctx, req.(*RestoreAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_GetValidationResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetValidationResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).GetValidationResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Agents/GetValidationResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).GetValidationResult(ctx, req.(*GetValidationResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Agents_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.Agents",
	HandlerType: (*AgentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAgent",
			Handler:    _Agents_GetAgent_Handler,
		},
		{
			MethodName: "SetAgent",
			Handler:    _Agents_SetAgent_Handler,
		},
		{
			MethodName: "DeleteAgent",
			Handler:    _Agents_DeleteAgent_Handler,
		},
		{
			MethodName: "SearchAgents",
			Handler:    _Agents_SearchAgents_Handler,
		},
		{
			MethodName: "TrainAgent",
			Handler:    _Agents_TrainAgent_Handler,
		},
		{
			MethodName: "ExportAgent",
			Handler:    _Agents_ExportAgent_Handler,
		},
		{
			MethodName: "ImportAgent",
			Handler:    _Agents_ImportAgent_Handler,
		},
		{
			MethodName: "RestoreAgent",
			Handler:    _Agents_RestoreAgent_Handler,
		},
		{
			MethodName: "GetValidationResult",
			Handler:    _Agents_GetValidationResult_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/agent.proto",
}
