// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/hive/pkg/apis/hive/v1"
	scheme "github.com/openshift/hive/pkg/client/clientset-generated/clientset/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// SyncSetsGetter has a method to return a SyncSetInterface.
// A group's client should implement this interface.
type SyncSetsGetter interface {
	SyncSets(namespace string) SyncSetInterface
}

// SyncSetInterface has methods to work with SyncSet resources.
type SyncSetInterface interface {
	Create(*v1.SyncSet) (*v1.SyncSet, error)
	Update(*v1.SyncSet) (*v1.SyncSet, error)
	UpdateStatus(*v1.SyncSet) (*v1.SyncSet, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.SyncSet, error)
	List(opts metav1.ListOptions) (*v1.SyncSetList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.SyncSet, err error)
	SyncSetExpansion
}

// syncSets implements SyncSetInterface
type syncSets struct {
	client rest.Interface
	ns     string
}

// newSyncSets returns a SyncSets
func newSyncSets(c *HiveV1Client, namespace string) *syncSets {
	return &syncSets{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the syncSet, and returns the corresponding syncSet object, and an error if there is any.
func (c *syncSets) Get(name string, options metav1.GetOptions) (result *v1.SyncSet, err error) {
	result = &v1.SyncSet{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("syncsets").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of SyncSets that match those selectors.
func (c *syncSets) List(opts metav1.ListOptions) (result *v1.SyncSetList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.SyncSetList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("syncsets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested syncSets.
func (c *syncSets) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("syncsets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a syncSet and creates it.  Returns the server's representation of the syncSet, and an error, if there is any.
func (c *syncSets) Create(syncSet *v1.SyncSet) (result *v1.SyncSet, err error) {
	result = &v1.SyncSet{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("syncsets").
		Body(syncSet).
		Do().
		Into(result)
	return
}

// Update takes the representation of a syncSet and updates it. Returns the server's representation of the syncSet, and an error, if there is any.
func (c *syncSets) Update(syncSet *v1.SyncSet) (result *v1.SyncSet, err error) {
	result = &v1.SyncSet{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("syncsets").
		Name(syncSet.Name).
		Body(syncSet).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *syncSets) UpdateStatus(syncSet *v1.SyncSet) (result *v1.SyncSet, err error) {
	result = &v1.SyncSet{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("syncsets").
		Name(syncSet.Name).
		SubResource("status").
		Body(syncSet).
		Do().
		Into(result)
	return
}

// Delete takes name of the syncSet and deletes it. Returns an error if one occurs.
func (c *syncSets) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("syncsets").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *syncSets) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("syncsets").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched syncSet.
func (c *syncSets) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.SyncSet, err error) {
	result = &v1.SyncSet{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("syncsets").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
