package ci

import (
	"testing"

	"github.com/gobuffalo/genny/gentest"
	"github.com/gobuffalo/meta"
	"github.com/stretchr/testify/require"
)

func Test_New(t *testing.T) {
	r := require.New(t)

	g, err := New(&Options{
		Provider: "travis",
		DBType:   "postgres",
	})
	r.NoError(err)

	run := gentest.NewRunner()
	run.With(g)

	r.NoError(run.Run())

	res := run.Results()

	r.Len(res.Commands, 0)
	r.Len(res.Files, 1)

	f := res.Files[0]
	r.Equal(".travis.yml", f.Name())
}

func Test_New_Gitlab(t *testing.T) {
	r := require.New(t)

	app := meta.New(".")
	app.WithPop = true

	g, err := New(&Options{
		App:      app,
		Provider: "gitlab",
		DBType:   "postgres",
	})
	r.NoError(err)

	run := gentest.NewRunner()
	run.With(g)

	r.NoError(run.Run())

	res := run.Results()

	r.Len(res.Commands, 0)
	r.Len(res.Files, 1)

	f := res.Files[0]
	r.Equal(".gitlab-ci.yml", f.Name())
	r.Contains(f.String(), "postgres:5432")
}

func Test_New_Gitlab_No_pop(t *testing.T) {
	r := require.New(t)

	g, err := New(&Options{
		Provider: "gitlab",
		DBType:   "postgres",
	})
	r.NoError(err)

	run := gentest.NewRunner()
	run.With(g)

	r.NoError(run.Run())

	res := run.Results()

	r.Len(res.Commands, 0)
	r.Len(res.Files, 1)

	f := res.Files[0]
	r.Equal(".gitlab-ci.yml", f.Name())
	r.NotContains(f.String(), "postgres:5432")
}
