package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBClusterDescription invokes the adb.ModifyDBClusterDescription API synchronously
// api document: https://help.aliyun.com/api/adb/modifydbclusterdescription.html
func (client *Client) ModifyDBClusterDescription(request *ModifyDBClusterDescriptionRequest) (response *ModifyDBClusterDescriptionResponse, err error) {
	response = CreateModifyDBClusterDescriptionResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBClusterDescriptionWithChan invokes the adb.ModifyDBClusterDescription API asynchronously
// api document: https://help.aliyun.com/api/adb/modifydbclusterdescription.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDBClusterDescriptionWithChan(request *ModifyDBClusterDescriptionRequest) (<-chan *ModifyDBClusterDescriptionResponse, <-chan error) {
	responseChan := make(chan *ModifyDBClusterDescriptionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBClusterDescription(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBClusterDescriptionWithCallback invokes the adb.ModifyDBClusterDescription API asynchronously
// api document: https://help.aliyun.com/api/adb/modifydbclusterdescription.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDBClusterDescriptionWithCallback(request *ModifyDBClusterDescriptionRequest, callback func(response *ModifyDBClusterDescriptionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBClusterDescriptionResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBClusterDescription(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBClusterDescriptionRequest is the request struct for api ModifyDBClusterDescription
type ModifyDBClusterDescriptionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBClusterDescription string           `position:"Query" name:"DBClusterDescription"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ModifyDBClusterDescriptionResponse is the response struct for api ModifyDBClusterDescription
type ModifyDBClusterDescriptionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDBClusterDescriptionRequest creates a request to invoke ModifyDBClusterDescription API
func CreateModifyDBClusterDescriptionRequest() (request *ModifyDBClusterDescriptionRequest) {
	request = &ModifyDBClusterDescriptionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "ModifyDBClusterDescription", "ads", "openAPI")
	return
}

// CreateModifyDBClusterDescriptionResponse creates a response to parse from ModifyDBClusterDescription response
func CreateModifyDBClusterDescriptionResponse() (response *ModifyDBClusterDescriptionResponse) {
	response = &ModifyDBClusterDescriptionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
