package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTopicList invokes the aegis.DescribeTopicList API synchronously
// api document: https://help.aliyun.com/api/aegis/describetopiclist.html
func (client *Client) DescribeTopicList(request *DescribeTopicListRequest) (response *DescribeTopicListResponse, err error) {
	response = CreateDescribeTopicListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTopicListWithChan invokes the aegis.DescribeTopicList API asynchronously
// api document: https://help.aliyun.com/api/aegis/describetopiclist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTopicListWithChan(request *DescribeTopicListRequest) (<-chan *DescribeTopicListResponse, <-chan error) {
	responseChan := make(chan *DescribeTopicListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTopicList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTopicListWithCallback invokes the aegis.DescribeTopicList API asynchronously
// api document: https://help.aliyun.com/api/aegis/describetopiclist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTopicListWithCallback(request *DescribeTopicListRequest, callback func(response *DescribeTopicListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTopicListResponse
		var err error
		defer close(result)
		response, err = client.DescribeTopicList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTopicListRequest is the request struct for api DescribeTopicList
type DescribeTopicListRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeTopicListResponse is the response struct for api DescribeTopicList
type DescribeTopicListResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	TopicList []string `json:"TopicList" xml:"TopicList"`
}

// CreateDescribeTopicListRequest creates a request to invoke DescribeTopicList API
func CreateDescribeTopicListRequest() (request *DescribeTopicListRequest) {
	request = &DescribeTopicListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeTopicList", "vipaegis", "openAPI")
	return
}

// CreateDescribeTopicListResponse creates a response to parse from DescribeTopicList response
func CreateDescribeTopicListResponse() (response *DescribeTopicListResponse) {
	response = &DescribeTopicListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
