package aliyuncvc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMembers invokes the aliyuncvc.ListMembers API synchronously
// api document: https://help.aliyun.com/api/aliyuncvc/listmembers.html
func (client *Client) ListMembers(request *ListMembersRequest) (response *ListMembersResponse, err error) {
	response = CreateListMembersResponse()
	err = client.DoAction(request, response)
	return
}

// ListMembersWithChan invokes the aliyuncvc.ListMembers API asynchronously
// api document: https://help.aliyun.com/api/aliyuncvc/listmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListMembersWithChan(request *ListMembersRequest) (<-chan *ListMembersResponse, <-chan error) {
	responseChan := make(chan *ListMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMembersWithCallback invokes the aliyuncvc.ListMembers API asynchronously
// api document: https://help.aliyun.com/api/aliyuncvc/listmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListMembersWithCallback(request *ListMembersRequest, callback func(response *ListMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMembersResponse
		var err error
		defer close(result)
		response, err = client.ListMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMembersRequest is the request struct for api ListMembers
type ListMembersRequest struct {
	*requests.RpcRequest
	MeetingUUID string `position:"Query" name:"MeetingUUID"`
}

// ListMembersResponse is the response struct for api ListMembers
type ListMembersResponse struct {
	*responses.BaseResponse
	ErrorCode   int         `json:"ErrorCode" xml:"ErrorCode"`
	Message     string      `json:"Message" xml:"Message"`
	Success     bool        `json:"Success" xml:"Success"`
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	MeetingInfo MeetingInfo `json:"MeetingInfo" xml:"MeetingInfo"`
}

// CreateListMembersRequest creates a request to invoke ListMembers API
func CreateListMembersRequest() (request *ListMembersRequest) {
	request = &ListMembersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aliyuncvc", "2019-10-30", "ListMembers", "aliyuncvc", "openAPI")
	return
}

// CreateListMembersResponse creates a response to parse from ListMembers response
func CreateListMembersResponse() (response *ListMembersResponse) {
	response = &ListMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
