package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CommitContactFlowVersionModification invokes the ccc.CommitContactFlowVersionModification API synchronously
// api document: https://help.aliyun.com/api/ccc/commitcontactflowversionmodification.html
func (client *Client) CommitContactFlowVersionModification(request *CommitContactFlowVersionModificationRequest) (response *CommitContactFlowVersionModificationResponse, err error) {
	response = CreateCommitContactFlowVersionModificationResponse()
	err = client.DoAction(request, response)
	return
}

// CommitContactFlowVersionModificationWithChan invokes the ccc.CommitContactFlowVersionModification API asynchronously
// api document: https://help.aliyun.com/api/ccc/commitcontactflowversionmodification.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CommitContactFlowVersionModificationWithChan(request *CommitContactFlowVersionModificationRequest) (<-chan *CommitContactFlowVersionModificationResponse, <-chan error) {
	responseChan := make(chan *CommitContactFlowVersionModificationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CommitContactFlowVersionModification(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CommitContactFlowVersionModificationWithCallback invokes the ccc.CommitContactFlowVersionModification API asynchronously
// api document: https://help.aliyun.com/api/ccc/commitcontactflowversionmodification.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CommitContactFlowVersionModificationWithCallback(request *CommitContactFlowVersionModificationRequest, callback func(response *CommitContactFlowVersionModificationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CommitContactFlowVersionModificationResponse
		var err error
		defer close(result)
		response, err = client.CommitContactFlowVersionModification(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CommitContactFlowVersionModificationRequest is the request struct for api CommitContactFlowVersionModification
type CommitContactFlowVersionModificationRequest struct {
	*requests.RpcRequest
	Canvas               string `position:"Body" name:"Canvas"`
	Content              string `position:"Body" name:"Content"`
	InstanceId           string `position:"Query" name:"InstanceId"`
	ContactFlowVersionId string `position:"Query" name:"ContactFlowVersionId"`
}

// CommitContactFlowVersionModificationResponse is the response struct for api CommitContactFlowVersionModification
type CommitContactFlowVersionModificationResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	Success            bool               `json:"Success" xml:"Success"`
	Code               string             `json:"Code" xml:"Code"`
	Message            string             `json:"Message" xml:"Message"`
	HttpStatusCode     int                `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ContactFlowVersion ContactFlowVersion `json:"ContactFlowVersion" xml:"ContactFlowVersion"`
}

// CreateCommitContactFlowVersionModificationRequest creates a request to invoke CommitContactFlowVersionModification API
func CreateCommitContactFlowVersionModificationRequest() (request *CommitContactFlowVersionModificationRequest) {
	request = &CommitContactFlowVersionModificationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "CommitContactFlowVersionModification", "", "")
	return
}

// CreateCommitContactFlowVersionModificationResponse creates a response to parse from CommitContactFlowVersionModification response
func CreateCommitContactFlowVersionModificationResponse() (response *CommitContactFlowVersionModificationResponse) {
	response = &CommitContactFlowVersionModificationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
