package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCabInstance invokes the ccc.CreateCabInstance API synchronously
// api document: https://help.aliyun.com/api/ccc/createcabinstance.html
func (client *Client) CreateCabInstance(request *CreateCabInstanceRequest) (response *CreateCabInstanceResponse, err error) {
	response = CreateCreateCabInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCabInstanceWithChan invokes the ccc.CreateCabInstance API asynchronously
// api document: https://help.aliyun.com/api/ccc/createcabinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateCabInstanceWithChan(request *CreateCabInstanceRequest) (<-chan *CreateCabInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateCabInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCabInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCabInstanceWithCallback invokes the ccc.CreateCabInstance API asynchronously
// api document: https://help.aliyun.com/api/ccc/createcabinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateCabInstanceWithCallback(request *CreateCabInstanceRequest, callback func(response *CreateCabInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCabInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateCabInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCabInstanceRequest is the request struct for api CreateCabInstance
type CreateCabInstanceRequest struct {
	*requests.RpcRequest
	MaxConcurrentConversation requests.Integer `position:"Query" name:"MaxConcurrentConversation"`
	InstanceName              string           `position:"Query" name:"InstanceName"`
	CallCenterInstanceId      string           `position:"Query" name:"CallCenterInstanceId"`
	InstanceDescription       string           `position:"Query" name:"InstanceDescription"`
}

// CreateCabInstanceResponse is the response struct for api CreateCabInstance
type CreateCabInstanceResponse struct {
	*responses.BaseResponse
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Success        bool     `json:"Success" xml:"Success"`
	Code           string   `json:"Code" xml:"Code"`
	Message        string   `json:"Message" xml:"Message"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Instance       Instance `json:"Instance" xml:"Instance"`
}

// CreateCreateCabInstanceRequest creates a request to invoke CreateCabInstance API
func CreateCreateCabInstanceRequest() (request *CreateCabInstanceRequest) {
	request = &CreateCabInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "CreateCabInstance", "", "")
	return
}

// CreateCreateCabInstanceResponse creates a response to parse from CreateCabInstance response
func CreateCreateCabInstanceResponse() (response *CreateCabInstanceResponse) {
	response = &CreateCabInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
