package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PickOutboundNumbersByTags invokes the ccc.PickOutboundNumbersByTags API synchronously
// api document: https://help.aliyun.com/api/ccc/pickoutboundnumbersbytags.html
func (client *Client) PickOutboundNumbersByTags(request *PickOutboundNumbersByTagsRequest) (response *PickOutboundNumbersByTagsResponse, err error) {
	response = CreatePickOutboundNumbersByTagsResponse()
	err = client.DoAction(request, response)
	return
}

// PickOutboundNumbersByTagsWithChan invokes the ccc.PickOutboundNumbersByTags API asynchronously
// api document: https://help.aliyun.com/api/ccc/pickoutboundnumbersbytags.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PickOutboundNumbersByTagsWithChan(request *PickOutboundNumbersByTagsRequest) (<-chan *PickOutboundNumbersByTagsResponse, <-chan error) {
	responseChan := make(chan *PickOutboundNumbersByTagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PickOutboundNumbersByTags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PickOutboundNumbersByTagsWithCallback invokes the ccc.PickOutboundNumbersByTags API asynchronously
// api document: https://help.aliyun.com/api/ccc/pickoutboundnumbersbytags.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PickOutboundNumbersByTagsWithCallback(request *PickOutboundNumbersByTagsRequest, callback func(response *PickOutboundNumbersByTagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PickOutboundNumbersByTagsResponse
		var err error
		defer close(result)
		response, err = client.PickOutboundNumbersByTags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PickOutboundNumbersByTagsRequest is the request struct for api PickOutboundNumbersByTags
type PickOutboundNumbersByTagsRequest struct {
	*requests.RpcRequest
	PrioritizedCallerArea *[]string        `position:"Query" name:"PrioritizedCallerArea"  type:"Repeated"`
	Count                 requests.Integer `position:"Query" name:"Count"`
	InstanceId            string           `position:"Query" name:"InstanceId"`
	ServiceTag            *[]string        `position:"Query" name:"ServiceTag"  type:"Repeated"`
	SkillGroupId          *[]string        `position:"Query" name:"SkillGroupId"  type:"Repeated"`
	CalleeNumber          string           `position:"Query" name:"CalleeNumber"`
}

// PickOutboundNumbersByTagsResponse is the response struct for api PickOutboundNumbersByTags
type PickOutboundNumbersByTagsResponse struct {
	*responses.BaseResponse
	RequestId       string                                     `json:"RequestId" xml:"RequestId"`
	Success         bool                                       `json:"Success" xml:"Success"`
	Code            string                                     `json:"Code" xml:"Code"`
	Message         string                                     `json:"Message" xml:"Message"`
	HttpStatusCode  int                                        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DialNumberPairs DialNumberPairsInPickOutboundNumbersByTags `json:"DialNumberPairs" xml:"DialNumberPairs"`
}

// CreatePickOutboundNumbersByTagsRequest creates a request to invoke PickOutboundNumbersByTags API
func CreatePickOutboundNumbersByTagsRequest() (request *PickOutboundNumbersByTagsRequest) {
	request = &PickOutboundNumbersByTagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "PickOutboundNumbersByTags", "", "")
	return
}

// CreatePickOutboundNumbersByTagsResponse creates a response to parse from PickOutboundNumbersByTags response
func CreatePickOutboundNumbersByTagsResponse() (response *PickOutboundNumbersByTagsResponse) {
	response = &PickOutboundNumbersByTagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
