package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainTopClientIpVisit invokes the cdn.DescribeDomainTopClientIpVisit API synchronously
// api document: https://help.aliyun.com/api/cdn/describedomaintopclientipvisit.html
func (client *Client) DescribeDomainTopClientIpVisit(request *DescribeDomainTopClientIpVisitRequest) (response *DescribeDomainTopClientIpVisitResponse, err error) {
	response = CreateDescribeDomainTopClientIpVisitResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainTopClientIpVisitWithChan invokes the cdn.DescribeDomainTopClientIpVisit API asynchronously
// api document: https://help.aliyun.com/api/cdn/describedomaintopclientipvisit.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDomainTopClientIpVisitWithChan(request *DescribeDomainTopClientIpVisitRequest) (<-chan *DescribeDomainTopClientIpVisitResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainTopClientIpVisitResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainTopClientIpVisit(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainTopClientIpVisitWithCallback invokes the cdn.DescribeDomainTopClientIpVisit API asynchronously
// api document: https://help.aliyun.com/api/cdn/describedomaintopclientipvisit.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDomainTopClientIpVisitWithCallback(request *DescribeDomainTopClientIpVisitRequest, callback func(response *DescribeDomainTopClientIpVisitResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainTopClientIpVisitResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainTopClientIpVisit(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainTopClientIpVisitRequest is the request struct for api DescribeDomainTopClientIpVisit
type DescribeDomainTopClientIpVisitRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	Limit          string           `position:"Query" name:"Limit"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	SortBy         string           `position:"Query" name:"SortBy"`
}

// DescribeDomainTopClientIpVisitResponse is the response struct for api DescribeDomainTopClientIpVisit
type DescribeDomainTopClientIpVisitResponse struct {
	*responses.BaseResponse
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	ClientIpList []ClientIp `json:"ClientIpList" xml:"ClientIpList"`
}

// CreateDescribeDomainTopClientIpVisitRequest creates a request to invoke DescribeDomainTopClientIpVisit API
func CreateDescribeDomainTopClientIpVisitRequest() (request *DescribeDomainTopClientIpVisitRequest) {
	request = &DescribeDomainTopClientIpVisitRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeDomainTopClientIpVisit", "", "")
	return
}

// CreateDescribeDomainTopClientIpVisitResponse creates a response to parse from DescribeDomainTopClientIpVisit response
func CreateDescribeDomainTopClientIpVisitResponse() (response *DescribeDomainTopClientIpVisitResponse) {
	response = &DescribeDomainTopClientIpVisitResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
