package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutContact invokes the cms.PutContact API synchronously
// api document: https://help.aliyun.com/api/cms/putcontact.html
func (client *Client) PutContact(request *PutContactRequest) (response *PutContactResponse, err error) {
	response = CreatePutContactResponse()
	err = client.DoAction(request, response)
	return
}

// PutContactWithChan invokes the cms.PutContact API asynchronously
// api document: https://help.aliyun.com/api/cms/putcontact.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PutContactWithChan(request *PutContactRequest) (<-chan *PutContactResponse, <-chan error) {
	responseChan := make(chan *PutContactResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutContact(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutContactWithCallback invokes the cms.PutContact API asynchronously
// api document: https://help.aliyun.com/api/cms/putcontact.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PutContactWithCallback(request *PutContactRequest, callback func(response *PutContactResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutContactResponse
		var err error
		defer close(result)
		response, err = client.PutContact(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutContactRequest is the request struct for api PutContact
type PutContactRequest struct {
	*requests.RpcRequest
	ChannelsDingWebHook string `position:"Query" name:"Channels.DingWebHook"`
	ContactName         string `position:"Query" name:"ContactName"`
	ChannelsMail        string `position:"Query" name:"Channels.Mail"`
	ChannelsAliIM       string `position:"Query" name:"Channels.AliIM"`
	Describe            string `position:"Query" name:"Describe"`
	ChannelsSMS         string `position:"Query" name:"Channels.SMS"`
}

// PutContactResponse is the response struct for api PutContact
type PutContactResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePutContactRequest creates a request to invoke PutContact API
func CreatePutContactRequest() (request *PutContactRequest) {
	request = &PutContactRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "PutContact", "cms", "openAPI")
	return
}

// CreatePutContactResponse creates a response to parse from PutContact response
func CreatePutContactResponse() (response *PutContactResponse) {
	response = &PutContactResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
